(defun print-cvs-tin (foo)
  "Debug utility."
  (let ((cookie (tin-cookie cvs-cookie-handle foo))
	(stream (get-buffer-create "debug")))
    (princ "==============\n" stream)
    (princ (cvs-fileinfo->file-name cookie) stream)
    (princ "\n" stream)
    (princ (cvs-fileinfo->dir cookie) stream)
    (princ "\n" stream)
    (princ (cvs-fileinfo->full-log cookie) stream)
    (princ "\n" stream)
    (princ (cvs-fileinfo->marked cookie) stream)
    (princ "\n" stream)))

(defun parse-cvs-bug-mail ()
  "Try the current parser on a cvs bug message."
  (interactive)
  (goto-char (point-min))
  (re-search-forward
   "--- Contents of stdout buffer (\\([0-9]+\\) chars) ---\n")
  (let ((size (string-to-int (buffer-substring (match-beginning 1)
					       (match-end 1))))
	(beg (point))
	(stdout-buf (get-buffer-create "stdout")))
    (save-window-excursion (set-buffer stdout-buf) (erase-buffer))
    (goto-char (+ (point) size))
    (if (looking-at "\n")
	(forward-char))
    (if (not (looking-at "--- End of stdout buffer ---"))
	(error "Expected \"--- End of stdout buffer ---\" at point"))
    (princ (buffer-substring beg (point)) stdout-buf)
    (re-search-forward 
     "--- Contents of stderr buffer (\\([0-9]+\\) chars) ---\n")
    (let ((size (string-to-int (buffer-substring (match-beginning 1)
						 (match-end 1))))
	  (beg (point))
	  (stderr-buf (get-buffer-create "stderr")))
      (save-window-excursion (set-buffer stderr-buf) (erase-buffer))
      (goto-char (+ (point) size))
      (if (looking-at "\n")
	  (forward-char))
      (if (not (looking-at "--- End of stderr buffer ---"))
	  (error "Expected \"--- End of stderr buffer ---\" at point"))
      (princ (buffer-substring beg (point)) stderr-buf)
      (cvs-parse-update stdout-buf stderr-buf)))
  (switch-to-buffer-other-window "*cvs*"))
