/*
**  TestCase.m
**
**  This is a small and simple (but useful) test framework.
**
**  Copyright (c) 2001, 2002
**
**  Author:  Alexander Malmberg <alexander@malmberg.org>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <Foundation/NSObject.h>
#include <Foundation/NSException.h>
#include <Foundation/NSAutoreleasePool.h>
#include <Foundation/NSData.h>

#import <Pantomime/NSDataExtensions.h>

#include "TestCase.h"

@implementation TestCase

- (id) initWithName: (const char *)n
{
  self = [super init];
  name = n;
  
  sel = GSSelectorFromName(n);

  if ( !sel )
    {
      RELEASE(self);
      return nil;
    }
  
  return self;
}

-(void) runTest
{
	[self performSelector: sel];
}


+(void) runTestWithName: (const char *)n
{
  CREATE_AUTORELEASE_POOL(arp);
  TestCase *t=[[self alloc] initWithName: n];
  
  NS_DURING
    {
      [t runTest];
    }
  NS_HANDLER
    {
      NSLog(@"Caught exception during '%s'\n", n);
      NSLog(@"e='%@'\n", localException);
    }
  NS_ENDHANDLER
    
  DESTROY(arp);
}



-(void) objectIsKindOf: (Class)c : (id)o
{
	if (!o)
		[NSException
			raise: @"objectIsKindOf"
			format: @"got==nil"];

	if (![o isKindOf: c])
		[NSException
			raise: @"objectIsKindOf"
			format: @"expected '%s', got '%s'",c->name,[c class]->name];
}


-(void) equalInt: (int)expected : (int)got
{
	[self equalInt: expected : got  msg: nil];
}
-(void) equalInt: (int)expected : (int)got  msg: (NSString *)msg
{
	if (expected!=got)
		[NSException
			raise: @"equalInt"
			format: @"expected '%i', got '%i'. msg='%@'",expected,got,msg];
}

-(void) equalUnichar: (unichar)expected : (unichar)got
{
}
-(void) equalUnichar: (unichar)expected : (unichar)got  msg: (NSString *)msg
{
	if (expected!=got)
		[NSException
			raise: @"equalInt"
			format: @"expected '%04x', got '%04x'. msg='%@'",expected,got,msg];
}

-(void) equalString: (NSString *)expected : (NSString *)got
{
	if (!got)
		[NSException
			raise: @"equalString"
			format: @"got==nil"];

	if (![expected isEqual: got])
		[NSException
			raise: @"equalString"
			format: @"expected '%@', got '%@'",expected,got];
}

-(void) equalData: (NSData *)expected : (NSData *)got
{
	if (!got)
		[NSException
			raise: @"equalData"
			format: @"got==nil"];

	if (![expected isEqual: got])
		[NSException
			raise: @"equalData"
			format: @"expected:\n||%s||\ngot:\n||%s||",[expected cString],[got cString]];
}


@end

