/**************************************************************************
*** COPYRIGHT (c) 2002 by TransNexus, Inc.                              ***
***                                                                     ***
*** This software is property of TransNexus, Inc.                       ***
*** This software is freely available under license from TransNexus.    ***
*** The license terms and conditions for free use of this software by   ***
*** third parties are defined in the OSP Toolkit Software License       ***
*** Agreement (LICENSE.txt).  Any use of this software by third         ***
*** parties, which does not comply with the terms and conditions of the ***
*** OSP Toolkit Software License Agreement is prohibited without        ***
*** the prior, express, written consent of TransNexus, Inc.             ***
***                                                                     ***
*** Thank you for using the OSP ToolKit(TM).  Please report any bugs,   ***
*** suggestions or feedback to support@transnexus.com                   ***
***                                                                     ***
**************************************************************************/

/* ospmsgelem.h - Definitions for OSP message elements. */
#ifndef _OSPMSGELEM_H
#define _OSPMSGELEM_H

#include "osp/ospmsgpart.h"
#include "osp/ospmsgdesc.h"

/* Document types defined by OSP */
typedef enum {
    OSPC_MELEM_UNKNOWN = OSPC_MPART_UNKNOWN,
    OSPC_MELEM_UNDEFINED,
    /* Message element start */
    OSPC_MELEM_START = OSPC_MPART_START,
    OSPC_MELEM_ALMOSTOUTOFRESOURCES = OSPC_MELEM_START,
    OSPC_MELEM_ALERTTIME,
    OSPC_MELEM_AMOUNT,
    OSPC_MELEM_APPLID,
    OSPC_MELEM_ASSERTEDID,
    OSPC_MELEM_AUDIT,
    OSPC_MELEM_AUDITMAXMESSAGES,
    OSPC_MELEM_AUDITSTATE,
    OSPC_MELEM_AUDITTIMELIMIT,
    OSPC_MELEM_AUDITURL,
    OSPC_MELEM_AUTHCNF,
    OSPC_MELEM_AUTHIND,
    OSPC_MELEM_AUTHREQ,
    OSPC_MELEM_AUTHRSP,
    OSPC_MELEM_AUTHRZP,
    OSPC_MELEM_AUTHURL,
    OSPC_MELEM_CALLCATEGORY,
    OSPC_MELEM_CALLEDPARTYINFO,
    OSPC_MELEM_CALLID,
    OSPC_MELEM_CALLINGPARTYINFO,
    OSPC_MELEM_CALLTYPE,
    OSPC_MELEM_CAPIND,
    OSPC_MELEM_CDRPROXY,
    OSPC_MELEM_CDRPROXYFOLDER,
    OSPC_MELEM_CDRPROXYHOST,
    OSPC_MELEM_CDRPROXYSUBFOLDER,
    OSPC_MELEM_CHARGEINFO,
    OSPC_MELEM_CHARGINGVECTOR,
    OSPC_MELEM_CODE,
    OSPC_MELEM_CODEC,
    OSPC_MELEM_CONNECTTIME,
    OSPC_MELEM_CSAUDITTRIGGER,
    OSPC_MELEM_CURRENCY,
    OSPC_MELEM_CUSTID,
    OSPC_MELEM_CUSTINFO,
    OSPC_MELEM_DELAY,
    OSPC_MELEM_DELAYLIMIT,
    OSPC_MELEM_DELAYPREF,
    OSPC_MELEM_DESC,
    OSPC_MELEM_DEST,
    OSPC_MELEM_DESTALT,
    OSPC_MELEM_DESTAUDIOADDR,
    OSPC_MELEM_DESTINFO,
    OSPC_MELEM_DESTOSPVERSION,
    OSPC_MELEM_DESTREALM,
    OSPC_MELEM_DESTSIGADDR,
    OSPC_MELEM_DESTVIDEOADDR,
    OSPC_MELEM_DEVICEID,
    OSPC_MELEM_DEVICEINFO,
    OSPC_MELEM_DIVDEVINFO,
    OSPC_MELEM_DIVSRCINFO,
    OSPC_MELEM_ENDPOINT,
    OSPC_MELEM_ENDTIME,
    OSPC_MELEM_FINGERPRINT,
    OSPC_MELEM_FRACTION,
    OSPC_MELEM_FROM,
    OSPC_MELEM_GROUP,
    OSPC_MELEM_GROUPID,
    OSPC_MELEM_ICPIF,
    OSPC_MELEM_IDALG,
    OSPC_MELEM_IDCANON,
    OSPC_MELEM_IDENTITY,
    OSPC_MELEM_IDINFO,
    OSPC_MELEM_IDSIGN,
    OSPC_MELEM_IDTYPE,
    OSPC_MELEM_INCREMENT,
    OSPC_MELEM_REQUESTDATE,
    OSPC_MELEM_JIP,
    OSPC_MELEM_JITTER,
    OSPC_MELEM_LOSSRCVD,
    OSPC_MELEM_LOSSSENT,
    OSPC_MELEM_LOST,
    OSPC_MELEM_MAXDEST,
    OSPC_MELEM_MAXIMUM,
    OSPC_MELEM_MEAN,
    OSPC_MELEM_MESSAGE,
    OSPC_MELEM_METRICS,
    OSPC_MELEM_MINIMUM,
    OSPC_MELEM_MOSCQ,
    OSPC_MELEM_MOSLQ,
    OSPC_MELEM_NETTRANSCALLED,
    OSPC_MELEM_NETWORKTYPE,
    OSPC_MELEM_ONEWAYDELAY,
    OSPC_MELEM_PACKETS,
    OSPC_MELEM_POSTDIALDELAY,
    OSPC_MELEM_PRICINGCNF,
    OSPC_MELEM_PRICINGIND,
    OSPC_MELEM_PROTOCOL,
    OSPC_MELEM_REAUTHREQ,
    OSPC_MELEM_REAUTHRSP,
    OSPC_MELEM_RELATEDREASON,
    OSPC_MELEM_RELEASE,
    OSPC_MELEM_RESOURCES,
    OSPC_MELEM_RFACTOR,
    OSPC_MELEM_ROLE,
    OSPC_MELEM_ROLEFORMAT,
    OSPC_MELEM_ROLEINFO,
    OSPC_MELEM_ROLESTATE,
    OSPC_MELEM_ROLEVENDOR,
    OSPC_MELEM_RPID,
    OSPC_MELEM_RTDELAY,
    OSPC_MELEM_SAMPLES,
    OSPC_MELEM_SERVICE,
    OSPC_MELEM_SERVICEPROVIDER,
    OSPC_MELEM_SERVICETYPE,
    OSPC_MELEM_SESSIONID,
    OSPC_MELEM_SETUPATTEMPT,
    OSPC_MELEM_SRCALT,
    OSPC_MELEM_SRCAUDIOADDR,
    OSPC_MELEM_SRCINFO,
    OSPC_MELEM_SRCREALM,
    OSPC_MELEM_SRCSIGADDR,
    OSPC_MELEM_SRCVIDEOADDR,
    OSPC_MELEM_STARTTIME,
    OSPC_MELEM_STATISTICS,
    OSPC_MELEM_STATUS,
    OSPC_MELEM_SYSTEMID,
    OSPC_MELEM_TCCODE,
    OSPC_MELEM_TERMCAUSE,
    OSPC_MELEM_TIMESTAMP,
    OSPC_MELEM_TO,
    OSPC_MELEM_TOKEN,
    OSPC_MELEM_TOKENINFO,
    OSPC_MELEM_TOTALOCTETS,
    OSPC_MELEM_TOTALPACKETS,
    OSPC_MELEM_TOTALSETUPATTEMPTS,
    OSPC_MELEM_TRANSFERID,
    OSPC_MELEM_TRANSFERSTATUS,
    OSPC_MELEM_TRANSID,
    OSPC_MELEM_TWOWAYDELAY,
    OSPC_MELEM_UNIT,
    OSPC_MELEM_USAGECNF,
    OSPC_MELEM_USAGEDETAIL,
    OSPC_MELEM_USAGEIND,
    OSPC_MELEM_USERAGENT,
    OSPC_MELEM_USERGROUP,
    OSPC_MELEM_USERID,
    OSPC_MELEM_USERNAME,
    OSPC_MELEM_VALIDAFTER,
    OSPC_MELEM_VALIDUNTIL,
    OSPC_MELEM_VARIANCE,
    /* Number of message elements */
    OSPC_MELEM_NUMBER
} OSPE_MSG_ELEM;

/* externally declared global variables */
extern const OSPT_MSG_DESC OSPV_MELEM_DESCS[];
extern const OSPE_MSG_ELEM OSPV_MELEM_SIPHEADER[];

/* Function Prototypes */
OSPE_MSG_ELEM OSPPMsgElemGetPart(const char *);
const char *OSPPMsgElemGetName(OSPE_MSG_ELEM);

#endif /* _OSPMSGELEM_H */
