
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    scanner.h
**  Date:    March 15, 2002
**  
**  Author:  Brian Wotring
**  Purpose: scanning daemon scan module header file.
**
******************************************************************************/

#ifndef SCANNER_H_
#define SCANNER_H_

#define SCANNER_OK		    0
#define SCANNER_ERROR		1



/* record type for storing scan data. */

#ifdef WIN32
#define SCAN_RECORD_TYPE        SCAN_RECORD_TYPE_WINNT_1
#define SCAN_RECORD_STRUCTURE   SCAN_RECORD_WINNT_1

#else
#define SCAN_RECORD_TYPE        SCAN_RECORD_TYPE_UNIX_1
#define SCAN_RECORD_STRUCTURE   SCAN_RECORD_UNIX_1
#endif



/* keep a config and block pointers local to the scanner structure */
/* so that we could run multiple scanners, if we ever need to.     */

typedef struct SCANNER
{
    OSI_SCAN_CONFIG *config;
 
    block *current_block;
    block *global_block;
    
    int sequence;
    
    OSI_SCAN_RESULTS_1 stats;

} SCANNER;



SCANNER * osi_scanner_new();
void osi_scanner_destroy( SCANNER *scanner );

void osi_scanner_set_config( SCANNER *scanner, OSI_SCAN_CONFIG *cfg );
int  osi_scanner_run( SCANNER *scanner );

void process_current_block( SCANNER *scanner );
void process_block_root( SCANNER *scanner, const char *directory_path );
void process_directory( SCANNER *scanner, const char *directory_path );

void process_file( SCANNER *scanner, const char *file_path,
                   struct stat *file_stats );

#ifdef SYSTEM_DARWIN
void process_file_rfork( SCANNER *scanner, SCAN_RECORD *scan_record, FILE *f );
#endif

void populate_scan_record( SCANNER *scanner, SCAN_RECORD *record,
                           struct stat *file_stats, FILE *file );

int send_scan_data_first( SCANNER *scanner );
int send_scan_data( SCANNER *scanner, SCAN_RECORD *scan_record );
int send_scan_data_last( SCANNER *scanner );
int send_scan_error( int type, char *error_message, ... );

osi_bool get_owner_information( SCAN_RECORD *scan_record );
osi_bool get_group_information( SCAN_RECORD *scan_record );

osi_uint64 get_win32_file_attributes( const char *path );

#endif
