
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    cmp_filter.h
**  Date:    September 17, 2003
**
**  Author:  Brian Wotring
**
**  Purpose: structure representing a compare filter object
**           used to filter out deltas from the logs.
**
*****************************************************************************/

#ifndef CMP_FILTER_H
#define CMP_FILTER_H

#define FILTER_DISABLED_MARK '#'
#define CMP_FILTER_COMMENT "# add regular expressions, one per line\
 (disable with '#')"

typedef struct OSI_CMP_FILTER
{
    char exclude[MAX_PATH_LENGTH];
    
} OSI_CMP_FILTER;


osi_bool print_cmp_filter( OSI_CMP_FILTER *filter );

unsigned int pack_cmp_filter( OSI_CMP_FILTER *filter, char *buffer,
                              int buffer_size );

void unpack_cmp_filter( OSI_CMP_FILTER *filter, char *buffer,
                        int buffer_size );

int write_cmp_filters_to_file( osi_list filters, const char *path );
osi_list read_cmp_filters_from_file( const char *path );


#endif
