name="Game Status Controller"
author="Woody, updated by mDuo13"
help="""This plugin lets you quickly and easily manage a status that includes
your HP and AC for AD&D 2nd Edition. Type '/gsc' to open up the manager
window, and from there just change the values as necessary and the changes
will be reflected in your status. To revert to your regular status, close
the GSC window."""
#'name' should contain your plugin's long name.
#       Make sure it's not the same as another plugin's name.
#'author' is the author of the plugin. It will be listed in the plugin info.
#'help' is the help text that will be displayed when the user clicks the
#       'Plugin Info' button.
#--------------------------------------
import os
from wxPython.wx import *
from random import *

chat=None
session=None
tree=None
openrpg=None

ID_ROLL = 101
ID_EXIT  = 102

frame=None
settings=None

class RollerFrame(wxFrame):
    def __init__(self, parent, ID, title,sttings):
        wxFrame.__init__(self, parent, ID, title,
                         wxDefaultPosition, wxSize(196, 70))
        global settings
        settings=sttings
        self.panel=wxPanel(self,-1)
        #self.CreateStatusBar()
        #self.SetStatusText("Ready")
        menu = wxMenu()
        #menu.Append(ID_ROLL, "&Roll",
        #            "Roll your character")
        menu.AppendSeparator()
        menu.Append(ID_EXIT, "&Close", "Close this window")
        menuBar = wxMenuBar()
        menuBar.Append(menu, "&File");
        self.SetMenuBar(menuBar)

        self.old_idle = settings.get_setting('IdleStatusAlias')
        self.old_typing = settings.get_setting('TypingStatusAlias')



        wxStaticText(self.panel, -1, "AC:",
                               wxPoint(0, 5))

        self.ac = wxSpinCtrl(self.panel, ID_ROLL, "", wxPoint(18, 0), wxSize(40, -1))
        #self.ac.SetRange(-100,100)
        self.ac.SetValue(10)


        wxStaticText(self.panel, -1, "/",
                               wxPoint(128, 5))
        self.max_hp = wxSpinCtrl(self.panel, ID_ROLL, "", wxPoint(136, 0), wxSize(48, -1))
        #self.max_hp.SetRange(1,999999)
        self.max_hp.SetValue(10)

        wxStaticText(self.panel, -1, "HP:",
                               wxPoint(60, 5))

        self.hp = wxSpinCtrl(self.panel, ID_ROLL, "", wxPoint(78, 0), wxSize(48, -1))
        #self.hp.SetRange(-11,self.max_hp.GetValue())
        self.hp.SetValue(10)

        EVT_SPINCTRL(self, ID_ROLL, self.SetStatus)
        EVT_TEXT(self,ID_ROLL, self.SetStatus)
        #b = wxButton(self, 10, "Roll Stats!", wxPoint(20, 20), wxSize(80,25))
        #EVT_BUTTON(self, 10, self.OnRoll)
        #b.SetBackgroundColour(wxBLUE)
        #b.SetForegroundColour(wxGREEN)
        #b.SetDefault()

        EVT_MENU(self, ID_EXIT, self.TimeToQuit)
        EVT_CLOSE(self, self.TimeToQuit)
        self.SetStatus(None)

    def SetStatus(self, evt):
        new_status="AC: "+str(self.ac.GetValue())+"   HP: "+str(self.hp.GetValue())+"/"+str(self.max_hp.GetValue())
        settings.set_setting('IdleStatusAlias',new_status)
        settings.set_setting('TypingStatusAlias',new_status)
        session.set_text_status(new_status)

    def TimeToQuit(self, event):
        #print "closing"
        settings.set_setting('IdleStatusAlias',self.old_idle)
        settings.set_setting('TypingStatusAlias',self.old_typing)
        session.set_text_status(self.old_idle)
        global frame
        frame = None
        self.Destroy()

##Now we have the functions. These are called from within OpenRPG at various
##times. You can reference and change the variables, and do other things too.
##The more you know about python and OpenRPG, the more you can do. The
##possibilities are larger than you'd think.
##Note that when I say "formatted" I mean that it has HTML tags like font colors
##and names already added.

def message(self, text):
    #This is called whenever the user types something and hits enter.
    #It covers all messages, before they are formatted.
    return text

def send_msg(self, text, send):
    #This is called when a message is about to be sent out.
    #It covers all messages sent by the user, before they have been formatted.
    #If send is set to 0, the message will not be sent out to other
    #users, but it will still be posted to the user's chat normally.
    #Otherwise, send defaults to 1. (The message is sent as normal)
    return text, send

def receive_msg(self, text, type, name, player):
    #This is called whenever a message from someone else is received, no matter
    #what type of message it is.
    #The text variable is the text of the message. If the type is a regular
    #message, it is already formatted. Otherwise, it's not.
    #The type variable is an integer which tells you the type: 1=chat, 2=whisper
    #3=emote, 4=info, and 5=system.
    #The name variable is the name of the player who sent you the message.
    #The player variable contains lots of info about the player sending the
    #message, including name, ID#, and currently-set role.
    #Uncomment the following line to see the format for the player variable.
    #print player
    posted = 0#If posted is set to 1 then the chat module will stop processing
    #the incoming message. Use this if you post the incoming message elsewhere,
    #for example in a special tab or window.
    return text, type, name, posted

def post_msg(self, text, myself):
    #This is called whenever a message written by anyone is about to be posted
    #to chat; it doesn't affect the copy of the message that gets sent to others
    return text

def docmd(self, text, cmdlist):
    #This is called when the user enters a / command that OpenRPG doesn't
    #recognize. Thus, you can create new / commands. The text variable
    #is the text that the user inputted. If it is your custom command,
    #return 1. If it is not, return 0.
    global frame
    if text=='/gsc':
        #chat.Post('Stat Rolling Window Open')
        frame = RollerFrame(NULL, -1, "Game Status Ctrl (GSC)",self.settings)
        frame.Show(true)
        #self.SetTopWindow(frame)
        return 1
    return 0

def refresh_counter(self):
    #This is called once per second. That's all you need to know.
    pass

def close_module(self):
    #This is called when OpenRPG shuts down
    global frame
    if type(frame) != type(None):#then it must have been opened
        frame.Destroy()
    pass
