# Copyright (C) 2000-2001 The OpenRPG Project
#
#    openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: mapper/fog_handler.py
# Author: Mark Tarrabain
#
# Description: Handler for fog layer
#

from fog import *
from base_handler import *
from region import *

CTRL_REVEAL = wxNewId()
CTRL_HIDE = wxNewId()
CTRL_REMOVE = wxNewId()
CTRL_SHOWALL = wxNewId()
CTRL_HIDEALL = wxNewId()
CTRL_COLOR = wxNewId()
CTRL_PEN = wxNewId()

class fog_handler(base_layer_handler):
    def __init__(self, parent, id, canvas):
        self.showmode = 1
        self.drawing = false
        self.pencolor=wxWHITE
        base_layer_handler.__init__(self, parent, id, canvas)

    def build_ctrls(self):
        foglayer = self.canvas.layers['fog']
        base_layer_handler.build_ctrls(self)
        self.f_type_radio = {}
        self.f_type_radio[CTRL_REVEAL] = wxRadioButton(self, CTRL_REVEAL, "Show", style=wxRB_GROUP)
        self.f_type_radio[CTRL_HIDE] = wxRadioButton(self, CTRL_HIDE, "Hide")


        self.sizer.Prepend(20,25,1)
        self.sizer.Prepend(self.f_type_radio[CTRL_HIDE])
        self.sizer.Prepend(self.f_type_radio[CTRL_REVEAL])


    def build_menu(self,label = "fog"):
        base_layer_handler.build_menu(self,label)
        self.main_menu.AppendSeparator()


#        self.main_menu.Append(CTRL_SHOWALL,"&Show All")
        self.main_menu.Append(CTRL_HIDEALL,"&Hide All")
        self.main_menu.Append(CTRL_COLOR,"&Fog Mask")
        self.main_menu.Append(CTRL_REMOVE,"&Remove Fog Layer")
        self.main_menu.Append(CTRL_PEN,"&Pen Color")

#        EVT_MENU(self.canvas,CTRL_SHOWALL,self.on_showall)
        EVT_MENU(self.canvas,CTRL_PEN,self.on_pen_color)
        EVT_MENU(self.canvas,CTRL_COLOR,self.on_color)
        EVT_MENU(self.canvas,CTRL_HIDEALL,self.on_hideall)
        EVT_MENU(self.canvas,CTRL_REMOVE,self.on_remove)





    def on_remove(self,evt):
        session=self.canvas.frame.session
        if (session.my_role() <> session.ROLE_GM):
            self.top_frame.myopenrpg.get_component("chat").InfoPost("You must be a GM to use this feature")
            return
        self.canvas.layers['fog'].remove_fog()
        self.canvas.Refresh(false)

    def on_showall(self,evt):
        session=self.canvas.frame.session
        if (session.my_role() <> session.ROLE_GM):
            self.top_frame.myopenrpg.get_component("chat").InfoPost("You must be a GM to use this feature")
            return
        foglayer = self.canvas.layers['fog']
        foglayer.showall()
        self.canvas.Refresh(false)

    def on_pen_color(self,evt):
        data = wxColourData()
        data.SetChooseFull(true)
        data.SetColour(self.pencolor)
        dlg = wxColourDialog(self.canvas, data)
        if dlg.ShowModal() == wxID_OK:
            data = dlg.GetColourData()
            color = data.GetColour()
            self.pencolor=color
        dlg.Destroy()

    def on_hideall(self,evt):
        session=self.canvas.frame.session
        if (session.my_role() <> session.ROLE_GM):
            self.top_frame.myopenrpg.get_component("chat").InfoPost("You must be a GM to use this feature")
            return
        foglayer=self.canvas.layers['fog']
        foglayer.clear()
        self.canvas.Refresh(false)

    def on_color(self,evt):
        session=self.canvas.frame.session
        if (session.my_role() <> session.ROLE_GM):
            self.top_frame.myopenrpg.get_component("chat").InfoPost("You must be a GM to use this feature")
            return
        data = wxColourData()
        data.SetChooseFull(true)
        data.SetColour(self.canvas.layers['fog'].color)
        dlg = wxColourDialog(self.canvas, data)
        if dlg.ShowModal() == wxID_OK:
            data = dlg.GetColourData()
            self.canvas.layers['fog'].color=data.GetColour()
        dlg.Destroy()
        self.canvas.layers['fog'].fill_fog()
        self.canvas.Refresh(false)

    def update_info(self):
        foglayer = self.canvas.layers['fog']
        pass


    def on_motion(self, evt):
        scale = self.canvas.layers['grid'].mapscale
        dc = wxClientDC( self.canvas )
        self.canvas.PrepareDC( dc )
        dc.SetUserScale(scale,scale)
        pos = evt.GetLogicalPosition(dc)
        pos.x /= COURSE
        pos.y /= COURSE

        if evt.m_leftDown:
            if not self.drawing:
                self.line = []
                self.line.append(IPoint().make(pos.x,pos.y))
            elif pos.x!=self.last.x or pos.y!=self.last.y:
                pen=wxPen(self.pencolor)
                pen.SetWidth(COURSE/2+1)
                dc.SetPen(pen)
                dc.DrawLine(self.last.x*COURSE,self.last.y*COURSE,pos.x*COURSE,pos.y*COURSE)
                dc.SetPen(wxNullPen)
                self.line.append(IPoint().make(pos.x,pos.y))
            self.last = pos
            self.drawing = true
        del dc

    def on_left_up(self,evt):
        if self.drawing == true:
            session=self.canvas.frame.session
            if (session.my_role() <> session.ROLE_GM):
                self.top_frame.myopenrpg.get_component("chat").InfoPost("You must be a GM to use this feature")
            else:
                # This code sets the mode to either new or del depending on the action to function with the updated createregen code.
                if (self.f_type_radio[CTRL_REVEAL].GetValue() == 1):
                    showmode = 'new'
                else:
                    showmode = 'del'
                scale = self.canvas.layers['grid'].mapscale
                dc = wxClientDC( self.canvas )
                self.canvas.PrepareDC( dc )
                dc.SetUserScale(scale,scale)
                pen=wxPen(self.pencolor)
                pen.SetWidth(COURSE*scale/2+1)
                dc.SetPen(pen)
                dc.DrawLine(self.last.x*COURSE,self.last.y*COURSE,self.line[0].X*COURSE,self.line[0].Y*COURSE)
                dc.SetPen(wxNullPen)
                wxBeginBusyCursor()
                # This prevents the divide by zero error by not even sending the line to be proccessed if it contains less then 3 points
                if (len(self.line)>2):
                    self.canvas.layers['fog'].createregn(self.line,showmode)
                else:
                    #print "Error Divide by zero, ignoring this section"
                    pass
                wxEndBusyCursor()
                del dc
            self.canvas.Refresh(false)
            self.drawing = false
