# Copyright (C) 2000-2001 The OpenRPG Project
#
#	openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: gametree.py
# Author: Chris Davis
# Maintainer:
# Version:
#   $Id: gametree.py,v 1.33 2003/11/21 08:52:30 digitalxero Exp $
#
# Description: The file contains code fore the game tree shell
#

__version__ = "$Id: gametree.py,v 1.33 2003/11/21 08:52:30 digitalxero Exp $"




from orpg.orpg_windows import *
import orpg.dirpath
import orpg.tools.config_files
from orpg.orpg_xml import *
from nodehandlers import core

from gametree_version import GAMETREE_VERSION
#from wxPython.wx import *
#from nodehandlers import d20

import string
import urllib
import time
import os



STD_MENU_DELETE = wxNewId()
STD_MENU_DESIGN = wxNewId()
STD_MENU_USE = wxNewId()
STD_MENU_PP = wxNewId()
STD_MENU_RENAME = wxNewId()
STD_MENU_SEND = wxNewId()
STD_MENU_SAVE = wxNewId()
STD_MENU_ICON = wxNewId()
STD_MENU_CLONE = wxNewId()
STD_MENU_ABOUT = wxNewId()
STD_MENU_HTML = wxNewId()
STD_MENU_EMAIL = wxNewId()
STD_MENU_CHAT = wxNewId()
STD_MENU_WHISPER = wxNewId()
STD_MENU_WIZARD = wxNewId()
STD_MENU_NODE_SUBMENU = wxNewId()
STD_MENU_NODE_USEFUL = wxNewId()
STD_MENU_NODE_USELESS = wxNewId()
STD_MENU_NODE_INDIFFERENT = wxNewId()
STD_MENU_MAP = wxNewId()
TOP_IFILE = wxNewId()
TOP_INSERT_URL = wxNewId()
TOP_NEW_TREE = wxNewId()
TOP_SAVE_TREE = wxNewId()
TOP_SAVE_TREE_AS = wxNewId()
TOP_TREE_PROP = wxNewId()
TOP_FEATURES = wxNewId()

class dbl_clk_timer_class(wxTimer):
    def __init__(self,tree_ctrl):
        self.tree_ctrl = tree_ctrl
        wxTimer.__init__(self)


    def Notify(self):

        if self.tree_ctrl.rename_flag:
            self.tree_ctrl.EditLabel(self.item)

    def Start(self,item):
        self.item = item
        wxTimer.Start(self,500,1)       #  quarter second and the 1 is for a one-shot event


class game_tree(wxTreeCtrl):
    def __init__(self, parent, id, openrpg):
        wxTreeCtrl.__init__(self,parent,id,  wxDefaultPosition, wxDefaultSize,style = wxTR_EDIT_LABELS | wxTR_HAS_BUTTONS)

        self.myopenrpg = openrpg
        
        self.build_img_list()
        self.build_std_menu()
        self.nodehandlers = {}

        EVT_LEFT_DCLICK(self, self.on_ldclick)
        EVT_RIGHT_DOWN(self, self.on_rclick)
        EVT_TREE_BEGIN_DRAG(self, id, self.on_drag)
        EVT_LEFT_UP(self,self.on_left_up)
        EVT_LEFT_DOWN(self,self.on_left_down)
        EVT_TREE_END_LABEL_EDIT(self,self.GetId(),self.on_label_change)
        EVT_TREE_BEGIN_LABEL_EDIT(self,self.GetId(),self.on_label_begin)
        EVT_CHAR(self,self.on_char)
        EVT_KEY_UP(self,self.on_key_up)

        self.id = 1
        self.dragging = false
        self.root_dir = orpg.dirpath.dir_struct["home"]
        self.last_save_dir = orpg.dirpath.dir_struct["user"]

        #Create tree from default if it does not exist
        orpg.tools.config_files.validate_config_file("tree.xml","default_tree.xml")

        self.myopenrpg.add_component("tree",self)
        #build tree
        self.root = self.AddRoot("Game Tree",self.icons['gear'])

        # click timer
        self.dbl_clk_timer = dbl_clk_timer_class(self)
        self.was_labeling = 0
        self.rename_flag = 0

        self.image_cache = {}

    def initialize(self,openrpg):
        #add the tree to the openrpg object
        self.myopenrpg = openrpg
        self.myopenrpg.add_component("tree",self)
        #build tree
        s = self.myopenrpg.get_component('settings')
        self.root = self.AddRoot("Game Tree",self.icons['gear'])
        self.load_tree(s.get_setting("gametree"))


    #   event = wxKeyEvent
    #   set to be called by wxWindows by EVT_CHAR macro in __init__
    def on_key_up(self, evt):
        #print "key up"
        key_code = evt.GetKeyCode()
        if self.dragging and (key_code == WXK_SHIFT):
            curSelection = self.GetSelection()
            cur = wxStockCursor(wxCURSOR_ARROW)
            self.SetCursor(cur)
            self.dragging = false
            obj = self.GetPyData(curSelection)
            self.SelectItem(curSelection)
            if(isinstance(obj,core.node_handler)):
                obj.on_drop(evt)
                self.drag_obj = None
                #print "dragging object dropped!"


        evt.Skip()

    def on_char(self, evt):
        key_code = evt.GetKeyCode()
        curSelection = self.GetSelection()                            #  Get the current selection
        #name = self.GetItemText(curSelection)
        if evt.ShiftDown() and ((key_code == WXK_UP) or (key_code == WXK_DOWN)) and not self.dragging:
            curSelection = self.GetSelection()
            obj = self.GetPyData(curSelection)
            self.SelectItem(curSelection)
            if(isinstance(obj,core.node_handler)):
                self.dragging = true
                cur = wxStockCursor(wxCURSOR_HAND)
                self.SetCursor(cur)
                self.drag_obj = obj
                #print "dragging object set!"
        elif key_code == WXK_LEFT:
            self.Collapse(curSelection)

        elif key_code == WXK_DELETE:                          #  Handle the delete key
            #curSelection = self.GetSelection()                        #  Get the current selection
            if curSelection:
                nextSelect = self.GetNextSibling(curSelection)
                if self.GetItemText(nextSelect) == "":
                    nextSelect = self.GetPrevSibling(curSelection)
                if self.GetItemText(nextSelect) == "":
                    nextSelect = self.GetItemParent(curSelection)

                self.on_del(evt)

                if self.GetItemText(nextSelect) <> "":
                    self.SelectItem(nextSelect)

        evt.Skip()


    def load_tree(self,filename=orpg.dirpath.dir_struct["user"]+'tree.xml',error=0):
        #self.filename = filename
        s = self.myopenrpg.get_component('settings')
        s.set_setting("gametree",filename)
        tmp = open(filename,"r")
        xml_dom = None
        xml_doc = parseXml(tmp.read())
        if xml_doc == None:
            pass
        else:
            xml_dom = xml_doc._get_documentElement()
        tmp.close()
        if not xml_dom:
            wxMessageBox("Corrupt Tree!\nYour game tree is being regenerated. To\nsalvage a recent version of your gametree\nexit OpenRPG and copy the lastgood.xml\nfile in your myfiles directory\nto "+filename+ "\nin your myfiles directory.\nlastgood.xml WILL BE OVERWRITTEN NEXT TIME YOU RUN OPENRPG.")

            os.rename(filename,filename+".corrupt")
            orpg.tools.config_files.validate_config_file("tree.xml","default_tree.xml")
            self.load_tree(error=1)
            return
        if xml_dom._get_tagName() != "gametree":
            return
        # get gametree version - we could write conversion code here!
	
        self.master_dom = xml_dom
	
        try:
            version = self.master_dom.getAttribute("version")
            print "Loaded " + filename + " gametree version - " + version

            # see if we should load the gametree
            s = self.myopenrpg.get_component('settings')
            loadfeatures = int(s.get_setting("LoadGameTreeFeatures"))
            if loadfeatures:
                xml_dom = parseXml(open(orpg.dirpath.dir_struct["template"]+"feature.xml","r").read())
                xml_dom = xml_dom._get_documentElement()
                xml_dom = self.master_dom.appendChild(xml_dom)
                s.set_setting("LoadGameTreeFeatures","0")

            ## load tree
            self.CollapseAndReset(self.root)
            children = self.master_dom._get_childNodes()
            for c in children:
                self.load_xml(c,self.root)
            self.Expand(self.root)
            self.SetPyData(self.root,self.master_dom)
            if error != 1:
                infile = open(filename, "rb")
                outfile = open(orpg.dirpath.dir_struct["user"]+"lastgood.xml", "wb")
                outfile.write(infile.read())
            else:
                print "Not overwriting lastgood.xml file."
	     
        except Exception, e:
            print e
            wxMessageBox("Corrupt Tree!\nYour game tree is being regenerated. To\nsalvage a recent version of your gametree\nexit OpenRPG and copy the lastgood.xml\nfile in your myfiles directory\nto "+filename+ "\nin your myfiles directory.\nlastgood.xml WILL BE OVERWRITTEN NEXT TIME YOU RUN OPENRPG.")
            os.rename(filename,filename+".corrupt")
            orpg.tools.config_files.validate_config_file("tree.xml","default_tree.xml")
            self.load_tree(error=1)

    def build_std_menu(self,obj=None):
        # build useful menu
        useful_menu = wxMenu()
        useful_menu.Append(STD_MENU_NODE_USEFUL,"Use&ful")
        useful_menu.Append(STD_MENU_NODE_USELESS,"Use&less")
        useful_menu.Append(STD_MENU_NODE_INDIFFERENT,"&Indifferent")
        # build standard menu
        self.std_menu =  wxMenu()
        self.std_menu.SetTitle("game tree")
        self.std_menu.Append(STD_MENU_USE,"&Use")
        self.std_menu.Append(STD_MENU_DESIGN,"&Design")
        self.std_menu.Append(STD_MENU_PP,"&Pretty Print")
        self.std_menu.AppendSeparator()        
        self.std_menu.Append(STD_MENU_SEND,"Send To Player")
        self.std_menu.Append(STD_MENU_MAP,"Send To Map")
        self.std_menu.Append(STD_MENU_CHAT,"Send To Chat")
        self.std_menu.Append(STD_MENU_WHISPER,"Whisper To Player")
        self.std_menu.AppendSeparator()
#        self.std_menu.Append(STD_MENU_DESIGN,"&Edit")
        #self.std_menu.Append(STD_MENU_RENAME,"&Rename")
        self.std_menu.Append(STD_MENU_ICON,"Change &Icon")
        self.std_menu.Append(STD_MENU_DELETE,"D&elete")
        self.std_menu.Append(STD_MENU_CLONE,"&Clone")
        self.std_menu.AppendMenu(STD_MENU_NODE_SUBMENU,"Node &Usefulness",useful_menu)
        self.std_menu.AppendSeparator()
        self.std_menu.Append(STD_MENU_SAVE,"&Save Node")
        self.std_menu.Append(STD_MENU_HTML,"E&xport as HTML")
        #self.std_menu.Append(STD_MENU_WIZARD,"Create &Wizard")
        #self.std_menu.Append(STD_MENU_EMAIL,"Email")
        self.std_menu.AppendSeparator()
        self.std_menu.Append(STD_MENU_ABOUT,"&About")
        EVT_MENU(self, STD_MENU_SEND, self.on_send_to)
        #EVT_MENU(self, STD_MENU_RENAME, self.on_rename)
        EVT_MENU(self, STD_MENU_NODE_INDIFFERENT, self.indifferent)
        EVT_MENU(self, STD_MENU_NODE_USEFUL, self.useful)
        EVT_MENU(self, STD_MENU_NODE_USELESS, self.useless)
        EVT_MENU(self, STD_MENU_DELETE, self.on_del)
        EVT_MENU(self, STD_MENU_MAP, self.on_send_to_map)
        EVT_MENU(self, STD_MENU_DESIGN, self.on_node_design)
        EVT_MENU(self, STD_MENU_USE, self.on_node_use)
        EVT_MENU(self, STD_MENU_PP, self.on_node_pp)        
        EVT_MENU(self, STD_MENU_SAVE, self.on_save)
        EVT_MENU(self, STD_MENU_ICON, self.on_icon)
        EVT_MENU(self, STD_MENU_CLONE, self.on_clone)
        EVT_MENU(self, STD_MENU_ABOUT, self.on_about)
        EVT_MENU(self, STD_MENU_CHAT, self.on_send_to_chat)
        EVT_MENU(self, STD_MENU_WHISPER, self.on_whisper_to)
        EVT_MENU(self, STD_MENU_HTML, self.on_export_html)
        #EVT_MENU(self, STD_MENU_WIZARD, self.on_wizard)

        self.top_menu = wxMenu()
        self.top_menu.SetTitle("game tree")
        self.top_menu.Append(TOP_IFILE,"&Insert File")
        self.top_menu.Append(TOP_INSERT_URL,"Insert &URL")
        self.top_menu.Append(TOP_FEATURES, "Insert &Features Node")
        self.top_menu.Append(TOP_NEW_TREE, "&Load New Tree")
        self.top_menu.Append(TOP_SAVE_TREE,"&Save Tree")
        self.top_menu.Append(TOP_SAVE_TREE_AS,"Save Tree &As...")
        self.top_menu.Append(TOP_TREE_PROP,"&Tree Properties")
        EVT_MENU(self, TOP_IFILE, self.on_insert_file)
        EVT_MENU(self, TOP_INSERT_URL, self.on_insert_url)
        EVT_MENU(self, TOP_SAVE_TREE_AS, self.on_save_tree_as)
        EVT_MENU(self, TOP_SAVE_TREE, self.on_save_tree)
        EVT_MENU(self, TOP_NEW_TREE, self.on_load_new_tree)
        EVT_MENU(self, TOP_TREE_PROP, self.on_tree_prop)
        EVT_MENU(self, TOP_FEATURES, self.on_insert_features)


    def do_std_menu(self,evt,obj):
        pt = evt.GetPosition()
        self.std_menu.Enable(STD_MENU_MAP,obj.map_aware())
        self.std_menu.Enable(STD_MENU_CLONE,obj.can_clone())
        self.PopupMenu(self.std_menu,pt)

    def strip_html(self,player):
        ret_string = ""
        x = 0
        in_tag = 0

        for x in range(len(player[0])) :
            if player[0][x] == "<" or player[0][x] == ">" or in_tag == 1 :
                if player[0][x] == "<" :
                    in_tag = 1
                elif player[0][x] == ">" :
                    in_tag = 0
                else :
                    pass
            else :
                ret_string = ret_string + player[0][x]
        return ret_string
    
    def on_receive_data(self,data,player):
        beg = string.find(data,"<tree>")
        end = string.rfind(data,"</tree>")
        data = data[6:end]
        self.insert_xml(data)

    def on_send_to_chat(self,evt):
        item = self.GetSelection()
        obj = self.GetPyData(item)
        obj.on_send_to_chat(evt)
        #chat = self.myopenrpg.get_component('chat')
        #chat.ParsePost(obj.tohtml(),true,true)

    def on_whisper_to(self,evt):
        session = self.myopenrpg.get_component('session')
        players = session.get_players()
        opts = []
        myid = session.get_id()
        me = None
        for p in players:
            if p[2] != myid:
                opts.append("("+p[2]+") " + self.strip_html(p))
            else:
                me = p
        
        if len(opts):
           players.remove(me)

        if len(opts):
            dlg = wxMultiCheckBoxDlg( self.GetParent(),opts,"Select Players:","Whisper To",[] )
##            dlg = wxMultiCheckBoxDlg(self.GetParent(),opts,"Select Players:","Whisper To",range(len(opts)))
            if dlg.ShowModal() == wxID_OK:
                item = self.GetSelection()
                obj = self.GetPyData(item)
                selections = dlg.get_selections()
                chat = self.myopenrpg.get_component('chat')
                #data = chat.ParsePost(obj.tohtml(),false,true)
                if len(selections) == len(opts):
                    chat.ParsePost(obj.tohtml(),true,true)
                else:
                    player_ids = []
                    for s in selections:
                        player_ids.append(players[s][2])
                    chat.whisper_to_players(obj.tohtml(),player_ids)

    def on_export_html(self,evt):
        f =wxFileDialog(self,"Select a file", self.last_save_dir,"","HTML (*.html)|*.html",wxSAVE)
        if f.ShowModal() == wxID_OK:
            item = self.GetSelection()
            obj = self.GetPyData(item)
            type = f.GetFilterIndex()
            file = open(f.GetPath(),"w")
            data = "<html><head><title>"+obj.master_dom.getAttribute("name")+"</title></head>"
            data += "<body bgcolor=\"#FFFFFF\" >"+obj.tohtml()+"</body></html>"
            for tag in ("</tr>","</td>","</th>","</table>","</html>","</body>"):
                data = data.replace(tag,tag+"\n")
            file.write(data)
            file.close()
            self.last_save_dir, throwaway = os.path.split( f.GetPath() )
        f.Destroy()
        os.chdir(self.root_dir)

    def indifferent(self,evt):
        item = self.GetSelection()
        obj = self.GetPyData(item)
        obj.usefulness("indifferent")

    def useful(self,evt):
        item = self.GetSelection()
        obj = self.GetPyData(item)
        obj.usefulness("useful")

    def useless(self,evt):
        item = self.GetSelection()
        obj = self.GetPyData(item)
        obj.usefulness("useless")

    def on_email(self,evt):
        pass

    def on_send_to(self,evt):
        session = self.myopenrpg.get_component('session')
        players = session.get_players()
        opts = []
        myid = session.get_id()
        me = None
        for p in players:
            if p[2] != myid:
                opts.append("("+p[2]+") " + self.strip_html(p))
            else:
                me = p

        if len(opts):
            players.remove(me)

##        dlg = wxMultiCheckBoxDlg(self.GetParent(),opts,"Select Players:","Send To",range(len(opts)))
            dlg = wxMultiCheckBoxDlg( self.GetParent(),opts,"Select Players:","Send To", [] )
            if dlg.ShowModal() == wxID_OK:
                item = self.GetSelection()
                obj = self.GetPyData(item)
                xmldata = "<tree>"+obj.toxml()+"</tree>"
                selections = dlg.get_selections()
                if len(selections) == len(opts):
                    session.send(xmldata)
                else:
                    for s in selections:
                        session.send(xmldata,players[s][2])

        #obj.toxml()

    def on_icon(self,evt):
        icons = self.icons.keys()
        icons.sort()
        dlg = wxSingleChoiceDialog(self,"Choose Icon?","Change Icon",icons)
        if dlg.ShowModal() == wxID_OK:
            key = dlg.GetStringSelection()
            item = self.GetSelection()
            obj = self.GetPyData(item)
            obj.change_icon(key)
        dlg.Destroy()

    def on_wizard(self,evt):
        item = self.GetSelection()
        obj = self.GetPyData(item)
        name = "New " + obj.master_dom.getAttribute("name")
        icon = obj.master_dom.getAttribute("icon")
        xml_data = "<nodehandler name=\""+name+"\" icon=\"" + icon + "\" module=\"core\" class=\"node_loader\" >"
        xml_data += obj.toxml()
        xml_data += "</nodehandler>"
        self.insert_xml(xml_data)

    def on_clone(self,evt):
        item = self.GetSelection()
        obj = self.GetPyData(item)
        if obj.can_clone():
            self.insert_xml(obj.toxml())

    def on_save(self,evt):
        "save node to a xml file"
        item = self.GetSelection()
        obj = self.GetPyData(item)
        obj.on_save(evt)
        os.chdir(self.root_dir)

    def on_save_tree_as(self,evt):
        f =wxFileDialog(self,"Select a file", self.last_save_dir,"","*.xml",wxSAVE)
        if f.ShowModal() == wxID_OK:
            self.save_tree(f.GetPath())
            self.last_save_dir, throwaway = os.path.split( f.GetPath() )
        f.Destroy()
        os.chdir(self.root_dir)

    def on_save_tree(self,evt=None):
        s = self.myopenrpg.get_component('settings')
        filename = s.get_setting("gametree")
        self.save_tree(filename)

    def save_tree(self,filename=orpg.dirpath.dir_struct["user"]+'tree.xml'):
        self.master_dom.setAttribute("version",GAMETREE_VERSION)
        s = self.myopenrpg.get_component('settings')
        s.set_setting("gametree",filename)
        file = open(filename,"w")
        file.write(toxml(self.master_dom,1))
        file.close()

    def on_load_new_tree(self,evt):
        f =wxFileDialog(self,"Select a file", self.last_save_dir,"","*.xml",wxOPEN)
        if f.ShowModal() == wxID_OK:
            self.load_tree(f.GetPath())
            self.last_save_dir, throwaway = os.path.split( f.GetPath() )
        f.Destroy()
        os.chdir(self.root_dir)

    def on_insert_file(self,evt):
        "loads xml file into the tree"
        if self.last_save_dir == ".":
            self.last_save_dir = orpg.dirpath.dir_struct["user"]
        f =wxFileDialog(self,"Select a file", self.last_save_dir,"","*.xml",wxOPEN)
        if f.ShowModal() == wxID_OK:
            self.insert_xml(open(f.GetPath(),"r").read())
            self.last_save_dir, throwaway = os.path.split( f.GetPath() )
        f.Destroy()
        os.chdir(self.root_dir)

    def on_insert_url(self,evt):
        "loads xml url into the tree"
        dlg = wxTextEntryDialog(self,"URL?","Insert URL", "http://")
        if dlg.ShowModal() == wxID_OK:
            path = dlg.GetValue()
            file = urllib.urlopen(path)
            self.insert_xml(file.read())
        dlg.Destroy()

    def on_insert_features(self,evt):
        self.insert_xml(open(orpg.dirpath.dir_struct["template"]+"feature.xml","r").read())

    def on_tree_prop(self,evt):
        dlg = gametree_prop_dlg(self,self.myopenrpg.get_component('settings'))
        if dlg.ShowModal() == wxID_OK:
            pass
        dlg.Destroy()

    def on_node_design(self,evt):
        item = self.GetSelection()
        obj = self.GetPyData(item)
        obj.on_design(evt)

    def on_node_use(self,evt):
        item = self.GetSelection()
        obj = self.GetPyData(item)
        obj.on_use(evt)

    def on_node_pp(self,evt):
        item = self.GetSelection()
        obj = self.GetPyData(item)
        obj.on_html_view(evt)
        
    def on_del(self,evt):
        status_value = "none"
        try:
            item = self.GetSelection()
            if item:
                obj = self.GetPyData(item)
                parent_obj = obj
                try:
                    status_value = parent_obj.master_dom.getAttribute('status')
                    name = parent_obj.master_dom.getAttribute('name')
                except:
                    status_value = "none"
                parent_obj = parent_obj.master_dom._get_parentNode()
                while status_value<>"useful" and status_value<>"useless":
                    try:
                        status_value = parent_obj.getAttribute('status')
                        name = parent_obj.getAttribute('name')
                        if status_value == "useless":
                            break
                        elif status_value == "useful":
                            break
                    except:
                        status_value = "none"
                    try:
                        parent_obj = parent_obj._get_parentNode()
                    except:
                        break
                if status_value == "useful":
                    dlg = wxMessageDialog(self, `name` + "  And everything beneath it are considered useful.  \n\nAre you sure you want to delete this item?",'Important Item',wxYES_NO | wxNO_DEFAULT | wxICON_QUESTION)
                    if dlg.ShowModal() == wxID_YES:
                        obj.delete()
                else:
                    obj.delete()
        except:
            if self.GetSelection() == self.GetRootItem():
                msg = wxMessageDialog(None,"You can't delete the root item.","Delete Error",wxOK)
            else:
                msg = wxMessageDialog(None,"Unknown error deleting node.","Delete Error",wxOK)
            msg.ShowModal()
            msg.Destroy()


    def on_about(self,evt):
        item = self.GetSelection()
        obj = self.GetPyData(item)
        about = MyAboutBox(self,obj.about())
        about.ShowModal()
        about.Destroy()

    def on_send_to_map(self,evt):
        item = self.GetSelection()
        obj = self.GetPyData(item)
        if hasattr(obj,"on_send_to_map"):
            obj.on_send_to_map(evt)

    def insert_xml(self,txt):
        #Updated to allow safe merging of gametree files
        #without leaving an unusable and undeletable node.
        #                               -- Snowdog 8/03
        xml_dom = parseXml(txt)
        if xml_dom == None:
            wxMessageBox("Import Failed: Invalid or missing node data")
            return
        xml_temp = xml_dom._get_documentElement()
        if not xml_temp:
            wxMessageBox("Error Importing Node or Tree")
            return
        if xml_temp._get_tagName() == "gametree":
            children = xml_temp._get_childNodes()
            for c in children:
                self.load_xml(c,self.root)
            return
        
        if not xml_dom:
            wxMessageBox("XML Error")
            return
        
        xml_dom = xml_dom._get_firstChild()
        child = self.master_dom._get_firstChild()
        xml_dom = self.master_dom.insertBefore(xml_dom,child)
        self.load_xml(xml_dom,self.root,self.root)

    def build_img_list(self):
        "make image list"
        helper = img_helper()
        self.icons = { }
        self._imageList=wxImageList(16,16,false)

        man = open(orpg.dirpath.dir_struct["icon"]+"icons.xml","r")
        xml_dom = parseXml(man.read())
        man.close()
        xml_dom = xml_dom._get_documentElement()
        node_list = xml_dom._get_childNodes()

        for n in node_list:
            key = n.getAttribute("name")
            path = orpg.dirpath.dir_struct["icon"] + n.getAttribute("file")
            img = helper.load_file(path)
            self.icons[key] = self._imageList.Add(img)
        self.SetImageList(self._imageList)

    def load_xml(self,xml_dom,parent_node,prev_node=None):
        #add the first tree node
        i = 0
        text = xml_dom.getAttribute("name")
        icon = xml_dom.getAttribute("icon")
        if self.icons.has_key(icon):
            i = self.icons[icon]
        name = xml_dom._get_nodeName()
        if prev_node:
            if prev_node == parent_node:
                new_tree_node = self.PrependItem(parent_node,text,i,i)
            else:
                new_tree_node = self.InsertItem(parent_node,prev_node,text,i,i)
        else:
            new_tree_node = self.AppendItem(parent_node,text,i,i)
        #create a nodehandler or continue loading xml into tree
        if name == "nodehandler":
            wxBeginBusyCursor()
            try:
                mod = xml_dom.getAttribute("module")
                mod = string.split(mod)[0]
                py_class = xml_dom.getAttribute("class")
                py_class = string.split(py_class)[0]
                cmd = "from nodehandlers import " + mod
                exec cmd
                cmd = "self.nodehandlers[self.id] = "+mod+"."+py_class+"(xml_dom,new_tree_node,self.myopenrpg)"
                exec cmd
                self.SetPyData(new_tree_node,self.nodehandlers[self.id])
                obj = self.nodehandlers[self.id]
                bmp = obj.get_scaled_bitmap(16,16)
                if bmp:
                    self.cached_load_of_image(bmp,new_tree_node,)
                #self.Expand(new_tree_node)
                self.id = self.id + 1
            except StandardError, er:
                wxMessageBox("Error Info:\n" + str(er),"Tree Node Load Error")
                self.Delete(new_tree_node)
                parent = xml_dom._get_parentNode()
                parent.removeChild(xml_dom)
            wxEndBusyCursor()
        return new_tree_node

    def cached_load_of_image(self,bmp_in,new_tree_node):

        image_list = self.GetImageList()

        img = wxImageFromBitmap(bmp_in)

        img_data = img.GetData()
        image_index = None
        for key in self.image_cache.keys():
            if self.image_cache[key] == str(img_data):
                image_index = key
                break

        if image_index is None:
            image_index = image_list.Add(bmp_in)
            self.image_cache[image_index] = img_data

        self.SetItemImage(new_tree_node,image_index)
        self.SetItemImage(new_tree_node,image_index,wxTreeItemIcon_Selected)
        return image_index


    def on_rclick(self,evt):
        pt = evt.GetPosition()
        (item, flag) = self.HitTest(pt)
        if item.IsOk():
            obj = self.GetPyData(item)
            self.SelectItem(item)
            if(isinstance(obj,core.node_handler)):
                obj.on_rclick(evt)
            else:
                self.PopupMenu(self.top_menu,pt)
        else:
            self.PopupMenu(self.top_menu,pt)

    def on_ldclick(self,evt):
        self.rename_flag = 0
        pt = evt.GetPosition()
        (item, flag) = self.HitTest(pt)
        if item.IsOk():
            obj = self.GetPyData(item)
            self.SelectItem(item)
            if(isinstance(obj,core.node_handler)):
                if not obj.on_ldclick(evt):
                    s = self.myopenrpg.get_component('settings')
                    action = s.get_setting("treedclick")
                    if action == "use":
                        obj.on_use(evt)
                    elif action == "design":
                        obj.on_design(evt)
                    elif action == "print":
                        obj.on_html_view(evt)
                    elif action == "chat":
                        self.on_send_to_chat(evt)


    def on_left_down(self,evt):
        pt = evt.GetPosition()
        (item, flag) = self.HitTest(pt)
        if item.IsOk():
            if self.was_labeling:
                self.SelectItem(item)
                self.rename_flag = 0
                self.was_labeling = 0
                evt.Skip()
            else:
                if self.IsSelected(item):
                    #  this next if tests to ensure that the mouse up occurred over a label, and not the icon
                    if (flag & wxTREE_HITTEST_ONITEMLABEL) == wxTREE_HITTEST_ONITEMLABEL :
                        self.rename_flag = 1
                        self.dbl_clk_timer.Start(item)    # derived from wxTimer
                        evt.Skip()
                    else:
                        evt.Skip()
                else:
                    self.SelectItem(item)
                    evt.Skip()


    def on_left_up(self,evt):
        if self.dragging:
            cur = wxStockCursor(wxCURSOR_ARROW)
            self.SetCursor(cur)
            self.dragging = false
            pt = evt.GetPosition()
            (item, flag) = self.HitTest(pt)
            if item.IsOk():
                obj = self.GetPyData(item)
                self.SelectItem(item)
                if(isinstance(obj,core.node_handler)):
                    obj.on_drop(evt)
                    self.drag_obj = None


    def on_label_change(self,evt):
        item = evt.GetItem()
        txt = evt.GetLabel()

        self.was_labeling = 0
        self.rename_flag = 0

        if txt != "":
            obj = self.GetPyData(item)
            obj.master_dom.setAttribute('name',txt)
        else:
            evt.Veto()

    def on_label_begin(self,evt):


        if not self.rename_flag:
            evt.Veto()
        else:
            self.was_labeling = 1
            item = evt.GetItem() 
            if item == self.GetRootItem():
                evt.Veto()

    def on_drag(self,evt):
        self.rename_flag = 0
        item = self.GetSelection()
        obj = self.GetPyData(item)
        self.SelectItem(item)
        if(isinstance(obj,core.node_handler) and obj.drag):
            self.dragging = true
            cur = wxStockCursor(wxCURSOR_HAND)
            self.SetCursor(cur)
            self.drag_obj = obj


    def is_parent_node(self,node,compare_node):
        parent_node = self.GetItemParent(node)
        if compare_node == parent_node:
            #print "parent node"
            return 1
        elif parent_node == self.root:
            #print "not parent"
            return 0
        else:
            return self.is_parent_node(parent_node,compare_node)
            
    

CTRL_TREE_FILE	= wxNewId()
CTRL_YES = wxNewId()
CTRL_NO = wxNewId()
CTRL_USE = wxNewId()
CTRL_DESIGN = wxNewId()
CTRL_CHAT = wxNewId()
CTRL_PRINT = wxNewId()


class gametree_prop_dlg(wxDialog):
    def __init__(self,parent,settings):
        wxDialog.__init__(self,parent,-1,"Game Tree Properties",wxDefaultPosition,wxSize(300,275))

        self.settings  = settings
        #sizers
        sizers = {}
        sizers['but'] = wxBoxSizer(wxHORIZONTAL)
        sizers['main'] = wxBoxSizer(wxVERTICAL)
        sizers['tree'] = wxBoxSizer(wxVERTICAL)
        sizers['save'] = wxBoxSizer(wxHORIZONTAL)
        sizers['dclick'] = wxBoxSizer(wxHORIZONTAL)

        #box sizers
        box_sizers = {}
        box_sizers["save"] = wxBoxedSizer( self, "Save On Exit" )
        box_sizers["file"] = wxBoxedSizer( self, "Tree File" )
        box_sizers["dclick"] = wxBoxedSizer( self, "Double Click Action" )

        self.ctrls = {  CTRL_TREE_FILE : FileBrowseButtonWithHistory(box_sizers["file"], -1,  labelText="" ) ,
                        CTRL_YES : wxRadioButton(box_sizers["save"], CTRL_YES, "Yes", style=wxRB_GROUP),
                        CTRL_NO : wxRadioButton(box_sizers["save"], CTRL_NO, "No"),
                        CTRL_USE : wxRadioButton(box_sizers["dclick"], CTRL_USE, "Use", style=wxRB_GROUP),
                        CTRL_DESIGN : wxRadioButton(box_sizers["dclick"], CTRL_DESIGN, "Desgin"),
                        CTRL_CHAT : wxRadioButton(box_sizers["dclick"], CTRL_CHAT, "Chat"),
                        CTRL_PRINT : wxRadioButton(box_sizers["dclick"], CTRL_PRINT, "Pretty Print")
                        }
        self.ctrls[CTRL_TREE_FILE].SetValue(settings.get_setting("gametree"))
        opt = settings.get_setting("SaveGameTreeOnExit")
        self.ctrls[CTRL_YES].SetValue(opt=="1")
        self.ctrls[CTRL_NO].SetValue(opt=="0")
        opt = settings.get_setting("treedclick")
        self.ctrls[CTRL_DESIGN].SetValue(opt=="design")
        self.ctrls[CTRL_USE].SetValue(opt=="use")
        self.ctrls[CTRL_CHAT].SetValue(opt=="chat")
        self.ctrls[CTRL_PRINT].SetValue(opt=="print")
        
        
        sizers['save'].Add(self.ctrls[CTRL_YES],0, wxEXPAND)
        sizers['save'].Add(10,10)
        sizers['save'].Add(self.ctrls[CTRL_NO],0, wxEXPAND)

        sizers['dclick'].Add(self.ctrls[CTRL_USE],0, wxEXPAND)
        sizers['dclick'].Add(10,10)
        sizers['dclick'].Add(self.ctrls[CTRL_DESIGN],0, wxEXPAND)
        sizers['dclick'].Add(10,10)
        sizers['dclick'].Add(self.ctrls[CTRL_CHAT],0, wxEXPAND)
        sizers['dclick'].Add(10,10)
        sizers['dclick'].Add(self.ctrls[CTRL_PRINT],0, wxEXPAND)

        box_sizers["save"].set_sizer(sizers["save"])
        box_sizers["file"].set_ctrl(self.ctrls[CTRL_TREE_FILE])
        box_sizers["dclick"].set_sizer(sizers["dclick"])

        for box in box_sizers.values():
            box.SetSize(wxSize(20,65))

        csize = self.GetClientSizeTuple()
	
        # buttons
        sizers['but'].Add(wxButton(self, wxID_OK, "Apply"), 1, wxEXPAND)
        sizers['but'].Add(10,10)
        sizers['but'].Add(wxButton(self, wxID_CANCEL, "Cancel"), 1, wxEXPAND)

        
        sizers['main'].Add(box_sizers['save'],1, wxEXPAND)
        sizers['main'].Add(box_sizers['file'],1, wxEXPAND)
        sizers['main'].Add(box_sizers['dclick'],1, wxEXPAND)
        sizers['main'].Add(sizers['but'],0, wxEXPAND|wxALIGN_BOTTOM )        
        sizers['main'].SetDimension(10,10,csize[0]-20,csize[1]-20)
        self.SetSizer(sizers['main'])
        EVT_BUTTON(self, wxID_OK, self.on_ok)

    def on_ok(self,evt):
        self.settings.set_setting("gametree",self.ctrls[CTRL_TREE_FILE].GetValue())
        self.settings.set_setting("SaveGameTreeOnExit",str(self.ctrls[CTRL_YES].GetValue()))
        if self.ctrls[CTRL_USE].GetValue():
            self.settings.set_setting("treedclick","use")
        elif self.ctrls[CTRL_DESIGN].GetValue():
            self.settings.set_setting("treedclick","design")
        elif self.ctrls[CTRL_PRINT].GetValue():
            self.settings.set_setting("treedclick","print")
        elif self.ctrls[CTRL_CHAT].GetValue():
            self.settings.set_setting("treedclick","chat")
	self.EndModal(wxID_OK)

         
