/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of Opensourced MCL.

   Opensourced MCL is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   Opensourced MCL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


/* 06/10/96 gb  uuo_fixnum_overflow */
/* --- 3.9 release */

/* A uuo looks like: */
/*  0      5 6                  15 16   20 21          27 28  31 */
/* +--------+-----------------------------+--------------+------+ */
/* |   0    |XXXXXXXXXXXXXXXXXXXX |  RB   |  <minor op>  |  11  | */
/* +--------+-----------------------------+--------------+------+ */
/* */
/* e.g., the major opcode (bits 0-5) is 0, the low 4 bits (bits 28-31) */
/* have the value "11" decimal (that's tagged as an immediate as far */
/* as lisp is concerned, a 7-bit opcode in bits 21-27, and the format */
/* of bits 6-20 depend on the value of the minor opcode, though typically */
/* bits 16-20 are used to specify a register value between 0 and 31. */
/* */
/* There are a few cases where bits 6-15 are also used to denote registers */
/* (RT and RA, as in an X-form PPC instruction), some where bits 6-10 are */
/* to be interpreted as a constant (error number or type code), and some */
/* where bits 6-15 do so. */
/* */
/* Since C code is typically more interested in disassembling UUOs, the */
/* full list of UUOs is in "uuo.h".  This file contains macros for creating */
/* them. */
/* */
/* Of course, there -is- no such file as "uuo.h".  That's a stale comment. */
/* For all anyone knows, so is this one. */

UUO_TAG = 11
UUU_MINOR_SHIFT = 4
UUO_RB_SHIFT = 11
UUO_RA_SHIFT = 16
UUO_RT_SHIFT = 21

define([rt_ra_uuo],[
	.long (UUO_TAG|(($1)<<UUU_MINOR_SHIFT)|(($3)<<UUO_RA_SHIFT)|(($2)<<UUO_RT_SHIFT))])

define([rt_ra_rb_uuo],[
	.long (UUO_TAG|(($1)<<UUU_MINOR_SHIFT)|(($3)<<UUO_RA_SHIFT)|(($4)<<UUO_RB_SHIFT)|(($2)<<UUO_RT_SHIFT))])
	
define([errnum_rb_uuo],[
	.long (UUO_TAG|(($1)<<UUU_MINOR_SHIFT)|(($2)<<UUO_RA_SHIFT)|(($3)<<UUO_RB_SHIFT))])
	
define([errnum_ra_rb_uuo],[ /* minorop,errnum,ra,rb*/
	.long (UUO_TAG|(($1)<<UUU_MINOR_SHIFT)|(($2)<<UUO_RA_SHIFT)|(($3)<<UUO_RB_SHIFT)|((\errnum)<<UUO_RT_SHIFT))])
	
	
define([uuo_box_signed],[
	rt_ra_uuo(1,$1,$2)])
	
define([uuo_box_unsigned],[
	rt_ra_uuo(2,$1,$2)])

define([uuo_fixnum_overflow],[
	rt_ra_uuo(21,$1,$2)])

	
/* Signal an internal error - type error or whatever - with error  */
/* number (0-1023) and "register" argument. */

define([uuo_interr],[
	errnum_rb_uuo(11,$1,$2)])
	
/* As above, but make the error continuable.  (A branch presumably */
/* follows the UUO opcode.) */

define([uuo_intcerr],[
	errnum_rb_uuo(12,$1,$2)])


/* Signal an error with a much smaller error number (0-31) and */
/* two "register" fields. */

define([uuo_interr2],[
	errnum_ra_rb_uuo(13,$1,$2,$3)])
	
/* Continuably .... */

define([uuo_intcerr2],[
	errnum_ra_rb_uuo(14,$1,$2,$3)])

/* Ask C to allocate a "large" (> 32K bytes) object.  Boxed element count in */
/* ra, boxed subtag in rb, boxed result goes in rt.  May GC or fail. */

define([uuo_xalloc],[
	rt_ra_rb_uuo(24,$1,$2,$3)])
	

/* A distinguished UUO:	the handler should zero the FPSCR */
define([uuo_zero_fpscr],[
	rt_ra_rb_uuo(25,0,0,0)])
