; -*- Mode:Lisp; Package:CCL; -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;


(in-package "CCL")

;I wanted a read that would not error even when given a #<
; and also allow backspace and such.
(defun read-line-no-error (&optional (stream *standard-output*) &aux result)
  (ignore-errors
     (setq result (read-from-string (read-line stream) nil))
     (return-from read-line-no-error (values result t)))
  (values nil nil))



;;;; Assert & Check-Type

;;; Assert-Value-Prompt  --  Internal
;;;
;;;    Prompt for a new value to set a place to.   We do a read-line,
;;; and if there is anything there, we eval it and return the second
;;; value true, otherwise it is false.
;;;
(defun assertion-value-prompt (place)
  (let* ((nvals (length (nth-value 2 (get-setf-method-multiple-value place))))
         (vals nil))
    (dotimes (i nvals)
      (if (eq nvals 1)
        (format *query-io* "Value for ~S: " place)
        (format *query-io* "Value ~D for ~S: " i place))
      (let* ((line (read-line *query-io*))
             (object  (read-from-string line nil *eof-value*)))
        (if (eq object *eof-value*)
            (return)
            (push (eval object) vals))))
    (values (nreverse vals) (not (null vals)))))

(defun %assertion-failure (setf-places-p test-form string &rest condition-args)
  (cerror 
   (if setf-places-p 
     "allow some places to be set and test the assertion again."
     "test the assertion again.")
   (cond
    ((stringp string)
     (make-condition 'simple-error
                     :format-control string
                     :format-arguments  condition-args))
    ((null string)
     (make-condition 'simple-error
                     :format-control "Failed assertion: ~S"
                     :format-arguments (list test-form)))
    ((typep string 'condition)
     (when  condition-args (error "No args ~S allowed with a condition ~S"  condition-args string))
     string)
    (t (apply #'make-condition string  condition-args)))))

