;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;

(in-package "CCL")

(defsparclapfunction %get-object ((macptr %arg_y) (offset %arg_z))
  (check-nargs 2)
  (trap-unless-typecode= macptr arch::subtag-macptr)
  (macptr-ptr macptr %imm0)
  (trap-unless-lisptag= %arg_z arch::tag-fixnum %imm1)
  (unbox-fixnum offset %imm1)
  (retl)
    (ld (%imm0 %imm1) %arg_z))

;; It would be awfully nice if (setf (%get-long macptr offset)
;;                                   (ash (the fixnum value) ppc::fixnumshift))
;; would do this inline.
(defsparclapfunction %set-object ((macptr %arg_x)
				  (offset %arg_y)
				  (value %arg_z))
  (check-nargs 3)
  (trap-unless-typecode= macptr arch::subtag-macptr)
  (macptr-ptr macptr %imm0)
  (trap-unless-lisptag= offset arch::tag-fixnum %imm1)
  (unbox-fixnum offset %imm1)
  (retl)
    (st value (%imm0 %imm1)))


;; It would be nice if (%setf-macptr macptr (ash (the fixnum value) arch::fixnumshift))
;; would do this inline.

(defsparclapfunction %setf-macptr-to-object ((macptr %arg_y) (object %arg_z))
  (check-nargs 2)
  (trap-unless-typecode= %arg_y ppc::subtag-macptr)
  (retl)
    (st object (macptr arch::macptr.address)))

(defsparclapfunction %fixnum-from-macptr ((macptr %arg_z))
  (check-nargs 1)
  (trap-unless-typecode= macptr arch::subtag-macptr)
  (macptr-ptr macptr %imm0)
  (trap-unless-lisptag= %imm0 arch::tag-fixnum %imm1)
  (retl)
    (mov %imm0 %arg_z))


;; This is machine-dependent (it conses up a piece of "trampoline" code
;; which calls a subprim in the lisp kernel.)
(defun make-callback-trampoline (index)
  (macrolet ((sparc-lap-word (instruction-form)
               (uvref (uvref (compile-named-function `(lambda (&lap 0) (sparc-lap-function () ((?? 0)) ,instruction-form (nop))) nil () () () () () () :sparc) 0) 0)))
    (let* ((nil-address (%address-of nil))
           (p (malloc 16)))
      ;; Pass Nil in %loc-g (aka %g1)
      (setf (%get-long p 0) (logior (ash nil-address -10) 
                                    (sparc-lap-word (sethi ?? %loc-g)))   ; high 22 bits of nil address
            (%get-long p 4) (logior (sparc-lap-word (or %loc-g ?? %loc-g))
                                    (logand (1- (ash 1 10)) nil-address))        ; low 10 bits nil address
	    ;; Pass the unboxed index in %g2.  By just using a MOV instruction,
	    ;; we limit the number of callback indices to 8K (signed).
	    ;; MCL uses about 4 or 5, and the POSIX API doesn't really make
	    ;; much (if any) use of callbacks, so 8K should be plenty
            (%get-long p 8) (sparc-lap-word (jmpl %loc-g #.(sparc::sparc-subprim-nil-offset .SPcallback) %rzero))
            (%get-long p 12) (logior (ldb (byte 13 0) index)
				     (sparc-lap-word (mov ?? %rnil)))) ;; aka %g2
      (ff-call (%kernel-import #.arch::kernel-import-makedataexecutable) 
               :address p 
               :unsigned-fullword 16
               :void)
      p)))
