;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;


;; L1-boot.lisp


(defparameter *gensym-counter* 0)

(defparameter *inhibit-greeting* nil)

;the below 3 variables are expected to be redefined in the user's init file
(defparameter *short-site-name* nil)
(defparameter *long-site-name* nil)
#|
(defparameter *machine-instance* nil)
|#

(defun lisp-implementation-type () "OpenMCL")

(defparameter *openmcl-version* "(Beta: ~A) 0.10.1")


(defun host-platform ()
  (let* ((pf (%get-kernel-global 'arch::host-platform)))
    (case pf
      (0 :macos)
      (1 :linux)
      (2 :vxworks)
      (3 :darwin)
      (16 :solaris)
      (t :unknown))))

(defun lisp-implementation-version ()
  (%str-cat "Version " (format nil *openmcl-version* (software-type))))


  



(defun home-directory () ())

(defun replace-base-translation (host-dir new-base-dir)
  (let* ((host (pathname-host host-dir))
         (host-dir (full-pathname host-dir))
         (trans (logical-pathname-translations host))
         (host-wild (merge-pathnames "**/*.*" host-dir)))
    (setq host-dir (pathname-directory host-dir))
    (setq new-base-dir (pathname-directory new-base-dir))
    (setf 
     (logical-pathname-translations host)
     (mapcar
      #'(lambda (pair)
          (let ((rhs (cadr pair)))
            (if (and (physical-pathname-p rhs)
                     (pathname-match-p rhs host-wild))
              (list (car pair)
                    (merge-pathnames 
                     (make-pathname 
                      :defaults nil 
                      :directory (append new-base-dir
                                         (nthcdr (length host-dir) 
                                                 (pathname-directory rhs))))
                     rhs))
              pair)))
      trans))))




; only do these if exist
(defun init-logical-directories ()  
  (let ((startup (mac-default-directory)))
    (replace-base-translation "home:" (or (user-homedir-pathname) startup))
    (replace-base-translation "ccl:" (ccl-directory))
    ))

(push #'init-logical-directories *lisp-system-pointer-functions*)

(catch :toplevel
  (setq *loading-file-source-file* nil)  ;Reset from last %fasload...
  (init-logical-directories)
  )





(defloadvar *heap-image-name*
    (let* ((p (%null-ptr)))
      (declare (dynamic-extent p))
      (%get-cstring (%get-kernel-global-ptr 'arch::image-name p))))

(defloadvar *command-line-argument-list*
  (let* ((argv (%null-ptr))
	 (res ()))
    (declare (dynamic-extent argv))
    (%get-kernel-global-ptr 'arch::argv argv)
    (do* ((i 0 (+ i 4))
	  (arg (%get-ptr argv i) (%get-ptr argv i)))
	 ((%null-ptr-p arg) (nreverse res))
      (declare (fixnum i))
      (push (%get-cstring arg) res))))
