;;;-*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;


(eval-when (:compile-toplevel :execute)
  (require "SPARC-ARCH")
  (require "SPARC-LAPMACROS"))

(defsparclapfunction eql ((x %arg_y) (y %arg_z))
  (check-nargs 2)
  @tail
  (cmp x y)
  (extract-lisptag x %imm0)
  (extract-lisptag y %imm1)
  (be @win)
    (cmp %imm0 arch::tag-misc)
  (bne @lose)
    (cmp %imm1 arch::tag-misc)
  (bne @lose)
    (getvheader x %imm0)
  ; Objects are both of tag-misc.  Headers must match exactly;
  ; dispatch on subtag.
  (getvheader y %imm1)
  (extract-lowbyte %imm1 %imm2)
  (cmp %imm2 arch::subtag-macptr)
  (be @macptr)
    (cmp %imm0 %imm1)
  (bne @lose)
    (cmp %imm2 arch::max-numeric-subtag)
  (bg @lose)
    (cmp %imm2 arch::subtag-ratio)
  (be @node)
    (cmp %imm2 arch::subtag-complex)
  (be @node)
  ; A single-float looks a lot like a macptr to me.
  ; A double-float is simple, a bignum involves a loop.
    (cmp %imm1 arch::subtag-bignum)
  (be @bignum)
    (cmp %imm1 arch::subtag-double-float)
  (bne @one-unboxed-word)
    (nop)
  ; This is the double-float case.
  (ld (x arch::double-float.value) %imm0)
  (ld (y arch::double-float.value) %imm1)
  (cmp %imm0 %imm1)
  (bne @lose)
    (ld (x arch::double-float.val-low) %imm0)
  (ld (y arch::double-float.val-low) %imm1)
  (cmp %imm0 %imm1)
  (bne @lose)
    (nop)
  @win
  (retl)
    (add %rnil arch::t-offset %arg_z)

  @macptr
  (extract-lowbyte %imm0 %imm0)
  (cmp %imm2 %imm0)
  (bne @lose)
    (nop)
  @one-unboxed-word
  (ld (x arch::misc-data-offset) %imm0)
  (ld (y arch::misc-data-offset) %imm1)
  (cmp %imm0 %imm1)
  (be @win)
    (nop)
  @lose
  (retl)
    (mov %rnil %arg_z)
  @bignum
  ; Way back when, we got x's header into %imm0.  We know
  ; that y's header is identical.  Use the element-count 
  ; from %imm0 to control the loop.  There's no such thing
  ; as a 0-element bignum, so the loop must always execute
  ; at least once.
  (header-size %imm0 %imm0)
  (mov arch::misc-data-offset %imm1)
  @bignum-next
  (ld (x %imm1) %imm2)
  (ld (y %imm1) %imm3)
  (cmp %imm2 %imm3)
  (bne @lose)
    (deccc %imm0)
  (bne.a @bignum-next)
    (inc 4 %imm1)
  (retl)
    (add %rnil arch::t-offset %arg_z)

  @node
  ; Have either a ratio or a complex.  In either case, corresponding
  ; elements of both objects must be EQL.  Recurse on the first
  ; elements.  If true, tail-call on the second, else fail.
  (vpush x)
  (vpush y)
  (save-lisp-context)
  (ld (x arch::misc-data-offset) x)
  (call @tail)
    (ld (y arch::misc-data-offset) y)
  (cmp %arg_z %rnil)
  (restore-full-lisp-context)
  (vpop y)
  (vpop x)
  (be @lose)
    (ld (x (+ 4 arch::misc-data-offset)) x)
  (b @tail)
    (ld (y (+ 4 arch::misc-data-offset)) y))
  


(defsparclapfunction equal ((x %arg_y) (y %arg_z))
  (check-nargs 2)
  @top
  (cmp x y)
  (extract-fulltag x %imm0)
  (extract-fulltag y %imm1)
  (be @win)
    (cmp %imm0 %imm1)
  (bne @lose)
    (cmp %imm0 arch::fulltag-cons)
  (be @cons)
    (cmp %imm0 arch::fulltag-misc)
  (bne @lose)
    (nop)
  (extract-subtag x %imm0)
  (extract-subtag y %imm1)
  (cmp %imm0 arch::subtag-macptr)
  (ble @eql)
    (cmp %imm0 arch::subtag-istruct)
  (be.a @same)
    (cmp %imm0 %imm1)
  (cmp %imm0 arch::subtag-vectorH)
  (bge @go)
    (nop)
  @lose
  (retl)
    (mov %rnil %arg_z)
  @same
  (bne @lose)
    (nop)
  @go
  (set-nargs 2)
  (jump-subprim .SPjmpsym)
    (ld (%nfn 'hairy-equal) %fname)
    
  @eql
  (set-nargs 2)
  (jump-subprim .SPjmpsym)
    (ld (%nfn 'eql) %fname)
    
  @cons
  (vpush x)
  (vpush y)
  (save-lisp-context)
  (ld (%rnil (arch::kernel-global cs-overflow-limit)) %imm0) ; stack probe
  (cmp %sp %imm0)
  (tlu sparc::trap-sp-overflow)
  (%car x x)
  (%car y y)
  (event-poll)
  (call @top)
    (nop)
  (cmp %arg_z %rnil)  
  (mov %fn %nfn)
  (restore-full-lisp-context)           ; gets old fn to fn  
  (vpop y)
  (vpop x)
  (be @lose)
    (%cdr x x)
  (b @top)
    (%cdr y y)
  @win
  (retl)
    (add %rnil arch::t-offset %arg_z))


      







