/*
 * Redirector.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/tgw/Redirector.cc,v 1.4 2002/02/10 02:54:56 lim Exp $ (UCB)"; 
#endif

#include "tclcl.h"
#include "tk.h"

#ifndef WIN32
#include "sys/time.h"
#endif
#include "inet.h"
#include "net.h"
#include "session-rtp.h"

// This class forwards data from one session to another.
// Note: it only forwards in one direction (isn't a bridge)
// used with tgw. For a bridge version, look at Reflector

class Redirector : public TclObject, public SessionHandler {
public:
	Redirector(int mtu);
	~Redirector();
	virtual int command(int argc, const char*const* argv);
	virtual void recv(DataHandler*);
protected:
  int mtu_;
  DataHandler* sinks_;
  DataHandler* source_;
  int forward_all;
  u_long srcid[50];
  u_char* pktbuf_;

  /* FIXME */
  virtual void recv(CtrlHandler*) {}
  virtual void announce(CtrlHandler*) {}
};

static class RedirectorClass : public TclClass {
    public:
	RedirectorClass() : TclClass("Redirector") {}
	TclObject* create(int, const char*const* argv) {
		return (new Redirector(atoi(argv[4])));
	}
} Redirector_class;

Redirector::Redirector(int mtu) 
	:mtu_(mtu), sinks_(0), source_(0), forward_all(0)
{
  for (int x=0;x<50;x++) {
    srcid[x]=0;
  }
  pktbuf_ = new u_char[2 * mtu];
}

Redirector::~Redirector()
{
	DataHandler* p = sinks_;
	while(p != 0) {
		DataHandler* t = p->next;
		delete p;
		p = t;
	}
	if (source_ != 0)
	  delete source_;
	
	delete pktbuf_;
}

int Redirector::command(int argc, const char*const* argv)
{
  if (argc == 2) {
    if (strcmp(argv[1], "add-all-sources") == 0) {
      forward_all = 1;
      return (TCL_OK);
    } else if (strcmp(argv[1], "remove-all-sources") == 0) {
      forward_all = 0;
      return (TCL_OK);
    }
  } else if (argc == 3) {
    if (strcmp(argv[1], "add-sink") == 0) {
      Network* n = (Network*)TclObject::lookup(argv[2]);
      DataHandler* dh = new DataHandler;
      dh->manager(this);
      dh->net(n);
      dh->next = sinks_;
      sinks_ = dh;
      return (TCL_OK);
    } else if (strcmp(argv[1], "add-source-net") == 0) {
      Network* n = (Network*)TclObject::lookup(argv[2]);
      DataHandler* dh = new DataHandler;
      dh->manager(this);
      dh->net(n);
      source_ = dh;
      return (TCL_OK);
    } else if (strcmp(argv[1], "add-source") == 0) {
      int next = 0;
      while ((srcid[next] != 0) && (next < 50))
	next++;
      if (next >= 50)
	printf("more then 50 active sources, increase buffer size!\n");
      srcid[next] = strtoul(argv[2],NULL,10);
      return (TCL_OK);
    } else if (strcmp(argv[1], "remove-source") == 0) {
      u_long toFind = strtoul(argv[2],NULL,10);
      int next = 0;
      while ((srcid[next] != toFind) && (next < 50))
	next++;
      if (next >= 50)
	printf("can't find that source to remove!\n");
      else
	srcid[next] = 0;
      return (TCL_OK);
    }
  }

  return (TclObject::command(argc, argv));
}

void Redirector::recv(DataHandler* dh)
{

  u_int32_t addr;
  int port;
  int cc = dh->recv(pktbuf_, 2 * mtu_, addr, port);
  if (cc <= 0)
    return;
  if (dh != source_)
    return;

  rtphdr* rh = (rtphdr*)pktbuf_;
  u_long recv_srcid = ntohl(rh->rh_ssrc);
  
  DataHandler* p;
  for (int temp=0;temp<50;temp++) {
    if ((recv_srcid == srcid[temp]) || (forward_all == 1)) {
      for (p = sinks_; p != 0; p = p->next) {
	p->send(pktbuf_, cc);
      }
      return;
    }
  }
}
