/*
 * tgmb-cmd.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef lint
static const char *rcsid = "@(#) $Header: /usr/mash/src/repository/mash/mash-1/tgmb/client/tgmb-cmd.cc,v 1.4 2002/02/03 04:17:39 lim Exp $";
#endif


#include <Pilot.h>
#include "tgmb-cmd.h"
#include "tgmb-app.h"
#include "tgmb-resource.h"

extern void Union(AbsRectType *r1, const AbsRectType *r2);
extern Boolean Intersect(AbsRectType *r1, const AbsRectType *r2);

static char *arrowTypeStrs_[] = { "none", "first", "last", "both" };
static char *colorStrs_[] = { "black", "dk gray", "lt gray", "white", "none" };

void
TGMB_Command::ToForm(FormPtr frm)
{
	static char w[5];
	ControlPtr ctl;

	sprintf(w, "%u", width_);
	ctl = (ControlPtr)
		FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,OF_WidthPopup));
	CtlSetLabel(ctl, w);

	ctl = (ControlPtr)
		FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,OF_ArrowPopup));
	CtlSetLabel(ctl, arrowTypeStrs_[arrowType_]);

	ctl = (ControlPtr)
		FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,OF_OutlinePopup));
	CtlSetLabel(ctl, colorStrs_[Word(cxt_.outlineClr) >> 6]);

	ctl = (ControlPtr)
		FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,OF_FillPopup));
	if (cxt_.fill)
		CtlSetLabel(ctl, colorStrs_[Word(cxt_.fillClr) >> 6]);
	else
		CtlSetLabel(ctl, colorStrs_[4]);
}


void
TGMB_Command::FromForm(FormPtr frm)
{
	ControlPtr ctl;
	CharPtr val;
	Word i;
	ctl = (ControlPtr)
		FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,OF_WidthPopup));
	Word w=StrAToI(CtlGetLabel(ctl));
	if (w > 0 & w <= 10) {
		width_ = w;
		SwitchZoom(book_->Zoom());
	}

	ctl = (ControlPtr)
		FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,OF_ArrowPopup));
	val = CtlGetLabel(ctl);
	for (i=0; i < sizeof(arrowTypeStrs_)/sizeof(char*); i++) {
		if (StrCompare(val, arrowTypeStrs_[i])==0) {
			arrowType_ = (ArrowType) i;
			break;
		}
	}

	Byte clrmap[] = { 0x00, 0x55, 0xAA, 0xFF, 0xFF };
	ctl = (ControlPtr)
		FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,OF_OutlinePopup));
	val = CtlGetLabel(ctl);
	for (i=0; i < sizeof(colorStrs_)/sizeof(char*); i++) {
		if (StrCompare(val, colorStrs_[i])==0) {
			cxt_.outlineClr = clrmap[i];
			break;
		}
	}

	ctl = (ControlPtr)
		FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,OF_FillPopup));
	val = CtlGetLabel(ctl);
	for (i=0; i < sizeof(colorStrs_)/sizeof(char*); i++) {
		if (StrCompare(val, colorStrs_[i])==0) {
			if (i==4) {
				// no fill
				cxt_.fill = 0;
				cxt_.fillClr = 0xFF;
			} else {
				cxt_.fill = 1;
				cxt_.fillClr = clrmap[i];
			}
			break;
		}
	}
}


void
TGMB_Command::Clear()
{
	if (nPoints_ > 0) {
		AbsRectType bbox;
		GetBoundingBox(&bbox);
		nPoints_ = 0;
		if (Intersect(&bbox, book_->ScreenRect()))
			book_->Refresh(&bbox);
	}
	else nPoints_ = 0;
}


void
TGMB_Command::Draw(WindowType *window)
{
	PointType pnt1, pnt2;
	if (nPoints_==0) return;
	points_ = (PointType*)MemHandleLock(handle_);
	cxt_.window = window;
	switch (currentType_) {
	case CanvObjType_Line:
	case CanvObjType_Arrow:
		book_->Page2Screen(points_, &pnt1);
		for (Word i=1; i<nPoints_; i++) {
			book_->Page2Screen(&points_[i], &pnt2);
			Win2_DrawLine(&cxt_, pnt1.x, pnt1.y, pnt2.x, pnt2.y);
			pnt2 = pnt1;
		}
		break;

	case CanvObjType_Rect:
		if (nPoints_ >= 2) {
			book_->Page2Screen(&points_[0], &pnt1);
			book_->Page2Screen(&points_[1], &pnt2);
			Win2_DrawRectangle(&cxt_, pnt1.x,pnt1.y,pnt2.x,pnt2.y);
		}
		break;

	case CanvObjType_Oval:
		if (nPoints_ >= 2) {
			book_->Page2Screen(&points_[0], &pnt1);
			book_->Page2Screen(&points_[1], &pnt2);
			Win2_DrawOval(&cxt_, pnt1.x, pnt1.y, pnt2.x, pnt2.y);
		}
		break;

	case CanvObjType_Text:
		book_->Page2Screen(points_, &pnt1);
		Win2_DrawText(&cxt_, pnt1.x, pnt1.y, (char*)(points_+1));
		break;
	default:
		break;
	}
	MemHandleUnlock(handle_);
}


#define EXPAND_BBOX(bbox, x, y) \
        if ((x) < (bbox)->left) (bbox)->left = (x); \
	else if ((x) > (bbox)->right) (bbox)->right = (x); \
	if ((y) < (bbox)->top) (bbox)->top = (y); \
	else if ((y) > (bbox)->bottom) (bbox)->bottom = (y);

void
TGMB_Command::GetBoundingBox(AbsRectType *bbox)
{
	if (nPoints_==0) {
		bbox->left = bbox->right = bbox->top = bbox->bottom = -1;
		return;
	}
	points_ = (PointType*)MemHandleLock(handle_);
	PointType pnt;
	book_->Page2Screen(points_, &pnt);
	bbox->left = bbox->right  = pnt.x;
	bbox->top  = bbox->bottom = pnt.y;

	for (Word i=1; i < nPoints_; i++) {
		book_->Page2Screen(&points_[i], &pnt);
		EXPAND_BBOX(bbox, pnt.x, pnt.y);
	}
	if (currentType_==CanvObjType_Text) {
		// Win2_GetTextBBox doesn't require you to set the window
		// field of the cxt_ structure
		Win2_GetTextBBox(&cxt_, &bbox->right, &bbox->bottom,
				 (char*)(points_+1));
		bbox->bottom += bbox->top  - 1;
		bbox->right  += bbox->left - 1;
	}
	MemHandleUnlock(handle_);
}


Boolean
TGMB_Command::Start(SWord x, SWord y, AbsRectType *clip)
{
	if (x < clip->left || x > clip->right ||
	    y < clip->top  || y > clip->bottom) return false;

	switch (currentType_) {
	case CanvObjType_Line:
	case CanvObjType_Arrow:
	case CanvObjType_Rect:
	case CanvObjType_Oval:
		Clear();
		points_ = (PointType*)MemHandleLock(handle_);
		InsertPoint_(x, y);
		MemHandleUnlock(handle_);
		break;

	case CanvObjType_Text:
		if (nPoints_!=0) EndText();
		// Ignore
		break;

	default:
		break;
	}
	return true;
}


void
TGMB_Command::SwitchPage()
{
	if (nPoints_ > 0 && currentType_==CanvObjType_Text) EndText();
	else Clear();
}


void
TGMB_Command::SwitchZoom(DWord z)
{
	cxt_.width = (Word(width_) * z)/100;
	if ((Word(width_) * z) % 100) cxt_.width++;
}


void
TGMB_Command::SwitchType(CanvObjType newType)
{
	if (newType==currentType_) return;
	if (nPoints_!=0) {
		if (currentType_==CanvObjType_Text) EndText();
		Clear();
	}
	currentType_ = newType;
}


Boolean
TGMB_Command::Move(SWord x, SWord y, AbsRectType *clip)
{
	AbsRectType oldclip, bbox1, bbox2;
	PointType pnt1, pnt2;

	if (x < clip->left || x > clip->right ||
	    y < clip->top  || y > clip->bottom) return false;

	if (nPoints_==0) // we haven't started yet!
		return false;

	points_ = (PointType*)MemHandleLock(handle_);
	if (x==points_[nPoints_-1].x && y==points_[nPoints_-1].y) {
		// we haven't really moved
		MemHandleUnlock(handle_);
		return true;
	}
	switch (currentType_) {
	case CanvObjType_Line:
		InsertPoint_(x, y);
		cxt_.window = Win2_GetOnscreenWindow();
		oldclip = cxt_.window->clippingBounds;
		cxt_.window->clippingBounds = *clip;
		book_->Page2Screen(&points_[nPoints_-2], &pnt1);
		book_->Page2Screen(&points_[nPoints_-1], &pnt2);
		Win2_DrawLine(&cxt_, pnt1.x, pnt1.y, pnt2.x, pnt2.y);
		cxt_.window->clippingBounds = oldclip;
		break;

	case CanvObjType_Arrow:
	case CanvObjType_Rect:
	case CanvObjType_Oval:
		GetBoundingBox(&bbox1);
		SecondPoint_(x, y);
		GetBoundingBox(&bbox2);
		Union(&bbox1, &bbox2);
		MemHandleUnlock(handle_);
		if (Intersect(&bbox1, book_->ScreenRect()))
			book_->Refresh(&bbox1);
		return true;

	case CanvObjType_Text:
		// Ignore
		break;

	default:
		break;
	}
	MemHandleUnlock(handle_);
	return true;
}


Boolean
TGMB_Command::End(SWord x, SWord y, AbsRectType *clip)
{
	if (currentType_==CanvObjType_Text) {
		if (x < clip->left || x > clip->right ||
		    y < clip->top  || y > clip->bottom) return false;
		points_ = (PointType*)MemHandleLock(handle_);
		InsertPoint_(x, y);
		*(BytePtr)(points_+1) = '\0';
		MemHandleUnlock(handle_);
	} else {
		Move(x, y, clip);
		if (nPoints_ < 2) {
			// this command seems incomplete
			Clear();
			return false;
		}

		// must construct a command to send to the RMX
		CreateAndSendCommand();
	}
	return true;
}


void
TGMB_Command::CreateAndSendCommand()
{
#if 0
	TGMB_ObjectId id;
	Word saveNPoints = nPoints_;

	// we call clear before creating the object because
	// CreateObjectFromCommand has a side-effect of converting the
	// points to Page coords. However, we must save the original
	// nPoints_ value before calling Clear(), so that the rest
	// of this function may operate correctly
	Clear();
	nPoints_ = saveNPoints;
	book_->CreateObjectFromCommand(&id);
	SendCommand(id);
	nPoints_ = 0;
#endif
	TGMB_ObjectId id;
	book_->CreateObjectFromCommand(&id);
	SendCommand(id);
	Clear();
}


void
TGMB_Command::SendCommand(TGMB_ObjectId id)
{
	TGMB_Session *session = APP->Session();
	if (!session->IsConnected()) return;

	Chunk chunk;

	// Metadata: type ContentTGMB_Control
	void *metadata = chunk.CreateAndLock(chunk.metadataHandle, 50);
	if (!metadata) return;
	Word ms = chunk.InsertFrag(metadata, MetaContentType,
				   ContentTGMB_CanvasCmds);
	chunk.Unlock(chunk.metadataHandle);

	points_ = (PointType*)MemHandleLock(handle_);
	Word more = ((currentType_==CanvObjType_Text) ?
		     (sizeof(Word[2])*2 + StrLen((char*)(points_+1))+2
		      + 10) : 0);
	DWord hdrLen = sizeof(PageId) + 3*sizeof(DWord) + sizeof(SrcId);
	void *data = chunk.CreateAndLock(chunk.dataHandle,
					 hdrLen +
					 sizeof(Word[2]) + // descrCoords
					 sizeof(PointType) * nPoints_ +
					 sizeof(Word[2]) + // descrItemType
					 sizeof(Word) +
					 (sizeof(Word[2]) + // item-specific
					  sizeof(Word)) * 3 +
					 more);

	if (!data) {
		chunk.Free(chunk.metadataHandle);
		MemHandleUnlock(handle_);
		return;
	}

	Word ds;

	DWord cmd=cmdCanvasCreate;
	DWord *lenPtr;

	MemMove(data, (void*)&APP->Book()->CurrentPage()->Id(),sizeof(PageId));
	data = BytePtr(data) + sizeof(PageId);
	MemSet(data, sizeof(DWord), 0); //canvCmdId
	data = BytePtr(data) + sizeof(DWord);
	MemMove(data, (void*)&session->MySrcId(), sizeof(SrcId)); //srcId
	data = BytePtr(data) + sizeof(SrcId);
	MemMove(data, &cmd, sizeof(DWord)); //cmd
	data = BytePtr(data) + sizeof(DWord);
	lenPtr = (DWord*)data; //len
	data = BytePtr(data) + sizeof(DWord);

	ds = chunk.InsertAnyFrag(data, descrCoords,
				 points_, Word(sizeof(PointType) * nPoints_),
				 ENDFRAG);
	switch(currentType_) {
	case CanvObjType_Line:
	case CanvObjType_Arrow:
		ds += chunk.InsertFrag(data+ds,descrItemType,GetItemType());
		ds += chunk.InsertFrag(data+ds, descrArrow, (Word)
				       ((currentType_==CanvObjType_Line) ?
				       ArrowNone : arrowType_));
		ds += chunk.InsertFrag(data+ds, descrColor,
				       (Word)(Word(cxt_.outlineClr) << 8));
		ds += chunk.InsertFrag(data+ds, descrWidth, (Word)width_);
		break;

	case CanvObjType_Rect:
	case CanvObjType_Oval:
		ds += chunk.InsertFrag(data+ds,descrItemType,GetItemType());
		ds += chunk.InsertFrag(data+ds, descrColor,
				       (Word)(Word(cxt_.outlineClr) << 8));
		if (cxt_.fill)
			ds += chunk.InsertFrag(data+ds, descrFill, (Word)
					       (Word(cxt_.fillClr) << 8));
		ds += chunk.InsertFrag(data+ds, descrWidth, (Word)width_);
		break;

	case CanvObjType_Text:
		ds += chunk.InsertFrag(data+ds,descrItemType,GetItemType());
		ds += chunk.InsertFrag(data+ds, descrColor,
				       (Word)(Word(cxt_.outlineClr) << 8));
		ds += chunk.InsertAnyFrag(data+ds, descrText,
					  (char*)(points_+1),
					  StrLen((char*)(points_+1))+1,
					  ENDFRAG);
		ds += chunk.InsertAnyFrag(data+ds, descrFont,
					  "fixed", 6, ENDFRAG);
		break;

	default:
		break;
	}

	*lenPtr = ds;
	chunk.Unlock(chunk.dataHandle);
	chunk.SetHeader((DWord)id, ms, ds+hdrLen);

	// Do the send
	session->Send(&chunk);
	chunk.Free(chunk.dataHandle);
	chunk.Free(chunk.metadataHandle);

	MemHandleUnlock(handle_);
}


void
TGMB_Command::EndText()
{
	if (nPoints_!=1) {
		// this command seems bogus
		Clear();
		return;
	}

	// must construct a command to send to the RMX
	CreateAndSendCommand();
}


Boolean
TGMB_Command::KeyPress(char key, AbsRectType *clip)
{
	if (currentType_!=CanvObjType_Text || nPoints_!=1) return false;

	if (key=='\b') {
	} else {
		points_ = (PointType*)MemHandleLock(handle_);
		char *text = (char*)(points_+1);
		Word len = StrLen(text);
		if (size_ < sizeof(PointType) + len+2) {
			if (!Grow_()) {
				MemHandleUnlock(handle_);
				return true;
			}
		}
		text[len] = key;
		text[len+1] = '\0';

		cxt_.window = Win2_GetOnscreenWindow();
		AbsRectType oldclip = cxt_.window->clippingBounds;
		cxt_.window->clippingBounds = *clip;
		PointType pnt;
		book_->Page2Screen(points_, &pnt);
		Win2_DrawText(&cxt_, pnt.x, pnt.y, text);
		cxt_.window->clippingBounds = oldclip;
		MemHandleUnlock(handle_);
	}
	return true;
}


Boolean
TGMB_Command::InsertPoint_(SWord x, SWord y)
{
	if (nPoints_==0 && book_->CurrentPage()==NULL) {
		book_->CreateNewPage();
	}

	if (size_ < (nPoints_+1) * sizeof(PointType)) {
		if (!Grow_()) return false;
	}

	PointType pnt={x, y};
	book_->Screen2Page(&pnt, &points_[nPoints_]);
	nPoints_++;
	return true;
}


Boolean
TGMB_Command::Grow_()
{
	MemHandleUnlock(handle_);
	if (MemHandleResize(handle_, size_ + 25 * sizeof(PointType))) {
		points_ = (PointType*)MemHandleLock(handle_);
		return false;
	}
	size_ += 25 * sizeof(PointType);
	points_ = (PointType*)MemHandleLock(handle_);
	return true;
}


void
TGMB_Command::SecondPoint_(SWord x, SWord y)
{
	PointType pnt = {x, y};
	book_->Screen2Page(&pnt, &points_[1]);
	nPoints_ = 2;
}
