/*
 * tgmb-canv.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tgmb/client/tgmb-canv.h,v 1.5 2002/02/03 04:17:39 lim Exp $
 */

#ifndef MASH_TGMB_CANV_H
#define MASH_TGMB_CANV_H


#include "tgmb-page.h"

class TGMB_Canvas;
class TGMB_Scrollbar {
public:
	TGMB_Scrollbar(TGMB_Canvas *c);
	inline void Draw() { Draw(sbAll, 0); }
	Boolean HandleEvent(EventPtr e);
private:
	enum SB_Arrow { sbAll, sbLeft, sbTop, sbRight, sbBottom, sbNone };
	void Draw(SB_Arrow which, Boolean highlighted);

	AbsRectType bbox_;
	SB_Arrow highlightedArrow_;
	TGMB_Canvas *canv_;
};


class TGMB_Canvas {
public:
	TGMB_Canvas() : oneBitWindow_(NULL), scrollbar_(this),
		isCheck_(0), inCanv_(0) {}
	void Init(WinHandle oneBitWindow) {
		oneBitWindow_ = oneBitWindow;
	}

	void Refresh();
	Boolean HandleEvent(EventPtr e);

#define SCROLLRES 40
	void MoveUp();
	void MoveDown();
	void MoveLeft();
	void MoveRight();

	void DrawCheckCross(Boolean isCheck);
	static void ScreenRect(AbsRectType *bbox);
private:
	WinHandle      oneBitWindow_;
	TGMB_Scrollbar scrollbar_;
	Boolean        isCheck_;
	Boolean        inCanv_;
};


#endif /* #ifdef MASH_TGMB_CANV_H */
