# agent-scubagw.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/vgw/agent-scubagw.tcl,v 1.12 2002/02/03 04:39:50 lim Exp $

import RTPGWAgent/Video Session/Scuba/RTPGW/VGW AddressBlock

Class RTPGWAgent/Video/Scuba -superclass RTPGWAgent/Video

RTPGWAgent/Video/Scuba instproc activate { src } {
	$self next $src

	$self all_allocations_but [$src set session_]
}

RTPGWAgent/Video/Scuba instproc deactivate { src } {
	$self next $src

	$self all_allocations_but [$src set session_]
}

# Set all the allocations except for session 'sess'
RTPGWAgent/Video/Scuba instproc all_allocations_but { sess } {
	$self instvar sessions_ scuba_sess_
	foreach s $sessions_ {
#		if { $s == $sess } {
#			continue
#		}

		$scuba_sess_($s) set_allocation
	}
}

RTPGWAgent/Video/Scuba instproc add_session { sname spec } {
	$self next $sname $spec

	# Have an RTP session now
	$self instvar sessbyname_ scuba_sess_ app_

	set rtpsess $sessbyname_($sname)
	set sm [$rtpsess sm]
	set s [new Session/Scuba/RTPGW/VGW $rtpsess $sm $self $spec]
	$sm attach $s
	set scuba_sess_($rtpsess) $s
	$s sessionbw [$app_ get_option scubabw]

	# Don't confine the scuba reports to the local session
	if { [$app_ get_option useScuba]  == "global" } {
#puts "vgw: $s ($sname): starting scuba control"
		$s start-control
	}
}

RTPGWAgent/Video/Scuba instproc reset_spec spec {
	$self instvar sessbyname_ scuba_sess_

	set gsess $sessbyname_(global)
	set ab [new AddressBlock $spec]
	$scuba_sess_($gsess) reset $ab
	delete $ab

	$self next $spec
}

RTPGWAgent/Video/Scuba instproc create-transcoder { src osess ifmt ofmt } {
	set t [$self next $src $osess $ifmt $ofmt]
	$t rtcp-thumbnail 1
	return $t
}

RTPGWAgent/Video/Scuba instproc sessionbw { b sess } {
	$self instvar scuba_sess_
	$scuba_sess_($sess) sessionbw $b

	$self next $b $sess
}


RTPGWAgent/Video/Scuba instproc voters { srcid } {
	$self instvar scuba_sess_ sessions_
	set ret ""
	foreach s $sessions_ {
		$scuba_sess_($s) instvar scoretab_
		foreach e [array names scoretab_ *:$srcid] {
			lappend ret "$scuba_sess_($s) $e"
		}
	}
	return $ret
}

RTPGWAgent/Video/Scuba instproc score { v } {
	set scuba_sess [lindex $v 0]
	set e [lindex $v 1]
	return [$scuba_sess set scoretab_($e)]
}
