# switch2graph.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

global g_levels g_outfile g_infile g_prevMode

proc init {} {
    global g_levels

    set g_levels(speakerCamera) 105
    set g_levels(wideCamera) 205

    # need to split this into left, center, right
    set g_levels(audienceCamera) 155

}

proc makeOutfile {} {
    global g_levels g_infile g_prevMode

    if {[catch {open $g_infile r} infile]} {
        puts stdout "Cannot open file $g_infile for reading"
        return 0
    }

    # at this point, infile is open

    # the first line has the starting position
    gets $infile line
    set sLine [split $line " "]
    set host [lindex $sLine 0]
    set mode [lindex $sLine 1]
    set index [lindex $sLine 2]
    puts stdout "$index $g_levels($mode)"
    set g_prevMode $mode
    while {[gets $infile line] >= 0} {
	set sLine [split $line " "]
	set host [lindex $sLine 0]
	set mode [lindex $sLine 1]
	set index [lindex $sLine 2]
	processEntry $index $mode $host
    }

    close $infile
}

proc processEntry {index mode host} {
    global g_levels g_prevMode

    # FIXME - this is a total hack for now
    if {$host != "htsr"} {
	# we don't care about it now
	return ""
    }
    switch -exact -- $mode {
	speakerCamera -
	wideCamera -
	audienceCamera {
	    set prev [expr $index - 1]
	    puts stdout "$prev $g_levels($g_prevMode)"
	    puts stdout "$index $g_levels($mode)"
	    set g_prevMode $mode
	}
    }
}

# main program

if {[llength $argv] != 1} {
    puts stdout "Usage: switch2graph <log.switch file>"
    exit
}
set g_infile [lindex $argv 0]

init

makeOutfile

