#!/bin/sh
# path trick for tclsh variants \
exec tclsh $0 ${1+"$@"}

# checksame.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

global g_data g_indices g_duplicates

proc makegraph {filename} {
    global g_data g_indices g_duplicates g_max

    set g_max 0
    if {$filename == "stdin"} {
	set fd "stdin"
    } else {
	if [catch {open $filename r} fd] {
	    puts stdout "Cannot open file $filename"
	    return 0
	}
    }

    set sets [list]
    while {[gets $fd line] >= 0} {
	set processLine 0
	set type "none"
	if {!($line == "")} {
#	    puts stdout "\t$line"
	    if {[isNumber $line]} {
#		puts stdout "is number"
		set type "entry"
	    }
	    if {[isLabel $line]} {
#		puts stdout "is label"
		set type "label"
	    }
	} else {
	    set type "blank"
	}

	switch -exact -- $type {
	    entry {
		set sLine [split $line " "]
		set index [lindex $sLine 0]
		set val [lindex $sLine 1]

		set g_indices($index) 1
		set g_data($curSet,$index) $val
	    }
	    label {
		lappend sets $line
		set curSet $line
	    }
	    blank {
	    }
	    default {
		puts stdout $line
	    }
	}
    }

    close $fd

    foreach group $sets {
#	puts stdout "checking $group"
	set unique($group) [checkEquals $sets $group]
    }

    puts stdout ""
    set msg ""
    set offset [expr double($g_max) * 0.01]
    foreach group $sets {
	if {$unique($group)} {
	    puts stdout "$group"
	    foreach index [lsort -integer [array names g_indices]] {
		puts stdout "$index $g_data($group,$index)"
	    }
	    puts stdout ""
	} else {
	    puts stdout "\"$g_duplicates($group,msg)\""
	    foreach index [lsort -integer [array names g_indices]] {
		puts stdout "$index [expr $g_max + $offset]"
	    }
	    puts stdout ""
	}
    }

    return 1
}

proc checkEquals {sets base} {
    global g_indices g_data g_duplicates g_max

    set unique 1
    foreach group $sets {
	if {$group != $base} {
#	    puts stdout "\tchecking against $group"
	    set same 1
	    foreach index [array names g_indices] {
		if {$g_data($base,$index) > $g_max} {
		    set g_max $g_data($base,$index)
		}
#		puts -nonewline stdout "\t\t$index:  "
#		puts stdout "$g_data($base,$index) ... $g_data($group,$index)"
		if {$g_data($base,$index) != $g_data($group,$index)} {
#		    puts stdout "\t\t\t\tnot equal"
		    set same 0
		}
	    }
	    if {$same} {
		set g_duplicates($base,$group) 1
		if {[info exists g_duplicates($group,$base)]} {
		    # we've already found this pair
		    puts stderr "eliminating duplicate pair"
		    set unique 0
		    set strippedBase [string trim $base "\""]
		    set strippedGroup [string trim $group "\""]
		    set g_duplicates($base,msg) "$strippedBase == $strippedGroup"
		} else {
		    puts stderr "$base == $group";
		}
	    }
	}
    }
    return $unique
}

# returns 1 if it's a number, 0 otherwise
proc isNumber {str} {
    set firstChar [string index $str 0]
    switch -exact -- $firstChar {
	0 -
	1 -
	2 -
	3 -
	4 -
	5 -
	6 -
	7 -
	8 -
	9 {
	    return 1
	}
    }
    # all else return 0
    return 0
}

# returns 1 if it's a label
proc isLabel {str} {
    set firstChar [string index $str 0]
    if {$firstChar == "\""} {
	return 1
    }

    # all else return 0
    return 0
}

# returns 1 if it's an X label
proc isXLabel {str} {
    set firstChar [string index $str 0]
    switch -exact -- $firstChar {
	X {
	    set sLine [split $str ":"]
	    if {[lindex $sLine 0] == "XUnitText"} {
		return 1
	    }
	}
    }
    # all else return 0
    return 0
}

# main program

if {[llength $argv] != 1} {
    puts stdout "usage: checksame <filename>"
    exit
}
set filename [lindex $argv 0]

#  set retval [isLabel "\"hello\""]
#  puts stdout "retval is $retval"
#  set retval [isLabel 400]
#  puts stdout "retval is $retval"
#  set retval [isLabel "slurpy"]
#  puts stdout "retval is $retval"

#  exit


makegraph $filename

