# application-desc.tcl --
#
#       Creates a BroadcastDescription object and gives it a frame to display
#       in
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import Application BroadcastDescription

Class BroadcastDescriptionApplication -superclass Application

BroadcastDescriptionApplication instproc init {argv} {
    $self instvar bd_
    $self next "desc"

    $self initArgs
    set options [$self options]
    # parse command line args
    $options parse_args $argv

    $self initUI

    set spec [list]
    # Broadcast Description Info
    # description file
    lappend spec [$options get_option descriptionFile]
    # DC host/port
    lappend spec [$options get_option dcHost] [$options get_option dcPort]
    # recorder host/port
    lappend spec [$options get_option recorderHost] [$options get_option recorderPort]
    lappend spec ""

    set bd_ [new BroadcastDescription .bdFrame $spec]
}

BroadcastDescriptionApplication instproc initArgs {} {
    set options [$self options]

    # register valid options
    $options register_option -df descriptionFile
    $options register_option -dh dcHost
    $options register_option -dp dcPort
    $options register_option -rh recorderHost
    $options register_option -rp recorderPort

    # set up defaults
    $options add_default descriptionFile "migs.desc.tcl"
    $options add_default dcHost "garfield.cs.berkeley.edu"
    $options add_default dcPort "6907"
    $options add_default recorderHost "garfield.cs.berkeley.edu"
    $options add_default recorderPort "6909"
}

BroadcastDescriptionApplication instproc initUI {} {
    wm title . "BroadcastDescription"
    wm minsize . 200 100

    # make broadcast description frame
    frame .bdFrame
    pack .bdFrame -side top

    # make exit button
    button .exit -text "Exit" -command "$self exitApp"
    pack .exit -side bottom
}

BroadcastDescriptionApplication instproc exitApp {} {
    $self instvar bd_

    $bd_ destroy

    exit
}

BroadcastDescriptionApplication instproc enableBroadcastDescription {} {
    $self instvar bd_

    $bd_ enable
}

BroadcastDescriptionApplication instproc disableBroadcastDescription {} {
    $self instvar bd_

    $bd_ disable
}
