# rtp-source-gen.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import RTPApplication
import VideoAgent

Class RTPSourceGenApp -superclass RTPApplication

RTPSourceGenApp instproc init args {
    $self next "RTPSourceGen"

    [$self options] register_option -in_spec in_spec;
    [$self options] register_option -out_spec out_spec;

    $self init_resources;

    eval [$self options] parse_args $args;

    $self instvar in_vagent_ out_vagent_ rtp_source_gen_;

    set rtp_source_gen_ [new RTPSourceGenerator];

    set in_vagent_ [new InVAgent $self [$self get_option in_spec] $rtp_source_gen_];
    set out_vagent_ [new VideoAgent $self [$self get_option out_spec]];

    $rtp_source_gen_ ssrc [$out_vagent_ get_local_srcid];
    $rtp_source_gen_ target [$out_vagent_ get_transmitter];
    [$out_vagent_ get_transmitter] set loopback_ 0;

    $self build_ui;
}

RTPSourceGenApp instproc build_ui {} {
    $self instvar frate_slider_  button_frame_
    $self instvar rec_but_ play_but_ stop_but_;
    $self instvar rtp_source_gen_;

    set frate_slider_ [scale .fs -label "Framerate" -orient h -from 1 -to 100 -command "$rtp_source_gen_ framerate " -resolution 0.1];
    set button_frame_ [frame .butframe];
    set rec_but_ [button .butframe.rec -command "$rtp_source_gen_ record" -text "Record"];
    set stop_but_ [button .butframe.stop -command "$rtp_source_gen_ stop" -text "Stop"];
    set play_but_ [button .butframe.play -command "$rtp_source_gen_ play" -text "Play"];

    pack $rec_but_ -side left -fill both -expand 1;
    pack $stop_but_ -side left -fill both -expand 1;
    pack $play_but_ -side right -fill both -expand 1;

    pack $frate_slider_ -side top -fill both -expand 1;
    pack $button_frame_ -side top -fill both -expand 1;

    $self instvar save_frame_
    $self instvar save_e_ save_b_ load_b_;

    set save_frame_ [frame .savef];
    set save_e_ [entry .savef.e];
    set save_b_ [button .savef.sb -text "Save" -command "$rtp_source_gen_ save \[$save_e_ get\]"];
    set load_b_ [button .savef.lb -text "Load" -command "$rtp_source_gen_ load \[$save_e_ get\]"];
    pack $save_e_ -side left -fill both -expand 1;
    pack $save_b_ -side right -fill both;
    pack $load_b_ -side right -fill both;
    pack $save_frame_ -side top -fill both -expand 1;

    $self instvar out_label_;
    $self instvar in_label_;

    set in_label_ [label .in_spec -text "In: [$self get_option in_spec]"];
    set out_label_ [label .out_spec -text "Out: [$self get_option out_spec]"];

    pack $in_label_ -side top -fill both -expand 1;
    pack $out_label_ -side top -fill both -expand 1;

}

RTPSourceGenApp instproc remote_cmd {cmd} {
    $self instvar rtp_source_gen_;

    $rtp_source_gen_ $cmd;
}

RTPSourceGenApp instproc init_resources {} {
    $self add_option network ip
    $self add_option mtu 1024
    $self add_option defaultTTL 32
    $self add_option sessionType rtpv2
    $self add_option maxVideoSessionBW 30000000
    $self add_option in_spec 224.2.3.4/22334
    $self add_option out_spec 224.2.3.5/22336
}


Class InVAgent -superclass VideoAgent;

InVAgent instproc init {app spec gen} {
    $self next $app $spec;

    $self instvar gen_ attached_;
    set gen_ $gen;
    set attached_ 0;

}

InVAgent instproc create_decoder {src} {
    $self instvar gen_ attached_;

    if {!$attached_} {
	set attached_ 1;
	set d $gen_;
    } else {
	set d [new Module/VideoDecoder/Null];
    }
    $d set agent_ $self;
    $d set src_ $src;
    return $d;
}

InVAgent instproc deactivate src {
    $self instvar gen_;

    set d [$src handler];
    if {$d != $gen_} {
	$self next $src;
    }
}

set app [new RTPSourceGenApp $argv];

