# application-asmon.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/mgamon/application-asmon.tcl,v 1.6 2002/02/03 04:27:48 lim Exp $


import Application ASMonitorUI AnnounceListenManager/AS/ASMon MeGa

Class ASMonApplication -superclass Application

ASMonApplication instproc init argv {
	$self next asmon

	$self instvar ui_

	set o [$self options]
	$self init_args $o
	$self init_resources $o
	$o parse_args $argv

	# Source the user's hook file if it exists. The function
	# user_hook, which may be defined in this file, will be
	# called at the end of init.
	if {[$o get_option userhookFile] != ""} {
		if {[file isfile [$o get_option userhookFile]] && \
			[file readable [$o get_option userhookFile]]} {
			source [$o get_option userhookFile]
		} else {
			puts stderr "Unable to source \"[$o get_option userhookFile]\". Not a file or not readable."
		}
	}

	set ui_ [ASMonitorUI .top]
	pack .top -fill both -expand 1
	.top application $self

	$self init_network .top

	$self user_hook
}


ASMonApplication instproc init_args o {
	$o register_option -u userhookFile
	$o register_option -log doLog
	$o register_option -megactrl asCtrl
}

ASMonApplication instproc init_resources o {
	$o add_default defaultTTL 1
	$o add_default asCtrl 224.4.5.24/50000/31
	$o add_default asCtrlBW 20000
}


ASMonApplication instproc init_network { ui } {
	set megaspec [$self get_option asCtrl]
	set bw [$self get_option asCtrlBW]
	$self instvar al_
	foreach m { audio video sdp mb hm srv } {
		set spec [MeGa ctrlchan $m $megaspec]
		set al_($m) [new AnnounceListenManager/AS/ASMon \
				$ui $spec $bw]
	}
}

ASMonApplication instproc build_death { atype } {
	$self instvar al_
	set al $al_($atype)

	set o "ASCP v[AnnounceListenManager/AS version]"
	set n mgamon
	set o $o\n$n
	set n [$al agent_instance]
	set o $o\n$n
	set n "DEATH"
	set o $o\n$n
	set n $atype
	set o $o\n$n
	set n "-"
	set o $o\n$n
	set n "-"
	set o $o\n$n

	$al announce $o
}

