# application-mb.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/mb/application-mb.tcl,v 1.71 2002/02/03 04:27:17 lim Exp $


import RTPApplication MTrace Tcl_Player Tcl_Recorder \
	AddressBlock NetworkManager \
	MBDebugDlg MBUI MBPSInterp MB_Manager MBPageMgr FontInitializer MBNet

# The mediaboard application.
Class MBApp -superclass RTPApplication

#
# Initialize the global variables we need
# Creates a frame using the provided <i>widgetPath</i> and packs the mediaboard into it.
#
MBApp public init { widgetPath argv } {
	$self instvar mbui_

        $self next mb

	set o [$self options]
	$self init_args $o
        $self init_resources $o
        $self init_fonts $o
	$o load_preferences "mb"
	set argv [$o parse_args $argv]
	#FIXME check for extra args?

        MTrace init {trcMB}
	$self check_rtp_sdes

        $self init_variables
        $self init_UI $widgetPath
	$self instvar mgr_
	set mbnet [new MBNet $mbui_ $mgr_]
	$self instvar session_ mbAgent_
	set session_ [$mbnet session]
	set mbAgent_ [$mbnet mbAgent]
	$mbnet adjust_spec

        set logf [$o get_option playScript]
        if {"none" != $logf} {
                global mb
                set isRT [$config get_option rtPlay]
                set player [new Tcl_Player $logf [$self set sender_] $isRT]
                # wait for 1 second for everything to settle down
                after 15000 $player start
        }

	$self init_local
}

#
MBApp public destroy {} {
        $self instvar mbAgent_ mbui_ mgr_
        global mb
	# agent will delete the session
	delete $mbAgent_
	delete $mbui_
	delete $mb(gsinterp)
	delete $mgr_
}

#
MBApp public exit {} {
	delete $self
	exit
}

#
MBApp instproc init_args {o} {
        # temporary parameter for debugging
	$o register_option -u    uid
	$o register_option -dbg  debug

	# session address
	$o register_option -sa   mbSessionSpec
	$o register_option -ui   showUI
	$o register_option -drop drop
	$o register_option -play playScript
	$o register_option -rt   rtPlay
	$o register_option -rec  record
	$o register_option -tr   trace
	$o register_option -dp   delayParams
	$o register_option -follow followActive
	$o register_option -C conferenceName
	$o register_option -K sessionKey

	$o register_boolean_option -recvonly recvOnly

	$o register_option -geometry geometry

	# MeGa resources
	$o register_option -rport megaRecvMbPort
	$o register_option -ofmt megaMbFormat
	$o register_option -usemega megaMbSession
	$o register_option -megactrl megaMbCtrl
	$o register_option -sspec mbSessionSpec
	$o register_option -maxsbw maxMbSessionBW
	$o register_option -sbw mbSessionBW
	$o register_option -sloc mbServiceLocation
}

#
MBApp instproc ui_init_default { } {
	# using 19 as the priority level, since it's one less than
	# widgetDefault, which is the level used by all WidgetClass objects

	option add *Button*HighlightThickness 1 19
	option add *Button*BorderWidth 1 19

	option add *Scrollbar*HighlightThickness 1 19
	option add *Scrollbar*BorderWidth 1 19

	# FIXME: a hack to shrink the scrollbar size
	set scrollbar [scrollbar .___scrollbar___]
	set scrollbarWidth [$scrollbar cget -width]
	set scrollbarWidth [expr {($scrollbarWidth * 2)/3}]
	destroy $scrollbar
	option add *Scrollbar*Width $scrollbarWidth 19

	option add *Entry*HighlightThickness 1 19
	option add *Entry*BorderWidth 2 19
	option add *Entry*Background White 19
	option add *Menubutton*HighlightThickness 1 19
	option add *Menubutton*BorderWidth 1 19
}

#
MBApp instproc init_variables {} {
        global mb

        $self ui_init_default
        catch {unset mb}

	$self instvar sender_
        if {[$self get_option record]==1} {
                set sender_ [new Tcl_Recorder MB_Sender]
        } else {
                set sender_ [new MB_Sender]
        }

	$self instvar mgr_
	set mgr_ [new MB_Manager]
	set pageMgr [new MBPageMgr $mgr_]
	$mgr_ attach_page_manager $pageMgr
	$mgr_ attach_sender $sender_
}

#
MBApp instproc reset { ab } {
	$self instvar mbAgent_ mbui_ mgr_ session_

	set nm [$mbAgent_ set network_]
	$nm loopback 1

        # do this for the first time only
	$self instvar have_network_
	if {![info exists have_network_] || $have_network_ == 0} {
		$session_ start_timers
		[$self set sender_] attach $mgr_
		set have_network_ 1
	}

	$mbui_ reset $session_
}

#
# Creates a frame using the provided <i>widgetPath</i> and packs the mediaboard into it.
#
MBApp instproc init_UI { widgetPath } {
        $self instvar mgr_ sender_
	frame $widgetPath
        $self set mbui_ [ new MBUI $widgetPath $mgr_ $sender_ [$self get_option showUI] "$self exit" ]
	pack $widgetPath -expand 1 -fill both
}

# use the common search_font for tcl v8 or greater
if { $tcl_version < 8 } {
	MBApp instproc search_font { foundry style weight points attr} {
		global font tcl_version
		$self instvar name_

		foreach f $font($points) {
                set fname -$foundry-$style-$weight-$attr-$f
			if [havefont $fname] {
				return $fname
			}
		}
		puts stderr "Mb: can't find $weight $fname font (using fixed)"
		if ![havefont fixed] {
			puts stderr "Mb: can't find fixed font"
			exit 1
		}
		return fixed
	}
}

#
MBApp instproc init_fonts {o} {
	new FontInitializer $o

	# override the default fonts
        $o add_option smallfont [$o get_option helv10]
        $o add_option medfont [$o get_option helv12]
        $o add_option helpFont [$o get_option times12]
}

#
# These can be overridden.
#
MBApp instproc init_resources {o} {
        global env
        $self instvar class_

        option add *Radiobutton.relief flat startupFile

        # option add Mb.geometry 700x500 startupFile

	# used by Object
        $o add_default debug 1

	# used by MBApp
        $o add_default playScript none
        $o add_default rtPlay 0
        $o add_default record 0
        $o add_default iconPrefix MediaBoard
        $o add_default showUI 1

        $o add_default trace none

	# default added by MBNet, used by AddressBlock
	$o add_default defaultTTL 31
}

