# rtp-play.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/archive/player/rtp-play.tcl,v 1.24 2002/02/03 04:25:10 lim Exp $


import RTPApplication RTPPlayAgent ArchiveSession/Play

# This class is required so the player can inherit from RTPApplication
# Status: Beta

Class RTPApplication/Player -superclass RTPApplication

RTPApplication/Player instproc init {media} {
	$self next player
	$self add_option sessionType rtpv2
	$self add_option defaultTTL 15
	$self add_option cname Archive
}

# This class implements the player session object for playing back
# RTP sessions.
# Status: Beta
# Author: Angela Schuett

Class ArchiveSession/Play/RTP -superclass ArchiveSession/Play

# Initializes the RTP session and creates the network objects.
# Note: This class currently supports only audio and video sessions.
ArchiveSession/Play/RTP instproc init { media addr} {
	$self next
	#$self instvar loopback_
	$self instvar media_
	$self instvar agent_
	$self instvar stream_num_

	$self instvar vcn_ vdn_
	#set loopback_ 1
	set stream_num_ 0

	$self set media_ $media
	#puts "Pre-agent"
	#$self set agent_ [new RTPPlayAgent $self $addr]
	$self set agent_ [new RTPPlayAgent $self $addr]
	#puts "Agent: $agent_"
}

ArchiveSession/Play/RTP instproc destroy {} {
	$self instvar agent_
	$self instvar stream_list_

	puts "ArchiveSession/Play/RTP destroy"

	foreach stream $stream_list_ {
		delete $stream
	}

	delete $agent_
	$self next
}

#
# Set or query the media associated with this session. Please note that
# the media is automatically set by the init method of this class.
# Programmers should not invoke this method directly to set the
# media.
#
ArchiveSession/Play/RTP instproc media {} {
	$self instvar media_
	return $media_
}

#
# Pure virtual method to attach a newly created stream to the session.
# This allows the programmer to perform initialization of the stream
# object after the call to create_stream and before it is attached
# to the session.
# <p><b>Returns:</b> nothing
#
ArchiveSession/Play/RTP instproc attach_stream { stream } {
	$self instvar vdn_ vcn_
	$self instvar agent_
	$self instvar stream_list_

	set session [$agent_ get_session]

	$stream attach_agent $session
	$stream buffer_pool [$agent_ buffer_pool]

	$stream header_info hdr

	lappend stream_list_ $stream


	if {[string first "(rec)" $hdr(name)] == -1} {
		set hdr(name) "(rec) $hdr(name)" }
	set src [$agent_ mk_local_source $hdr(ssrc) $hdr(cname) $hdr(name) $hdr(email)]


}



#
# Pure virtual method to create a session-specific media-stream object.
# Each subclass of this class must define its own create_stream method.
#
# <p><b>Returns:</b> an object subclassed from ArchiveStream
#
ArchiveSession/Play/RTP instproc create_stream { } {
	return [new ArchiveStream/Play/RTP]
}


ArchiveSession/Play/RTP instproc stream_done { stream } {
}

ArchiveStream/Play public init {} {
	$self next
	$self set offset_ 0.0
}
