# ui-props.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/mbv2/ui-props.tcl,v 1.9 2002/02/03 04:21:59 lim Exp $


import Dialog/SelectFont


Class MBv2Properties

MBv2Properties public init { path } {
	$self next

	$self instvar props_ path_
	set path_ $path
	set props_(color,all) "/custom White Black Red Orange Yellow Green \
			Blue Magenta Violet"
	set props_(fill,all) "/custom /none White Black Red Orange Yellow \
			Green Blue Magenta Violet"

	set props_(justify,all) "{-image MbIcons(left)} \
			{-image MbIcons(center)} {-image MbIcons(right)}"
	set props_(width,all) "1 2 3 4 5 6 7 8 9 10"
	set props_(arrow_type,all) [list "at the end" "beginning" "both ends"\
			"none"]
	set {props_(arrow_type,map,at the end)} last
	set {props_(arrow_type,map,beginning)}  first
	set {props_(arrow_type,map,both ends)}  both
	set {props_(arrow_type,map,none)}       none

	$self build_toolbar $path
}


MBv2Properties public build_toolbar { path } {
	$self instvar props_
	$self tkvar outline_ fill_ justify_ font_ width_ arrow_
	set abg [WidgetClass widget_default -background]
	set o [list [list button.font {Helvetica 8}] \
			[list button.activebackground $abg] ]

	set outline_ Black
	set fill_ /none
	set justify_ {-image MbIcons(left)}
	set font_ {Helvetica -18 bold}
	set width_ 4
	set arrow_ "at the end"
	DropDown/Color $path.color -label {-image MbIcons(color)} -options $o \
			-variable [$self tkvarname outline_]
	TipManager tip $path.color "Outline\ncolor"
	DropDown/Color $path.fill  -label {-image MbIcons(fill)}  -options $o \
			-variable [$self tkvarname fill_]
	TipManager tip $path.fill "Fill\ncolor"
	DropDown $path.justify -label \
			{-text justify -font {Helvetica 8} -anchor n -pady 1} \
			-options $o -variable [$self tkvarname justify_]
	TipManager tip $path.justify "Text\nJustification"
	ImageTextButton $path.font -image MbIcons(font) -text "font" \
			-style textimage \
			-font {Helvetica 8} -highlightthickness 0 -options \
			[list [list image.activebackground $abg] \
			[list text.activebackground $abg]] -orient vertical \
			-command "set [$self tkvarname font_]\
			\[$path.font.dialog invoke $path.font\]"
	TipManager tip $path.font "Text\nfont"
	Dialog/SelectFont $path.font.dialog
	$path.font.dialog size_in_pixels 1 1
	$path.font.dialog configure -font $font_

	DropDown $path.width -label {-image MbIcons(width)} -options $o \
			-variable [$self tkvarname width_]
	TipManager tip $path.width "Line\nthickness"
	DropDown $path.arrow_type -label {-image MbIcons(arrow_type)} \
			-options $o -variable [$self tkvarname arrow_]
	TipManager tip $path.arrow_type "Arrow\ntype"

	foreach elem [list color fill justify width arrow_type] {
		foreach e $props_($elem,all) {
			$path.$elem insert end $e
		}
	}

	pack $path.color $path.fill $path.justify $path.font $path.width \
			$path.arrow_type -side left -padx 1 -fill y
}


MBv2Properties public enable_session { f } {
	$self instvar path_
	if $f { set state normal } else { set state disabled }
	foreach elem [list color fill font width arrow_type] {
		$path_.$elem configure -state $state
	}
}


MBv2Properties public outline { } {
	$self tkvar outline_
	return $outline_
}


MBv2Properties public fill { } {
	$self tkvar fill_
	if { $fill_ == "/none" } { return "none" } else { return $fill_ }
}


MBv2Properties public justify { } {
	$self tkvar justify_
	set j left
	regexp {\(([^\)]*)\)} [lindex $justify_ 1] dummy j
	return $j
}


MBv2Properties public font { } {
	$self tkvar font_
	return $font_
}


MBv2Properties public width { } {
	$self tkvar width_
	return $width_
}


MBv2Properties public arrow { } {
	$self tkvar arrow_
	$self instvar props_
	return $props_(arrow_type,map,$arrow_)
}
