/*
 * mplug-win32.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

//#ifndef lint
//static const char *rcsid = "@(#) $Header: /usr/mash/src/repository/mash/mash-1/mplug/win32/mplug-win32.cc,v 1.6 2002/02/03 04:13:10 lim Exp $";
//#endif



#include "../mplug-compat.h"
#include "mplug-win32.h"


const char *Win32MPlugInstance::instanceLookupString_= "instance->pdata";


#define WSA_VERSION_REQD MAKEWORD(1, 1)
static NPBool needWSACleanup_ = FALSE;

NPError
PluginInstance::Initialize(void)
{
	WSADATA wsaData;
	if (WSAStartup(WSA_VERSION_REQD, &wsaData)!=0) {
		LOG(("WSAStartup failed\n"));
		return NPERR_MODULE_LOAD_FAILED_ERROR;
	}

	needWSACleanup_ =  TRUE;
	return NPERR_NO_ERROR;
}


void
PluginInstance::Shutdown(void)
{
	if (needWSACleanup_==TRUE) {
		WSACleanup();
	}
}


Win32MPlugInstance::Win32MPlugInstance(NPMIMEType mimeType, NPP instance,
				       uint16 mode, int16 argc,
				       const char * const *argn,
				       const char * const *argv)
	: MPlugInstance(mimeType, instance, mode, argc, argn, argv),
	  window_(NULL), childWindow_(NULL), defaultWindowProc_(NULL)
#ifdef NETSCAPE_RESIZE_BUG
	, parentWindow_(NULL), parentWindowProc_(NULL)
#endif
{
}


Win32MPlugInstance::~Win32MPlugInstance()
{
	DeleteWindow();
}


NPError
Win32MPlugInstance::NewWindow(NPWindow *npWindow)
{
	NPError retval;

	LOG(("Win32MPlugInstance::NewWindow invoked\n"));
	LOG(("Initializing new window at (%d, %d): %d x %d\n",
	     npWindow->x, npWindow->y, npWindow->width, npWindow->height));

	window_ = (HWND) npWindow->window;
	defaultWindowProc_ = (WNDPROC)SetWindowLong(window_, GWL_WNDPROC,
						    (LONG)WindowProc_Static);
	SetProp(window_, instanceLookupString_, (HANDLE)this);

#ifdef NETSCAPE_RESIZE_BUG
	if (mode()==NP_FULL) {
		parentWindow_ = GetParent(window_);
		if (parentWindow_) {
			parentWindowProc_ = (WNDPROC)
				SetWindowLong(parentWindow_,
					      GWL_WNDPROC,
					      (LONG)ParentWindowProc_Static);
			SetProp(parentWindow_, instanceLookupString_,
				(HANDLE)this);
		}
	}
#endif

	retval = MPlugInstance::NewWindow(npWindow);
	if (retval!=NPERR_NO_ERROR) {
		LOG(("Win32MPlugInstance::NewWindow returning an error\n"));
		return retval;
	}

	LOG(("UnixMPlugInstance::NewWindow returning successfully\n"));
	return retval;
}


NPError
Win32MPlugInstance::ReconfigureWindow(NPWindow *npWindow)
{
	LOG(("Trying to reconfigure the window to (%d, %d): %d x %d\n",
	     npWindow->x, npWindow->y, npWindow->width, npWindow->height));

	MoveWindow(window_, npWindow->x, npWindow->y, npWindow->width,
		   npWindow->height, TRUE);
	if (MPlugInstance::NotifyReconfigure(npWindow->width,
					     npWindow->height)) {
		return NPERR_NO_ERROR;
	} else {
		return NPERR_GENERIC_ERROR;
	}
}


NPError
Win32MPlugInstance::DeleteWindow()
{
	if (mode()==NP_FULL && parentWindow_!=NULL) {
		SetWindowLong(parentWindow_, GWL_WNDPROC,
			      (LONG)parentWindowProc_);
		parentWindowProc_ = NULL;
		parentWindow_ = (HWND) NULL;
	}

	if (window_!=NULL) {
		SetWindowLong(window_, GWL_WNDPROC, (LONG)defaultWindowProc_);
		defaultWindowProc_ = NULL;
		window_ = (HWND) NULL;
	}
	childWindow_ = (HWND) NULL;
	return NPERR_NO_ERROR;
}


LRESULT CALLBACK Win32MPlugInstance::WindowProc_Static(HWND hWnd, UINT msg,
						       WPARAM wParam,
						       LPARAM lParam)
{
	Win32MPlugInstance* This =
		(Win32MPlugInstance*) GetProp(hWnd, instanceLookupString_);

	return This->WindowProc(msg, wParam, lParam);
}


LRESULT Win32MPlugInstance::WindowProc(UINT msg, WPARAM wParam, LPARAM lParam)
{
	int width, height;

	switch (msg) {
	case TK_ATTACHWINDOW:
		/* The embedded window is trying to attach to us */
		childWindow_ = (HWND) wParam;
		return 0;

	case TK_DETACHWINDOW:
		childWindow_ = (HWND) NULL;
		return 0;

	case TK_GEOMETRYREQ:
		width = wParam;
		height= lParam;
		if (childWindow_!=NULL) {
			LOG(("Reconfiging child to %d x %d\n", width, height));
			SetWindowPos(childWindow_, NULL, 0, 0, width, height,
				     SWP_NOZORDER);
		}
		return 0;

	case WM_ERASEBKGND:
	{
		HBRUSH bg, oldBrush;
		HPEN oldPen;
		RECT rect, childRect;
		HDC  hdc;

		hdc = (HDC) wParam; // handle of device context
		bg = (HBRUSH) GetClassLong(window_, GCL_HBRBACKGROUND);
		oldBrush = (HBRUSH) SelectObject(hdc, bg);
		oldPen = (HPEN) SelectObject(hdc, GetStockObject(NULL_PEN));

		GetClientRect(window_, &rect);
		if (childWindow_) {
			GetClientRect(childWindow_, &childRect);
			if (childRect.right < rect.right+1)
				Rectangle(hdc, childRect.right, rect.top,
					  rect.right+1, rect.bottom+1);
			if (childRect.bottom < rect.bottom+1)
				Rectangle(hdc, rect.left, childRect.bottom,
					  childRect.right+1, rect.bottom+1);
		} else {
			Rectangle(hdc, rect.left, rect.top,
				  rect.right+1, rect.bottom+1);
		}
		SelectObject(hdc, oldPen);
		SelectObject(hdc, oldBrush);
		return 0;
	}
	}

	if (defaultWindowProc_)
		return defaultWindowProc_(window_, msg, wParam, lParam);
	return 0;
}


#ifdef NETSCAPE_RESIZE_BUG
LRESULT CALLBACK Win32MPlugInstance::ParentWindowProc_Static(HWND hWnd,
							     UINT msg,
							     WPARAM wParam,
							     LPARAM lParam)
{
	Win32MPlugInstance* This =
		(Win32MPlugInstance*) GetProp(hWnd, instanceLookupString_);

	return This->ParentWindowProc(msg, wParam, lParam);
}


LRESULT Win32MPlugInstance::ParentWindowProc(UINT msg, WPARAM wParam,
					     LPARAM lParam)
{
	int width, height;

	switch (msg) {
	case WM_SIZE:
		width = LOWORD(lParam);
		height= HIWORD(lParam);
		MoveWindow(window_, 0, 0, width, height, TRUE);
		break;
		// do the default thing, anyway...
	}

	if (parentWindowProc_)
		return parentWindowProc_(parentWindow_, msg, wParam, lParam);
	return 0;
}
#endif
