/*
 * compat.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

//#ifndef lint
//static const char *rcsid = "@(#) $Header: /usr/mash/src/repository/mash/mash-1/mplug/unix/compat.cc,v 1.9 2002/02/03 04:12:52 lim Exp $";
//#endif


#include "../mplug-compat.h"
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <errno.h>
#include "../rpi.h"


// a simple function to join a directory with a suffix
// this is platform-specific because UNIX and Windows have different
// separators for directory names ('/' and '\' respectively)
char *
MPlug_JoinFilename(const char *dir, const char *suffix)
{
	if (dir==NULL) dir = "";
	int dirlen = strlen(dir);
	while (dirlen > 0 && dir[dirlen-1]=='/') {
		// strip trailing slashes
		dirlen--;
	}

	char *filename = new char [dirlen + strlen(suffix) + 2];
	strncpy(filename, dir, dirlen);
	sprintf(filename + dirlen, "/%s", suffix);

	return filename;
}


// platform-specific version of gettimeofday
void
MPlug_GetCurrentTime(struct timeval *tp)
{
	gettimeofday(tp, NULL);
}


void
MPlug_Output(const char *format, ...)
{
	va_list ap;
	va_start(ap, format);
	vfprintf(stderr, format, ap);
	va_end(ap);
}


void
MPlug_Log(const char *format, ...)
{
	static FILE *fp=NULL;
	if (fp==NULL) {
		fp = fopen("/tmp/mplug.log", "w");
	}
	va_list ap;
	va_start(ap, format);
	vfprintf(fp, format, ap);
	fflush(fp);
	va_end(ap);
}



NPBool
RPI::Fork(RPI::ArgArray *args, const char *stdoutFilename,
	  const char *stderrFilename)
{
	int pid;
	if ((pid = fork())) {
		// parent process
		// wait for the fake child to exit
		waitpid(pid, NULL, 0);
		return TRUE;
	} else {
		// child process; fork again, to prevent zombies
		if (fork()) {
			exit(0);
		} else {
			// real child
			// redirect output if necessary
			int stdoutFD=-1, stderrFD=-1;
			if (stdoutFilename!=NULL && *stdoutFilename!='\0') {
				stdoutFD = creat(stdoutFilename, 0644);
				if (stdoutFD!=-1) {
					dup2(stdoutFD,1); // redirect stdout
				}
			}
			if (stderrFilename!=NULL && *stderrFilename!='\0') {
				if (strcmp(stdoutFilename,stderrFilename)==0) {
					stderrFD = stdoutFD;
				} else {
					stderrFD = creat(stderrFilename, 0644);
				}

				if (stderrFD!=-1) {
					dup2(stderrFD,2); // redirect stderr
				}
			}
			if (stdoutFD!=-1) close(stdoutFD);
			if (stderrFD!=-1 && stderrFD!=stdoutFD)
				close(stderrFD);

			// exec the plugin process

			char *const *argv = args->argv();
			execvp(argv[0],  argv);
			MPlug_Output("Could not create plugin process (%s): "
				     "%s\n", argv[0], strerror(errno));
			exit(-1);
		}
	}

	return TRUE;
}
