/*
 * mbv2-listsort.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/mbv2/mbv2-listsort.h,v 1.4 2002/02/03 03:17:08 lim Exp $
 */

#ifndef MASH_MBV2_LISTSORT_H
#define MASH_MBV2_LISTSORT_H


template <class T>
void
insert_sorted(List<T> *list, T *d)
{
	// add in increasing order of waitingForCmd
	if (list->IsEmpty()) {
		// add at the head of the list
		list->InsertAtHead(d);
	} else if (list->PeekAtTail()->compare(*d) <= 0) {
		// add at the tail of the list
		list->InsertAtTail(d);
	}
	else {
		// insert somewhere in the middle of the list
		ListIndex idx;
		for (idx=list->getFirst();
		     !list->IsDone(idx);
		     idx=list->getNext(idx))
		{
			if (list->getData(idx)->compare(*d) >= 0) {
				list->InsertBefore(idx, d);
				break;
			}
		}
	}
}


#endif /* #ifdef MASH_MBV2_LISTSORT_H */
