/*
 * mb-string.h --
 *
 *      Housing conversions to and from strings etc.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/mb/mb-string.h,v 1.5 2002/02/03 03:16:30 lim Exp $
 */

#ifndef MB_STRING_H
#define MB_STRING_H

#include "mb.h"
#include  <misc/str.h>

inline Bool Str2Coord(const char* szDouble, Coord& result) {
    return str2double(szDouble,result);
}

//
// allocates aPoints and write coords into it
//   updates count
//
Bool Str2Points(const char *szPoints, Point* &aPoints, int& count);

// changes a coord to string
// note: does not allocate memory, sz must point to
//       a character array of at least TCL_DOUBLE_SPACE
inline void Coord2Str(const Coord& coord, char* sz) {
    Tcl_PrintDouble(MB_Interp, coord, sz);
}

//
// allocates and return the string representation of the points
//
char* Points2Str(const Point* aPoints, const int count);

#endif /* #ifdef MB_STRING_H */
