/*
 * mb-string.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MB_STRING_CC
#define MB_STRING_CC

#include "mb.h"

#ifndef lint
static const char rcsid[] = "$Header: /usr/mash/src/repository/mash/mash-1/mb/mb-string.cc,v 1.8 2002/02/03 03:16:30 lim Exp $";
#endif

#include "mb-string.h"

Bool Str2Points(const char *szPoints, Point* &aPoints, int& count)
{
    int argc;
    char **argv;
    aPoints=NULL;
    count=0;
    Tcl_SplitList(MB_Interp, (char*)szPoints, &argc, (char***)&argv);
    if (argc%2!=0) {
        assert(FALSE && "Coords should always be in pairs!");
        return FALSE;
    }
    int nPoints= argc/2;
    aPoints = new Point[nPoints];
    Point* pPoint = aPoints;
    char** ppsz=argv;
    for (; ppsz<argv+argc; ppsz+=2) {
        if (!Str2Coord(*ppsz,pPoint->x))
            goto Err;
        if (!Str2Coord(*(ppsz+1),pPoint->y))
            goto Err;
        pPoint++;
    }
    assert(ppsz == argv+argc); // we did not convert extra coords
    assert(pPoint == aPoints+nPoints); // we did not

    count=nPoints;
    Tcl_Free((char*)argv);
    return TRUE;

 Err:
    delete[] aPoints;
    aPoints=NULL;
    count=0;
    Tcl_Free((char*)argv);
    return FALSE;
}

#if TCL_MAJOR_VERSION < 8
#error "you need tcl 8.0 to compile with this module"
#endif

//
// allocates and return the string representation of the points
//
char* Points2Str(const Point* aPoints, const int count)
{
	Tcl_Obj** objv = new Tcl_Obj*[count*2];
	const Point* pPoint = aPoints;
	Tcl_Obj** pObj;
	for (pObj = objv; pObj < objv + 2*count; ) {
		*pObj = Tcl_NewDoubleObj(pPoint->x);
		Tcl_IncrRefCount(*pObj);
		pObj++;
		*pObj = Tcl_NewDoubleObj(pPoint->y);
		Tcl_IncrRefCount(*pObj);
		pObj++;
		pPoint++;
	}
	Tcl_Obj* pListObj = Tcl_NewListObj(count*2, objv);
	Tcl_IncrRefCount(pListObj);
	int len;
	char* pszPoints = Tcl_GetStringFromObj(pListObj, &len);
	char* pResult;
	::AllocNCopy(&pResult, pszPoints);
	Tcl_DecrRefCount(pListObj);
	for (pObj=objv; pObj < objv + 2*count; pObj++) {
		Tcl_DecrRefCount(*pObj);
	}
	delete[] objv;
	return pResult;
}

#if 0
    char** argv= new char*[count*2];
    char* bigstr = new char[TCL_DOUBLE_SPACE*count*2];
    const Point* pPoint=aPoints;
    char** pSz=argv;
    for (; pSz<argv+(count*2); pSz+=2) {
        Coord2Str(pPoint->x, *pSz);
        Coord2Str(pPoint->y, *(pSz+1));
        pPoint++;
    }
    assert(pPoint==pPoint+count && "Converted extra points");
    assert(pSz==argv+(count*2) && "pSz went too far");

    char *pPoints=Tcl_Merge(count*2,argv);

    // to simplify things, return a copy that can be deleted
    // using delete (instead of Tcl_Free)
    char *pResult=NULL;
    ::AllocNCopy(&pResult,pPoints);
    delete[] argv;
    return pResult;
#endif

#endif /* #ifdef MB_STRING_CC */
