/*
 * filter.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * (FIXME from ivs)
 * This implementation is different from the Stanford one;
 * I think the rounding is different; so the *.p64 files look funny.
 * FIXME can make this go faster by accessing memory more efficiently.
 */

void P64Decoder::addblkf(short* blk, u_char* in, u_char* out, int stride)
{
	if (((int)in & 3) != 0) {
		addblkf_slow(blk, in, out, stride);
		return;
	}
	register u_int in0, in3;
	register u_int in1, in4;
	register u_int in2, in5;

	in1 = *(u_int*)in;
	in4 = *(u_int*)(in + 4);
	in += stride;
	in2 = *(u_int*)in;
	in5 = *(u_int*)(in +  4);

	/* first row */
	*(u_int*)out = in1;
	*(u_int*)(out + 4) = in4;

	for (int k = 6; --k >= 0; ) {
		register int t;

		out += stride;
		in += stride;
		in0 = in1;
		in1 = in2;
		in2 = *(u_int*)in;
		in3 = in4;
		in4 = in5;
		in5 = *(u_int*)(in + 4);

		/* col 1 */
		u_int w = in1 >> 24;
		u_int v = w << 24;		/* col 0 */
		w += ((in1 >> 15) & 0x1fe);
		w += (in1 >> 8) & 0xff;
#ifdef notdef
		w >>= 2;/*FIXME ivs does this*/
		w <<= 2;
#endif
		w += (in0 >> 16) & 0xff;
		w += ((in1 >> 15) & 0x1fe);
		w += (in2 >> 16) & 0xff;
		v |= (UCLIMIT(blk[1] + (w >> 2)) & 0xff) << 16;

		/* col 2 */
		w = (in1 >> 16) & 0xff;
		w += ((in1 >> 7) & 0x1fe);
		w += in1 & 0xff;
#ifdef notdef
		w >>= 2;/*FIXME ivs does this*/
		w <<= 2;
#endif
		w += (in0 >> 8) & 0xff;
		w += ((in1 >> 7) & 0x1fe);
		w += (in2 >> 8) & 0xff;
		v |= (UCLIMIT(blk[2] + (w >> 2)) & 0xff) << 8;

		/* col 3 */
		w = (in1 >> 8) & 0xff;
		w += (in1 & 0xff) << 1;
		w += in4 >> 24;
#ifdef notdef
		w >>= 2;/*FIXME ivs does this*/
		w <<= 2;
#endif
		w += in0 & 0xff;
		w += (in1 & 0xff) << 1;
		w += in2 & 0xff;
		v |= UCLIMIT(blk[3] + (w >> 2)) & 0xff;

		*(u_int*)out = v;

		/* col 4 */
		w = in1 & 0xff;
		w += (in4 >> 23) & 0x1fe;
		w += (in4 >> 16) & 0xff;
#ifdef notdef
		w >>= 2;/*FIXME ivs does this*/
		w <<= 2;
#endif
		w += in3 >> 24;
		w += (in4 >> 23) & 0x1fe;
		w += in5 >> 24;
		v = (UCLIMIT(blk[4] + w) & 0xff) << 24;

		/* col 5 */
		w = in4 >> 24;
		w += (in4 >> 15) & 0x1fe;
		w += (in4 >> 8) & 0xff;
#ifdef notdef
		w >>= 2;/*FIXME ivs does this*/
		w <<= 2;
#endif
		w += in3 >> 16;
		w += (in4 >> 15) & 0x1fe;
		w += in5 >> 16;
		v |= (UCLIMIT(blk[5] + w) & 0xff) << 16;

		/* col 6 */
		w = (in4 >> 16) & 0xff;
		w += (in4 >> 7) & 0x1fe;
		w += in4 & 0xff;
#ifdef notdef
		w >>= 2;/*FIXME ivs does this*/
		w <<= 2;
#endif
		w += in3 >> 8;
		w += (in4 >> 7) & 0x1fe;
		w += in5 >> 8;
		v |= (UCLIMIT(blk[6] + w) & 0xff) << 8;

		/* col 6 */
		v |= in4 & 0xff;

		*(u_int*)(out + 4) = v;
	}
	/* last row */
	out += stride;
	*(u_int*)out = *(u_int*)in;
	*(u_int*)(out + 4) = *(u_int*)(in + 4);
}
