# vcc3-ccu.tcl --
#
#       Code for handling CCU notifications and responses for vcc3d.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

proc vcc3_processCCUNotification {pktList} {
    array set pkt $pktList

    puts stdout "vcc3_processCCUNotification: called"
    vcc3_printPacket $pktList

 #     set type [expr $pkt(commandID) & 0x1F]
#      if {$type == 0x18} {
#  	puts stdout "vcc3_processPanTilterNotification: remote control"
#  	set operation $pkt(parameter,0)
#  	set code $pkt(parameter,1)
#  	puts stdout "\toperation = $operation"
#  	puts stdout "\tcode = $code"
#  	vcc3_pt_handleRemoteButton $operation $code
#      }
}

proc vcc3_processCCUPositiveResponse {pktList} {
    global g_sync
    
    array set pkt $pktList

    set type [expr $pkt(commandID) & 0x1F]
    if {$type == 0x4} {
  	# status response
  	vcc3_ccu_handleStatusResponse $pktList
    }
    if {$type == 0x11} {
  	# fade response
  	vcc3_ccu_handleFadeResponse $pktList
    }
    if {$type == 0x18} {
	# preset response
	vcc3_ccu_handlePresetResponse $pktList
    }
}

proc vcc3_ccu_handleStatusResponse {pktList} {
    global g_sync g_fadeSpeed g_fadeGain g_fadeLevel
    array set pkt $pktList

    set type $pkt(parameter,0)
    if {$type == 0x2} {
    	# fade
	set g_sync(fadeSpeed) "NO_WAIT"
	set speedHi $pkt(parameter,1)
	set speedLo $pkt(parameter,2)
	set speedHi [expr $speedHi << 8]
	set g_fadeSpeed [expr $speedHi + $speedLo]
	set g_fadeGain $pkt(parameter,3)
	set g_fadeLevel $pkt(parameter,4)
    	set g_sync(readFadeStatus) "NO_WAIT"
    }
}

proc vcc3_ccu_handleFadeResponse {pktList} {
    global g_sync g_fadeSpeed g_fadeGain g_fadeLevel
    array set pkt $pktList

    set type $pkt(parameter,0)
    if {$type == 0x2} {
	# fade in/out done
	set g_sync(fadeInOut) "NO_WAIT"
    }
    if {$type == 0x4} {
	# fade speed
	set g_sync(fadeSpeed) "NO_WAIT"
	if {$pkt(parameter,1) == 0x1} {
	    # read the fade speed
	    set speedHi $pkt(parameter,2)
	    set speedLo $pkt(parameter,3)
	    set speedHi [expr $speedHi << 8]
	    set g_fadeSpeed [expr $speedHi + $speedLo]
	}
    }
}

proc vcc3_ccu_handlePresetResponse {pktList} {
    global g_sync
    global g_presets
    array set pkt $pktList

    set type $pkt(parameter,0)
    if {$type == 0x1} {
 	# preset position
	set num $pkt(parameter,1)

	set g_presets($num,aeRef) $pkt(parameter,3)
	
	set hi $pkt(parameter,4)
	set lo $pkt(parameter,5)
	set hi [expr $hi << 8]
	set temp [expr $hi + $lo]
	set temp [expr 0x8000 - $temp]
	set g_presets($num,panPosition) $temp
	
	set hi $pkt(parameter,6)
	set lo $pkt(parameter,7)
	set hi [expr $hi << 8]
	set temp [expr $hi + $lo]
	set temp [expr $temp - 0x8000]
	set g_presets($num,tiltPosition) $temp
	
	set hi $pkt(parameter,8)
	set lo $pkt(parameter,9)
	set hi [expr $hi << 8]
	set temp [expr $hi + $lo]
	set g_presets($num,zoomPosition) $temp

	set g_sync(readPreset) "NO_WAIT"
    }

#      if {$type == 0x3} {
#  	# pan/tilt speed
#  	if {$pkt(parameter,1) == 0x1} {
#  	    # read
#  	    set g_panSpeed $pkt(parameter,2)
#  	    set g_tiltSpeed $pkt(parameter,3)
#  	    set g_sync(readPanTiltSpeed) "NO_WAIT"
#  	}
#      }
    
#      if {$type == 0x4} {
#  	# relative pan/tilt position
#  	if {$pkt(parameter,1) == 0x2} {
#  	    set g_sync(relativeMove) "NO_WAIT"
#  	}
#  	if {$pkt(parameter,1) == 0x1} {
#  	    # read
#  	    set panHi $pkt(parameter,2)
#  	    set panLo $pkt(parameter,3)
#  	    set tiltHi $pkt(parameter,4)
#  	    set tiltLo $pkt(parameter,5)

#  	    set panHi [expr $panHi << 8]
#  	    set tiltHi [expr $tiltHi << 8]
#  	    set g_panPosition [expr $panHi + $panLo]
#  	    set g_tiltPosition [expr $tiltHi + $tiltLo]
#  	    set g_panPosition [expr 0x8000 - $g_panPosition]
#  	    set g_tiltPosition [expr $g_tiltPosition - 0x8000]
	    
#  	    puts stdout "relative: panHi=$panHi, panLo=$panLo"
#  	    puts stdout "relative: tiltHi=$tiltHi, tiltLo=$tiltLo"
#  	    puts stdout "relative: g_panPos=$g_panPosition, g_tiltPosition=$g_tiltPosition"
#  	    set g_sync(readPanTiltPosition) "NO_WAIT"
#  	}
#      }
#      if {$type == 0x5} {
#  	# absolute pan/tilt position
#  	if {$pkt(parameter,1) == 0x2} {
#  	    set g_sync(absoluteMove) "NO_WAIT"
#  	}
#  	if {$pkt(parameter,1) == 0x1} {
#  	    # read
#  	    set panHi $pkt(parameter,2)
#  	    set panLo $pkt(parameter,3)
#  	    set tiltHi $pkt(parameter,4)
#  	    set tiltLo $pkt(parameter,5)

#  	    set panHi [expr $panHi << 8]
#  	    set tiltHi [expr $tiltHi << 8]
#  	    set g_panPosition [expr $panHi + $panLo]
#  	    set g_tiltPosition [expr $tiltHi + $tiltLo]
#  	    set g_panPosition [expr 0x8000 - $g_panPosition]
#  	    set g_tiltPosition [expr $g_tiltPosition - 0x8000]

#  	    set g_sync(readPanTiltPosition) "NO_WAIT"
#  	}
#      }
}
