#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <unistd.h>

#include "flashlogo.h"

int flashsize(void)
{
	int fd = 0;
	int size = 0;

	fd = open("/dev/nwflash", O_RDONLY);

	if (fd <= 0)
		return FLASH_EACCES;

	if (lseek(fd, 4 * 1024 * 1024, SEEK_SET) > 0)
		size = 4 * 1024 * 1024;
	else if (lseek(fd, 1024 * 1024, SEEK_SET) > 0)
		size = 1024 * 1024;
	else
		size = FLASH_EBADSIZE;

	close(fd);

	return size;
}

int flashread(char *buffer, int offset, int size)
{
	int fd = 0;
	int ret;

	fd = open("/dev/nwflash", O_RDONLY);

	if (fd <= 0)
		return FLASH_EACCES;

	if (lseek(fd, offset, SEEK_SET) < 0)
		return FLASH_EBADOFF;

	ret = read(fd, buffer, size);

	close(fd);

	return ret;
}

int flashwrite(char *buffer, int offset, int size)
{
	int fd = 0;
	int ret;

	fd = open("/dev/nwflash", O_RDWR);

	if (fd <= 0)
		return FLASH_EACCES;

	if (lseek(fd, offset, SEEK_SET) < 0)
		return FLASH_EBADOFF;

	ioctl(fd, CMD_WRITE_ENABLE);
	ret = write(fd, buffer, size);
	ioctl(fd, CMD_WRITE_DISABLE);

	close(fd);

	return ret;
}
