/*
 *
 *  newvictron.c - Model specific routines for IMV/Victron  units
 *  Match, Match Lite, NetUps
 *  Revision 0.1.1
 *           
 * Copyright (C) 1999  Russell Kroll <rkroll@exploits.org>
 * Copyright (C) 2000  Radek Benedikt <benedikt@lphard.cz>
 * old style "victronups"
 * Copyright (C) 2001  Daniel.Prynych <Daniel.Prynych@hornet.cz>
 * porting to now style "newvictron"
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *                                       
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *                                       
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 */

#include "main.h"

#define ENDCHAR	'\r'
#define IGNCHARS	""

#define UPS_DELAY 150000
#define UPS_LONG_DELAY 450000

#define VICTRON_OVER 128
#define VICTRON_RB 1
#define VICTRON_OB 2
#define VICTRON_LB 4

int  sdwdelay = 0;  /* shutdown after 0 second */

extern  int     sddelay; /* doba po kterou ceka driver po vypnuti ups */
extern  char    upssend_endchar;
extern  int     upsc_debug;
char *model_name;

 
void upsdrv_initinfo(void)
{

   
   addinfo(INFO_MFR, "Victron", 0, 0);
    if (! model_name) 
       addinfo(INFO_MODEL, "", 0, 0);
    else
       addinfo(INFO_MODEL, model_name, 0, 0); 
    addinfo(INFO_STATUS, "", 0, 0);
    addinfo(INFO_UTILITY, "", 0, 0);
    addinfo(INFO_LOADPCT, "", 0, 0);
    addinfo(INFO_UPSTEMP, "", 0, 0);
    addinfo(INFO_BATTPCT, "", 0, 0);
    addinfo(INFO_LOWXFER, "187", 0, 0);
    addinfo(INFO_HIGHXFER, "264", 0, 0);
    addinfo(INFO_ACFREQ, "", 0, 0);
    addinfo(INFO_BATTVOLT, "", 0, 0);
    addinfo(INFO_OUTVOLT, "", 0, 0);
    addinfo(INFO_CURRENT, "", 0, 0);
    addinfo(INFO_RUNTIME, "", 0, 0);

    addinfo(INFO_BATT_TEMP, "", 0, 0);
    addinfo(INFO_BATT_CURRENT, "", 0, 0);
    
	/* upsh.instcmd = instcmd; */
}

void upsdrv_updateinfo(void)
{
	 int flags; 
	 char temp[256]; 

	/* status */ 
   upssend ("vAa?");
   usleep (UPS_DELAY);
   upsrecv (temp, sizeof(temp), ENDCHAR, IGNCHARS);
   flags = atoi (temp+3);
                                              
   setinfo (INFO_STATUS, "%s%s%s%s", 
           (!(flags & VICTRON_OVER)) ? "" : "OVER ", /* overload ->128 */ 
           (!(flags & VICTRON_RB)) ? "" : "RB ", /* replace battery ->1*/ 
           (!(flags & VICTRON_LB)) ? "" : "LB ", /* low battery ->4*/
           (flags & VICTRON_OB) ? "OB" : "OL"); /* on battery ->2 : on line */ 


   upsdebugx(1, "INFO_STATUS >%s<>%s<",temp,temp+3);   
   
   /* input voltage */
   upssend ("vI0U?");
   usleep (UPS_DELAY);
   upsrecv (temp, sizeof(temp), ENDCHAR, IGNCHARS);
   setinfo(INFO_UTILITY, "%s", temp+4);
   upsdebugx(1, "INFO_UTILITY >%s<>%s<",temp,temp+4);   

                                                                               
   /* ups load percent */
   upssend ("vO0L?");
   usleep (UPS_DELAY);
   upsrecv (temp, sizeof(temp), ENDCHAR, IGNCHARS);
   setinfo(INFO_LOADPCT, "%s", temp+4);
   upsdebugx(1, "INFO_LOADPCT >%s<>%s<\n",temp,temp+4);   
                                                                                                                                                          
   /* ups temp */
   upssend ("vBT?");
   usleep (UPS_DELAY);
   upsrecv (temp, sizeof(temp), ENDCHAR, IGNCHARS);
   setinfo(INFO_UPSTEMP, "%s", temp+3);
   upsdebugx(1, "INFO_UPSTEMP >%s<>%s<\n",temp,temp+3);   

   /* battery charge */
   upssend ("vBC?");
   usleep (UPS_DELAY);
   upsrecv (temp, sizeof(temp), ENDCHAR, IGNCHARS);
   setinfo(INFO_BATTPCT, "%s", temp+3);
   upsdebugx(1, "INFO_BATTPCT >%s<>%s<\n",temp,temp+3);   
                                                                    
   /* input freq */
   upssend ("vI0f?");
   usleep (UPS_DELAY);
   upsrecv (temp, sizeof(temp), ENDCHAR, IGNCHARS);
   setinfo(INFO_ACFREQ, "%2.1f", atof(temp+4) / 10.0);
   upsdebugx(1, "INFO_ACFREQ >%s<>%s<\n",temp,temp+4);   
                                                                                                                                            
   /* battery voltage */
   upssend ("vBU?");
   usleep (UPS_DELAY);
   upsrecv (temp, sizeof(temp), ENDCHAR, IGNCHARS);
   setinfo(INFO_BATTVOLT, "%2.1f", atof(temp+3) / 10.0);
   upsdebugx(1, "INFO_BATTVOLT >%s<>%s<\n",temp,temp+3);   
                                                                                                                                                                                                         
   /* output voltage */
   upssend ("vO0U?");
   usleep (UPS_DELAY);
   upsrecv (temp, sizeof(temp), ENDCHAR, IGNCHARS);
   setinfo(INFO_OUTVOLT, "%s", temp+4);
   upsdebugx(1, "INFO_OUTVOLT >%s<>%s<\n",temp,temp+4);   

   /* output current */
   upssend ("vO0I?");
   usleep (UPS_DELAY);
   upsrecv (temp, sizeof(temp), ENDCHAR, IGNCHARS);
   setinfo(INFO_CURRENT, "%2.1f", atof(temp+4) / 10.0);
   upsdebugx(1, "INFO_CURRENT >%s<>%s<\n",temp,temp+4);   
        
   /* predicted runtime on batt */
   upssend ("vBt?");
   usleep (UPS_DELAY);
   upsrecv (temp, sizeof(temp), ENDCHAR, IGNCHARS);
   setinfo(INFO_RUNTIME, "%s", temp+3);
   upsdebugx(1, "INFO_RUNTIME >%s<>%s<\n",temp,temp+3);   


   /* battery temperature */
   upssend ("vBT?");
   usleep (UPS_DELAY);
   upsrecv (temp, sizeof(temp), ENDCHAR, IGNCHARS);
   setinfo(INFO_BATT_TEMP, "%s", temp+3);
   upsdebugx(1, "INFO_BATT_TEMP >%s<>%s<\n",temp,temp+3);   


   /* battery current */
   upssend ("vBI?");
   usleep (UPS_DELAY);
   upsrecv (temp, sizeof(temp), ENDCHAR, IGNCHARS);
   setinfo(INFO_BATT_CURRENT, "%2.1f", atof(temp+4) / 10.0);
   upsdebugx(1, "INFO_BATT_CURRENT >%s<>%s<\n",temp,temp+4);   

   
	writeinfo();
}

void upsdrv_shutdown(void)
{
    upssend ("vCc0!");
    usleep (UPS_DELAY);
                 
    upssend ("vCb%i!",sdwdelay);
}


void instcmd (int auxcmd, int dlen, char *data)
{
	/* TODO: reply to upsd? */

	switch (auxcmd) {
		/* case CMD_BTEST0:	* stop battery test *
		 *	upssend("???");
		 *	break;
		 * case CMD_BTEST1:	* start battery test *
		 *	upssend("???");
		 *	break;
		 */
		default:
			upslogx(LOG_INFO, "instcmd: unknown type 0x%04x", auxcmd);
	}
}


void upsdrv_help(void)
{
}

/* list flags and values that you want to receive via -x */
void upsdrv_makevartable(void)
{
   addvar(VAR_VALUE, "usd", "Seting delay before shutdown");
   addvar(VAR_VALUE, "modelname", "Seting model name"); 
}

void upsdrv_banner(void)
{
	printf("Network UPS Tools - New Victron UPS driver 0.1.1 (%s)\n\n", UPS_VERSION);
}

void upsdrv_initups(void)
{
   char temp[256], *usd = NULL;  /* = NULL je dulezite jen pro prekladac */


   upssend_endchar=ENDCHAR;
   if (nut_debug_level > 1) upsc_debug = nut_debug_level - 1; /* docasne reseni */
   
   upssend_delay = 0; /* zpozdeni mezi odeslanim jednotlivych znaku bude 0 sec */ 
	  open_serial(device_path, B1200); 

    /* vyzkousime novy typ otevreni serioveho port
     * ze souboru upscommon.c */
    
    if ((usd = getval("usd"))) sdwdelay=atoi(usd);
       
    model_name = getval("modelname"); /* kdyz modelname nebylo zadano je vraceno NULL*/ 

    upsdebugx(1, "(-x) Delay before shutdown %i",sdwdelay);
    upsdebugx(1, "(-x) UPS Name %s",model_name);
    
   /* inicializace a synchronizace UPS */

   upssendchar (ENDCHAR);
   usleep (UPS_LONG_DELAY);
   upssend ("?");
   usleep (UPS_LONG_DELAY);
   upsrecv (temp, sizeof(temp), ENDCHAR, IGNCHARS);
   upssend ("?");
   usleep (UPS_LONG_DELAY);
   upsrecv (temp, sizeof(temp), ENDCHAR, IGNCHARS);
   upssend ("?");
   usleep (UPS_DELAY);
   upsrecv (temp, sizeof(temp), ENDCHAR, IGNCHARS);

    
	/* the upsh handlers can't be done here, as they get initialized
	 * shortly after upsdrv_initups returns to main.
	 */
}

/* tell main how many items you need */
int upsdrv_infomax(void)
{
	/* every addinfo() consumes an entry.  plan ahead, but don't go
	 * overboard, since this is an easy way to waste memory.
	 */

	return 32;
}
