/*
 * newpowercom.h - defines for the newpowercom.c driver
 *
 * Read docs/powercom.txt for other models and manufactures
 *
 * $Id: - will be filled in on next CVS add/update $
 *
 * Copyrights:
 * (C) 2001 Peter Bieringer <pb@bieringer.de>
 *  Porting old style "powercom" to new style "newpowercom", cleanup header file
 *
 * (C) 2000  Shaul Karl <shaulk@israsrv.net.il>
 *  Creating old style "powercom"
 *   Heavily based on
 *    ups-trust425+625.c - model specific routines for Trust UPS 425/625
 *    Copyright (C) 1999  Peter Bieringer <pb@bieringer.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Changes
 * 20011208/PB: add support for subtypes
 */

/* C-libary includes */
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/termios.h>
#include <limits.h>

/* nut includes */
#include "timehead.h"
#include "shared-tables.h"

/* powercom defines */
enum general {
       	SEC_FOR_POWERKILL     = 10U,
	NUM_OF_BYTES_FROM_UPS_SUBTYPE_Trust = 11U,
	NUM_OF_BYTES_FROM_UPS_SUBTYPE_KP625AP = 16U,
	NUM_OF_BYTES_FROM_UPS_MAX = 16U,
	NUM_OF_SUBTYPES = 2
};

/* values for sending to UPS */
enum commands {
	SEND_DATA    = 0x01U,
       	BATTERY_TEST = 0x03U,
       	SHUTDOWN     = 0xbcU
};

/* location of data in received string */
enum data {
	LOAD_LEVEL  = 0U,
       	BAT_LEVEL   = 1U,
       	IN_AC_VOLT  = 2U,
       	OUT_AC_VOLT = 3U,
	IN_AC_FREQ  = 4U
};

/* status bits */
enum status {
	SUMMARY       = 0U,
       	MAINS_FAILURE = 1U,
       	LOW_BAT       = 2U, 
	BAD_BAT       = 2U,
       	TEST          = 4U,
	AVR_ON        = 8U,
       	OVERLOAD      = 32U,
       	OFF           = 128U,
	STATUS_A      = 9U,
	STATUS_B      = 10U
};

/* supported subtypes */
char* subtypes_name[NUM_OF_SUBTYPES] = { "Trust", "KP625AP" };

/* information array about subtypes */
unsigned int subtypes_num_of_bytes[NUM_OF_SUBTYPES] = { NUM_OF_BYTES_FROM_UPS_SUBTYPE_Trust, NUM_OF_BYTES_FROM_UPS_SUBTYPE_KP625AP };
