/*
 ** Copyright 2004-2007 - INL
 ** Written by Eric Leblond <eric.leblond@inl.fr>
 **            Vincent Deffontaines <vincent@inl.fr>
 ** INL http://www.inl.fr/
 **
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, version 2 of the License.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __PREFERENCES__
#define __PREFERENCES__

#include <QtGui>

#include "editbox.h"


class NuAppPreferences : public QDialog {
	Q_OBJECT

	QSettings settings;
	NuEditBox *hostname;
	NuEditBox *port;

	QLabel *current_key;
	QPushButton *key_open;
	QLabel *current_cert;
	QPushButton *cert_open;
	QLabel *current_ca;
	QPushButton *ca_open;

	QCheckBox *use_certs;
public:
	NuAppPreferences ();

public slots:
	void save_preferences();
	void show();

	void switch_use_certs(int state);
	void popup_open_key();
	void popup_open_cert();
	void popup_open_ca();

private:
	void load_preferences();
	void createDialog();
	void setCertificateButtons();
};

#endif /* __PREFERENCES__ */
