/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <signal.h>
#include <gtk/gtk.h>

#include <interface.h>
#include <support.h>

#include <nd.h>
#include <nd_globals.h>
#include <nd_main.h>
#include <nd_misc.h>
#include <nd_tcb.h>
#include <nd_plugin.h>
#include <nd_prefs.h>
#include <nd_recent.h>
#include <nd_timestamp.h>
#include <nd_tcpdump.h>
#include <nd_macros.h>

GtkWidget  *toplevel;
GtkWidget **notbook_protocol_pages;
int         num_notebook_pages;
char       *filename = NULL;

static void
main_help_exit(char *progname)
{
  printf(_("Netdude -- The Network DUmp data Displayer and Editor.\n"
	   "USAGE: %s [OPTIONS] [tracefile]\n"
	   "\n"
	   "  --plugin-dir \t\t\t Show directory where plugins are installed\n"
	   "\n"),
	 progname);
  exit(0);
}


static void
main_read_options(int argc, char** argv)
{
  int i;

  for (i = 1; i < argc; i++)
    {
      if (!strcmp(argv[i], "-h") || !strcmp(argv[i], "--help"))
	main_help_exit(argv[0]);
      else if (!strcmp(argv[i], "--plugin-dir"))
	{
	  printf("%s/plugins\n", PACKAGE_DATA_DIR);
	  exit(0);
	}
      else
	filename = argv[i];
    }
}

static gint
main_startup_idle_handler(gpointer data)
{
  gint tcpdump_init_state = GPOINTER_TO_INT(data);

  if (tcpdump_init_state == FALSE)
    {
      char message[MAXPATHLEN];

      snprintf(message, MAXPATHLEN,
	       _("Cannot find a tcpdump executable as\n"
		 "specified in the preference settings.\n"
		 "Please specify the full path to your\n"
		 "tcpdump instance in the preferences dialog."));
      
      nd_tcpdump_show_error_dialog(message);
      return (0);
    }
  
  if (filename)
    nd_trace_load(filename);
  
  return (0);
  data = NULL;
}


void
nd_main_safe_exit(void)
{
  if (trace.dirty)
    {
      GtkWidget *w;

      w = create_exit_dialog();
      gtk_widget_show(w);
    }
  else
    {
      nd_prefs_save_general();
      exit(0);
    }
}


void
nd_main_unsafe_exit(void)
{
  nd_prefs_save_general();
  exit(0);
}


int
main (int argc, char *argv[])
{
  int show_splash = TRUE;
  gint tcpdump_init_state;

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
  add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");


  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  toplevel = create_toplevel();
  

  /*
   * Init stuff here ...
   */
  signal(SIGPIPE, SIG_IGN);

  main_read_options(argc, argv);

  nd_prefs_init();
  nd_recent_init();
  nd_trace_init();
  tcpdump_init_state = nd_tcpdump_init();
  nd_tcb_init();
  nd_misc_widget_init();
  nd_plugin_init();
  nd_misc_statusbar_set(WELCOMESTRING);

  gtk_widget_show (toplevel);

  nd_prefs_get_item("show_splash", &show_splash);
  
  if (show_splash)
    {
      GtkWidget *splash, *w;
      splash = create_splash_window();
      
      if ((w = gtk_object_get_data(GTK_OBJECT(splash), "splash_version_label")))
	{
	  char label[LINESIZE];

#ifdef RELEASE
	  snprintf(label, LINESIZE, _("Version %s"), VERSION);
#else
	  snprintf(label, LINESIZE, "Development Version as of " LAST_UPDATE);
#endif
	  gtk_label_set_text(GTK_LABEL(w), label);
	}
      gtk_widget_show (splash);
      gtk_timeout_add(4000, (GtkFunction)gtk_widget_hide, splash);
    }

  gtk_idle_add(main_startup_idle_handler, GINT_TO_POINTER(tcpdump_init_state));

  gtk_main ();

  return 0;
}

