!**************************************************************************
!*
!* Boot-ROM-Code to load an operating system across a TCP/IP network.
!*
!* Module:  bcc_lshl.S
!* Purpose: Routines required by bcc
!* Entries: lsll, lslul
!*
!**************************************************************************
!*
!* Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
!*
!*  This program is free software; you can redistribute it and/or modify
!*  it under the terms of the GNU General Public License as published by
!*  the Free Software Foundation; either version 2 of the License, or
!*  any later version.
!*
!*  This program is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU General Public License for more details.
!*
!*  You should have received a copy of the GNU General Public License
!*  along with this program; if not, write to the Free Software
!*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!*


!
!**************************************************************************
!
! Include assembler macros:
!
#include <macros.inc>
#include <memory.inc>
#include "./libpriv.inc"


!
!**************************************************************************
!
! Start code segment.
!
	.text


! If we are using the peephole optimizer for BCC all routines in this
! file should be unnecessary, so prevent it from getting included by
! disabling all public definitions.
#ifndef OPT386
	public	lsll		! define entry points
	public	lslul
#endif


!
!**************************************************************************
!
! Define BCC support functions
!
! Shift left
lsll:
lslul:	mov	cx,di
	cmp	cx,#32
	jae	lsll8
#ifdef IS386
	shld	bx,ax,cl
	shl	ax,cl
#else
	jcxz	lsll9
lsll1:	shl	ax,#1
	rcl	bx,#1
	loop	lsll1
	jmp	lsll9
#endif
lsll8:	xor	ax,ax
	mov	bx,ax
lsll9:	ret


!
!**************************************************************************
!
	end

