--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
package Narval.State_Machine is

   protected type Machine is
      function Current_State return Acquisition_State_Type;
      function Image return String;
      procedure Change_State (Order : Action);
      function Order_Coherency (Order : Action) return Boolean;
      function Available_Orders return Action_Array;
      procedure Put_In_Error;
      function State_Before_Error return Acquisition_State_Type;
   private
      Current_Acquisition_State : Acquisition_State_Type := Initial;
      Memory_Of_State_Before_Error : Acquisition_State_Type := Initial;
   end Machine;
   Changing_State_Problem : exception;
   In_Transition : exception;
end Narval.State_Machine;
