--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
package Start_Stop_Handling is
   protected type Synchro_Start_Type is
      procedure Stop;
      procedure Start;
      entry Is_Running;
      entry Is_Stopped;
      function Is_Running return Boolean;
      function Is_Stopped return Boolean;
   private
      Running : Boolean := False;
   end Synchro_Start_Type;
   type Synchro_Start_Access is access Synchro_Start_Type;

   protected type Synchro_Pause_Type is
      procedure Resume;
      procedure Pause;
      entry Set_Pause_Off;
      entry Set_Pause_On;
      function Is_Paused return Boolean;
   private
      Paused : Boolean := False;
   end Synchro_Pause_Type;

end Start_Stop_Handling;
