--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
procedure Socket_Receive
  (Socket : GNAT.Sockets.Socket_Type;
   Data : out Ada.Streams.Stream_Element_Array) is
   use type Ada.Streams.Stream_Element_Offset;
   First : Ada.Streams.Stream_Element_Offset := Data'First;
   Index : Ada.Streams.Stream_Element_Offset := First - 1;
   Max : constant Ada.Streams.Stream_Element_Offset := Data'Last;
begin
   loop
      GNAT.Sockets.Receive_Socket (Socket, Data (First .. Max), Index);
      exit when Index < First or else Index = Max;
      First := Index + 1;
   end loop;
end Socket_Receive;
