/* Copyright (C) 2001 MySQL AB
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* This code is generated by gen_lex_hash.cc that seeks for a perfect
hash function */

#include "lex.h"

static uint16 char_table[] = {
51844,11266,59623,64422,45901,7302,37745,28840,24594,51024,13261,26134,3503,46132,12776,28260,
12321,15601,1847,1533,13561,24062,20094,21949,49361,37402,32007,29925,12425,6338,46092,32537,
52972,13323,813,40150,21211,47064,51354,45172,46095,20590,56207,33644,3951,17769,52298,58033,
60454,57681,10554,43382,56391,18860,7736,59038,814,31819,23381,12961,22418,5550,13020,40968,
14825,18165,15091,2832,989,3214,26232,5057,8915,55943,59478,12692,36026,6529,43864,18267,
30270,5730,37884,847,2338,6538,14367,36000,31454,15509,3298,4533,58757,51629,28682,25450,
55711,18165,15091,2832,989,3214,26232,5057,8915,55943,59478,12692,36026,6529,43864,18267,
30270,5730,37884,847,2338,6538,14367,36000,31454,15509,3298,8911,6379,52109,36330,15312,
26944,37143,51956,34491,54386,31319,18892,64188,60505,20803,63325,51442,43273,9178,22856,28628,
62757,52677,14493,30169,9678,9207,21399,21666,20364,45651,21634,9616,24302,43465,39830,61668,
6673,21984,60299,57651,10590,36700,40026,14340,24606,1071,29926,23263,60173,58421,8732,28257,
9059,15555,2124,23972,48843,59076,39686,40357,63809,55546,13873,47608,38079,3132,26809,23615,
27726,32825,55557,24701,49645,21446,27363,41594,36011,9674,58930,46551,41796,5755,23427,50708,
20027,21053,42306,41752,48054,48997,65014,51413,62088,21062,32270,22326,57463,48643,50431,31914,
11373,19028,62889,770,27314,24185,13511,58975,16197,4690,29286,5287,50112,25727,38127,43562,
40,1888,103,40955,11081,5330,3376,27827,39905,22896,9067,34428,2713,39971,62756,52208
};


static uchar unique_length[] = {
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,3,1,2,0,
0,5,5,13,9,7,6,7,6,7,1,4,5,12,5,7,
8,3,12,10,6,7,4,5,0,5,1,0,0,0,0,0,
0,5,5,13,9,7,6,7,6,7,1,4,5,12,5,7,
8,3,12,10,6,7,4,5,0,5,1,0,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};


static uint16 my_function_table[] = {
32767,32767,32767,32767,36,32767,221,32767,32767,32767,32767,32767,
32767,112,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,54,298,32767,
32767,32767,32767,32767,275,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
356,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,377,
11,32767,32767,32767,32767,32767,32767,32767,32767,32767,193,325,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,82,32767,32767,32767,32767,32767,
32767,32767,32767,323,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,334,384,32767,32767,32767,32767,32767,32767,32767,32767,
158,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,35,32767,32767,310,
32767,32767,32767,392,156,32767,32767,32767,32767,32767,32767,32767,
32767,32767,13,206,231,235,32767,32767,57,32767,225,32767,
32767,32767,32767,32767,32767,32767,50,32767,32767,32767,32767,32767,
32767,219,32767,32767,32767,32767,32767,32767,32767,32767,252,32767,
32767,32767,140,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,368,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
217,32767,15,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,119,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,44,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,415,32767,32767,32767,373,32767,32767,32767,32767,
273,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,187,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,407,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,201,32767,32767,
32767,32767,343,32767,32767,32767,32767,32767,66,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,291,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
87,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
391,32767,32767,32767,32767,32767,32767,270,32767,333,32767,278,
32767,32767,32767,32767,32767,32767,32767,192,32767,32767,32767,353,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,172,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,74,32767,32767,32767,32767,223,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,97,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,157,123,32767,135,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,315,32767,32767,32767,32767,396,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,33,32767,32767,32767,32767,32767,90,32767,197,268,32767,
122,371,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,208,32767,32767,32767,32767,32767,32767,32767,32767,
382,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
182,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,49,32767,32767,32767,67,32767,9,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,366,32767,32767,32767,32767,32767,32767,257,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,30,32767,32767,32767,32767,317,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,426,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,80,92,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
243,32767,32767,32767,320,32767,32767,32767,32767,10,32767,32767,
32767,32767,176,32767,32767,32767,32767,32767,32767,224,32767,32767,
32767,32767,32767,32767,403,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,169,418,32767,32767,263,433,32767,32767,32767,
288,32767,32767,32767,32767,32767,32767,96,32767,195,32767,32767,
32767,32767,32767,32767,32767,32767,289,186,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,108,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,329,32767,32767,32767,32767,
32767,32767,32767,32767,259,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,177,
32767,246,32767,32767,32767,32767,65,32767,32767,32767,32767,32767,
32767,32767,430,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,312,32767,32767,32767,304,32767,
32767,32767,32767,248,32767,32767,32767,32767,32767,340,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
125,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,238,32767,32767,32767,
32767,32767,32767,32767,98,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,60,32767,32767,
32767,32767,32767,305,32767,32767,32767,126,32767,32767,32767,32767,
32767,32767,32767,32767,32767,336,32767,32767,306,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32,
32767,32767,32767,32767,32767,32767,419,32767,32767,32767,32767,32767,
32767,32767,51,32767,32767,32767,32767,32767,32767,2,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,113,32767,32767,32767,32767,32767,400,3,32767,32767,
32767,25,32767,32767,32767,32767,32767,269,32767,32767,32767,32767,
32767,32767,32767,32767,32767,237,32767,32767,32767,32767,32767,34,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,354,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,131,
32767,191,32767,32767,32767,32767,32767,32767,32767,32767,32767,109,
32767,32767,32767,32767,32767,32767,32767,32767,369,32767,32767,32767,
32767,32767,32767,148,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,386,133,
395,32767,32767,32767,32767,32767,32767,311,357,32767,32767,32767,
91,32767,32767,32767,364,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,41,32767,32767,264,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,303,32767,32767,32767,32767,32767,32767,32767,32767,417,32767,
32767,32767,32767,32767,32767,32767,32767,309,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,244,32767,32767,32767,
32767,32767,32767,32767,159,32767,32767,32767,32767,32767,380,32767,
32767,143,32767,32767,204,32767,32767,32767,32767,32767,32767,32767,
37,32767,32767,32767,32767,32767,32767,32767,32767,32767,372,32767,
95,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,274,32767,32767,32767,32767,
32767,32767,136,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,150,32767,32767,32767,32767,56,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,233,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
38,32767,32767,32767,32767,32767,32767,99,286,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,22,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,284,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,16,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,86,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,313,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,162,32767,32767,29,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,93,32767,32767,32767,32767,32767,32767,
32767,32767,32767,302,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,358,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,121,190,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,128,271,32767,402,32767,32767,
32767,32767,247,32767,32767,32767,32767,32767,32767,32767,32767,32767,
68,32767,32767,32767,425,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,83,32767,32767,32767,32767,
42,32767,32767,32767,32767,401,32767,32767,32767,32767,398,32767,
32767,32767,32767,32767,18,32767,32767,203,32767,32767,32767,32767,
32767,32767,32767,32767,32767,285,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,326,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,110,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,79,32767,32767,32767,32767,32767,
32767,314,408,32767,32767,32767,352,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,422,32767,55,32767,266,
378,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,406,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,281,32767,260,12,32767,32767,32767,
32767,32767,32767,32767,32767,142,32767,32767,32767,410,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,58,32767,32767,32767,
32767,32767,32767,428,32767,207,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,228,32767,32767,32767,53,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,220,32767,32767,32767,32767,351,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,360,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,337,32767,43,32767,32767,32767,32767,32767,32767,
32767,405,32767,32767,32767,32767,196,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
218,32767,32767,32767,32767,32767,32767,178,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
46,339,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,134,32767,32767,32767,72,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,194,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,101,32767,293,154,32767,32767,32767,32767,
390,32767,32767,61,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,292,32767,32767,262,
307,324,32767,32767,32767,32767,32767,32767,413,32767,32767,32767,
32767,32767,139,404,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,423,331,32767,32767,32767,32767,32767,115,32767,160,
32767,32767,32767,32767,32767,32767,362,32767,230,32767,28,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,385,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,215,32767,32767,32767,32767,
32767,375,32767,32767,32767,32767,32767,32767,104,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,222,32767,32767,32767,32767,32767,32767,322,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,389,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,242,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,129,32767,32767,32767,32767,32767,32767,234,32767,32767,32767,
359,32767,188,32767,32767,189,32767,32767,32767,32767,32767,245,
332,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
152,32767,321,32767,210,32767,32767,32767,367,32767,32767,32767,
32767,249,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
272,32767,32767,32767,32767,32767,32767,32767,32767,8,32767,32767,
32767,32767,32767,32767,32767,294,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,432,32767,32767,32767,32767,147,32767,
166,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,383,
70,32767,175,32767,32767,32767,32767,32767,32767,32767,32767,239,
32767,412,397,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,226,32767,32767,32767,
32767,32767,32767,32767,32767,32767,282,32767,32767,32767,32767,6,
32767,163,32767,214,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
414,32767,32767,63,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,416,32767,32767,32767,32767,118,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,295,32767,32767,32767,32767,
32767,32767,32767,335,32767,32767,379,132,32767,32767,32767,32767,
32767,216,32767,32767,32767,32767,316,32767,32767,32767,32767,32767,
32767,32767,32767,32767,26,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,300,76,170,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,77,283,32767,
32767,32767,32767,32767,393,32767,213,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,212,32767,32767,32767,32767,32767,32767,
32767,32767,171,32767,198,179,32767,32767,32767,32767,32767,32767,
32767,149,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,276,32767,32767,32767,32767,32767,32767,32767,
23,103,32767,32767,32767,32767,17,32767,32767,32767,32767,32767,
32767,32767,32767,39,32767,32767,32767,173,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,40,32767,0,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,168,32767,32767,
32767,32767,4,32767,32767,32767,32767,32767,32767,32767,32767,32767,
277,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,429,
32767,32767,32767,181,32767,32767,32767,32767,32767,116,32767,32767,
32767,32767,32767,32767,32767,32767,183,161,32767,32767,427,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,106,32767,280,32767,399,32767,
32767,347,32767,85,32767,32767,32767,32767,32767,32767,32767,32767,
32767,199,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,124,32767,250,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,424,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,117,32767,32767,32767,32767,
32767,32767,32767,32767,32767,240,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
47,32767,32767,344,32767,32767,32767,32767,267,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,59,32767,32767,32767,32767,32767,32767,32767,151,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,209,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,349,32767,32767,167,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,421,32767,32767,254,
32767,32767,32767,32767,32767,32767,32767,32767,164,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,138,32767,32767,32767,32767,
227,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,365,
32767,21,32767,32767,32767,32767,32767,32767,120,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,261,32767,290,
145,130,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,69,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,363,32767,32767,32767,32767,153,32767,
32767,32767,32767,205,62,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,328,
32767,32767,32767,255,32767,32767,376,32767,32767,32767,32767,32767,
185,32767,32767,32767,32767,102,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,308,32767,32767,32767,32767,111,32767,32767,
32767,75,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,7,32767,32767,32767,
32767,32767,32767,394,32767,32767,32767,32767,88,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,387,
32767,327,32767,32767,32767,370,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,19,
73,32767,32767,330,32767,32767,32767,32767,32767,32767,45,32767,
253,32767,32767,32767,32767,32767,297,32767,32767,32767,155,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,146,32767,32767,32767,81,32767,32767,
32767,32767,89,411,32767,32767,32767,32767,32767,32767,32767,32767,
258,180,32767,32767,32767,32767,32767,32767,256,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,1,32767,32767,32767,32767,32767,14,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,350,32767,32767,32767,32767,32767,32767,
32767,32767,141,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,5,32767,32767,32767,32767,94,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,342,32767,32767,32767,32767,32767,32767,32767,32767,32767,
165,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,114,32767,374,32767,32767,32767,32767,32767,
32767,32767,32767,107,361,32767,32767,32767,32767,127,32767,32767,
32767,32767,184,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,341,32767,71,32767,174,32767,32767,32767,
409,32767,32767,32767,32767,32767,32767,32767,229,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,296,32767,32767,32767,32767,279,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,236,32767,32767,32767,
32767,32767,318,32767,32767,32767,64,32767,31,381,32767,32767,
32767,32767,32767,32767,32767,32767,32767,100,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,137,32767,211,48,32767,32767,
32767,32767,32767,32767,32767,32767,32767,144,32767,32767,32767,32767,
32767,32767,27,78,32767,32767,32767,32767,32767,32767,32767,346,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,355,32767,32767,
32767,32767,32767,32767,32767,32767,32767,345,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,52,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,319,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
202,299,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,105,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,200,
32767,32767,32767,32767,32767,251,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,287,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,232,32767,32767,32767,
32767,32767,32767,32767,32767,24,32767,32767,32767,32767,265,32767,
32767,32767,420,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,84,32767,
20,32767,32767,32767,32767,32767,348,32767,32767,32767,32767,431,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,388,
32767,32767,32767,32767,32767,32767,32767,301,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,241,
32767,32767,32767,32767,32767,32767,338,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767
};


/* start_value=0L;  best_t1=3632784L;  best_t2=86437L;  best_type=3; */ /* mode=4229  add=2  type: 0 */

inline SYMBOL *get_hash_symbol(const char *s,unsigned int length,bool function)
{
  ulong idx = 6130115+char_table[(uchar) *s];
  SYMBOL *sim;
  const char *start=s;
  int i=unique_length[(uchar) *s++];
  if (i > (int) length) i=(int) length;
  while (--i > 0)
    idx= (idx ^ (char_table[(uchar) *s++] + (idx << 2)));
  idx=my_function_table[(idx & 8388607) % 4229];
  if (idx >= 311)
  {
    if (!function || idx >= 32767) return (SYMBOL*) 0;
    sim=sql_functions + (idx - 311);
  }
  else
    sim=symbols + idx;
  if ((length != sim->length) || lex_casecmp(start,sim->name,length))
    return  (SYMBOL *)0;
  return sim;
}
