/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.

   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* sql_yacc.y */

%{
#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex current_lex
#include "mysql_priv.h"
#include "sql_acl.h"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

extern void yyerror(const char*);
int yylex(void *yylval);

#define yyoverflow(A,B,C,D,E,F) if (my_yyoverflow((B),(D),(F))) { yyerror(A); return 2; }

%}
%union {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_num;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  Table_ident *table;
  char *simple_string;
  Item *item;
  List<Item> *item_list;
  Key::Keytype key_type;
  enum db_type db_type;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  interval_type interval;
  LEX_USER *lex_user;
}

%{
bool my_yyoverflow(short **a, YYSTYPE **b,int *yystacksize);
%}

%pure_parser					/* We have threads */

%token	END_OF_INPUT

%token	EQ
%token	GE
%token	GT_SYM
%token	LE
%token	LT
%token	NE
%token	IS
%token	SHIFT_LEFT
%token	SHIFT_RIGHT

%token	AVG_SYM
%token	COUNT_SYM
%token	MAX_SYM
%token	MIN_SYM
%token	SUM_SYM
%token	STD_SYM

%token	ADD
%token	ALTER
%token	AFTER_SYM
%token	CHANGE
%token  COMMENT_SYM
%token	CREATE
%token	CROSS
%token	DELETE_SYM
%token	DROP
%token	INSERT
%token	FLUSH_SYM
%token	SELECT_SYM
%token	OPTIMIZE
%token	SHOW
%token	UPDATE_SYM
%token	KILL_SYM
%token	LOAD
%token	LOCK_SYM
%token	UNLOCK_SYM

%token	ACTION
%token	ALL
%token	AS
%token	DISTINCT
%token	STRAIGHT_JOIN

%token	AGGREGATE_SYM
%token	AND
%token	ASC
%token	AVG_ROW_LENGTH
%token	BIT_SYM
%token	BOTH
%token	BOOL_SYM
%token	BY
%token	CASCADE
%token	CHECKSUM_SYM
%token	CONSTRAINT
%token	CHECK_SYM
%token	DATA_SYM
%token	DATABASES
%token	DEFAULT
%token	DESC
%token	DESCRIBE
%token	COLUMN_SYM
%token	COLUMNS
%token	DELAYED_SYM
%token	DELAY_KEY_WRITE_SYM
%token	ENCLOSED
%token	ESCAPED
%token	ESCAPE_SYM
%token	EXISTS
%token	FOREIGN
%token	HEAP_SYM
%token	ISAM_SYM
%token	GET_LOCK
%token	KEYS
%token	FIND_IN_SET
%token	FIRST_SYM
%token	FULL
%token	FROM
%token	GRANT
%token	GLOBAL_SYM
%token	GREATEST_SYM
%token	GROUP
%token	HOSTS_SYM
%token	IGNORE_SYM
%token	INDEX
%token	INFILE
%token	INTO
%token	IN_SYM
%token	IF
%token	JOIN_SYM
%token	LEADING
%token	LEAST_SYM
%token	LOCAL_SYM
%token	LONG_SYM
%token	LOGS_SYM
%token	LIKE
%token	LINES
%token	MAX_ROWS
%token	MIN_ROWS
%token	MYISAM_SYM
%token	PARTIAL
%token	PRIVILEGES
%token	READ_SYM
%token	READ_LOCAL_SYM
%token	RELEASE_LOCK
%token	REGEXP
%token	RENAME
%token	RESTRICT
%token	REFERENCES
%token	LOW_PRIORITY
%token	HIGH_PRIORITY
%token	MATCH
%token	NATURAL
%token	NO_SYM
%token	NOT
%token	NULL_SYM
%token	ON
%token	OPTION
%token	OPTIONALLY
%token	OR
%token	ORDER_SYM
%token	OUTER
%token	OUTFILE
%token	PACK_KEYS_SYM
%token	PROCESSLIST_SYM
%token	ROW_SYM
%token	ROWS_SYM
%token	HAVING
%token	SET
%token	STARTING
%token	STATUS_SYM
%token	USING
%token	TABLES
%token	TABLE_SYM
%token	TERMINATED
%token	TRAILING
%token	TO_SYM
%token	TYPE_SYM
%token	VALUES
%token	VARIABLES
%token	UDF_SYM
%token	UDF_RETURNS_SYM
%token	UDF_SONAME_SYM
%token	USAGE
%token	USE_SYM
%token	WITH
%token	WRITE_SYM
%token	WHERE
%token	REVOKE
%token	RELOAD
%token	SHUTDOWN
%token	FILE_SYM
%token	PROCESS

%token	KEY_SYM
%token	PRIMARY_SYM
%token	UNIQUE_SYM
%token	AUTO_INC
%token	BINARY

%token	IDENT
%token	NUM
%token	LONG_NUM
%token	REAL_NUM
%token	TEXT_STRING
%token	HEX_NUM
%token	LEX_HOSTNAME

%token	BIGINT
%token	BLOB_SYM
%token	CHAR_SYM
%token	DATETIME
%token	DATE_SYM
%token	DECIMAL_SYM
%token	DOUBLE_SYM
%token	ENUM
%token	FLOAT_SYM
%token	INT_SYM
%token	LIMIT
%token	LONGBLOB
%token	LONGTEXT
%token	MEDIUMBLOB
%token	MEDIUMINT
%token	MEDIUMTEXT
%token	NUMERIC_SYM
%token	PRECISION
%token	REAL
%token	SMALLINT
%token	STRING_SYM
%token	TEXT_SYM
%token	TIMESTAMP
%token	TIME_SYM
%token	TINYBLOB
%token	TINYINT
%token	TINYTEXT
%token	UNSIGNED
%token	VARBINARY
%token	VARCHAR
%token	VARYING
%token	ZEROFILL

%token	ABS
%token	ACOS
%token	ASCII
%token	ASIN
%token	ATAN
%token	BETWEEN_SYM
%token	BIN
%token	BIT_AND
%token	BIT_COUNT
%token	BIT_OR
%token	CEILING
%token	CONCAT
%token	CONV
%token	COS
%token	COT
%token	CURDATE
%token	CURTIME
%token	DATABASE
%token	DATE_FORMAT_SYM
%token	DATE_ADD_INTERVAL
%token	DATE_SUB_INTERVAL
%token	DAYNAME
%token	DEGREES
%token	YEAR_SYM
%token	MONTH_SYM
%token	MONTH_NAME_SYM
%token	DAY_SYM
%token	HOUR_SYM
%token	MINUTE_SYM
%token	SECOND_SYM
%token	YEAR_MONTH_SYM
%token	DAY_HOUR_SYM
%token	DAY_MINUTE_SYM
%token	DAY_SECOND_SYM
%token	DAY_OF_WEEK
%token	DAY_OF_MONTH
%token	DAY_OF_YEAR
%token	DECODE_SYM
%token	HOUR_MINUTE_SYM
%token	HOUR_SECOND_SYM
%token	MINUTE_SECOND_SYM
%token	ELT_FUNC
%token	ENCODE_SYM
%token	ENCRYPT
%token	EXP
%token	FIELD_FUNC
%token	FLOOR
%token	FOR_SYM
%token	FORMAT
%token	FROM_DAYS
%token	FROM_UNIXTIME
%token	GROUP_UNIQUE_USERS
%token	HEX
%token	IDENTIFIED_SYM
%token	IF
%token	IFNULL
%token	INSERT_ID
%token	INSTR
%token	INTERVAL_SYM
%token	ISNULL
%token	LAST_INSERT_ID
%token	LCASE
%token	LEFT
%token	LENGTH
%token	LOCATE
%token	LOG
%token	LOG10
%token	LPAD
%token	LTRIM
%token	MAKE_SET_SYM
%token	MODIFY_SYM
%token	MOD_SYM
%token	NOW_SYM
%token	OCT
%token	PASSWORD
%token	PERIOD_ADD
%token	PERIOD_DIFF
%token	PI_SYM
%token	POSITION_SYM
%token	POW
%token	PROCEDURE
%token	QUARTER
%token	RAND
%token	RADIANS
%token	REPEAT
%token	REPLACE
%token	REVERSE
%token	RIGHT
%token	ROUND
%token	RPAD
%token	RTRIM
%token	SEC_TO_TIME
%token	SIGN
%token	SIN
%token	SOUNDEX
%token	SPACE
%token	SQRT
%token  BENCHMARK_SYM
%token	STRCMP
%token	SUBSTRING
%token	SUBSTRING_INDEX
%token	TAN
%token	TIME_TO_SEC
%token	TIME_FORMAT_SYM
%token	TO_DAYS
%token	TRIM
%token	TRUNCATE
%token	UCASE
%token	UNIQUE_USERS
%token	UNIX_TIMESTAMP
%token	USER
%token	VERSION_SYM
%token	WEEK_SYM
%token	WEEKDAY
%token	UDA_CHAR_SUM
%token	UDA_FLOAT_SUM
%token	UDA_INT_SUM
%token	UDF_CHAR_FUNC
%token	UDF_FLOAT_FUNC
%token	UDF_INT_FUNC

%token	SQL_BIG_TABLES
%token	SQL_BIG_SELECTS
%token	SQL_SELECT_LIMIT
%token	SQL_LOG_OFF
%token	SQL_LOG_UPDATE
%token	SQL_LOW_PRIORITY_UPDATES
%token	SQL_SMALL_RESULT
%token	SQL_BIG_RESULT
%token	SQL_WARNINGS
%token	SQL_AUTO_IS_NULL
%token	SQL_SAFE_UPDATES

%left	OR
%left	AND
%left	BETWEEN_SYM
%left	EQ GE GT_SYM LE LT NE IS LIKE REGEXP IN_SYM
%left	'|'
%left	'&'
%left	SHIFT_LEFT SHIFT_RIGHT
%left	'-' '+'
%left	'*' '/' '%'
%left	NEG
%right	NOT

%type <lex_str>
	IDENT TEXT_STRING REAL_NUM NUM LONG_NUM HEX_NUM LEX_HOSTNAME
	field_ident select_alias ident ident_or_text keyword

%type <lex_str_ptr>
	opt_table_alias

%type <table>
	table_ident

%type <simple_string>
	remember_name remember_end opt_len opt_ident opt_db text_or_password
	opt_escape

%type <string>
	text_string

%type <num>
	type int_type real_type order_dir opt_field_spec set_option lock_option
	udf_type if_exists opt_local

%type <ulong_num>
	ULONG_NUM

%type <ulonglong_num>
	ULONGLONG_NUM

%type <item>
	literal text_literal insert_ident group_ident order_ident
	simple_ident select_item2 expr sum_expr in_sum_expr table_wild
	opt_pad no_in_expr expr_expr simple_expr no_and_expr
	using_list

%type <item_list>
	expr_list udf_expr_list

%type <key_type>
	key_type opt_unique

%type <key_part>
	key_part

%type <table_list>
	join_table_list join_table

%type <udf> UDF_CHAR_FUNC UDF_FLOAT_FUNC UDF_INT_FUNC
	    UDA_CHAR_SUM UDA_FLOAT_SUM UDA_INT_SUM

%type <interval> interval

%type <db_type> table_types

%type <lex_user> user grant_user

%type <NONE>
	query verb_clause create select drop insert replace insert2 kill
	insert_values update delete show describe load alter optimize flush
	field_list field_list_item field_spec
	select_item_list select_item values_list no_braces
	limit_clause delete_limit_clause fields values procedure_list
	procedure_item expr_list2 global_option
	opt_precision opt_ignore opt_column opt_restrict
	grant revoke set lock unlock string_list field_options field_option
	field_opt_list opt_binary table_lock_list table_lock varchar
	references opt_on_delete opt_on_delete_list opt_on_delete_item use
	opt_outer table_list table opt_option opt_place opt_low_priority
	opt_attribute opt_attribute_list attribute column_list column_list_id
	opt_column_list grant_privileges opt_table user_list grant_option
	grant_privilege grant_privilege_list
	flush_options flush_option insert_lock_option
	END_OF_INPUT

%type <NONE>
	'-' '+' '*' '/' '%' '(' ')'
	',' '!' '{' '}' '&' '|' AND OR BETWEEN_SYM
%%


query:
	END_OF_INPUT
	 {
	   if (!current_thd->bootstrap)
	     send_error(&current_thd->net,ER_EMPTY_QUERY);
	   YYABORT;
	}
	| verb_clause END_OF_INPUT {}

verb_clause:
	  alter
	| create
	| delete
	| describe
	| drop
	| grant
	| insert
	| flush
	| load
	| lock
	| kill
	| optimize
	| replace
	| revoke
	| select
	| set
	| show
	| unlock
	| update
	| use

/* create a table */

create:
	CREATE TABLE_SYM table_ident
	  {
	    Lex->sql_command= SQLCOM_CREATE_TABLE;
	    if (!add_table_to_list($3,NULL))
	      YYABORT;
	    Lex->create_list.empty();
	    Lex->key_list.empty();
	    Lex->col_list.empty();
	    Lex->change=NullS;
	    Lex->password=0;
	  }
	  '(' field_list ')' opt_create_table_options
	| CREATE opt_unique INDEX ident ON table_ident
	  {
	    Lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!add_table_to_list($6,NULL))
	      YYABORT;
	    Lex->create_list.empty();
	    Lex->key_list.empty();
	    Lex->col_list.empty();
	    Lex->change=NullS;
	  }
	  '(' key_list ')'
	  {
	    Lex->key_list.push_back(new Key($2,$4.str,Lex->col_list));
	    Lex->col_list.empty();
	  }
	| CREATE DATABASE ident
	  {
	    Lex->sql_command=SQLCOM_CREATE_DB;
	    Lex->name=$3.str;
	  }
	| CREATE UDF_SYM ident
	  {
	    Lex->sql_command = SQLCOM_CREATE_FUNCTION;
	    Lex->udf.name=$3.str;
	    Lex->udf.name_length=$3.length;
	  }
	  UDF_RETURNS_SYM udf_type UDF_SONAME_SYM TEXT_STRING
	  {
	    Lex->udf.returns=(Item_result) $6;
	    Lex->udf.dl=$8.str;
	  }

opt_create_table_options:
	/* empty */
	| create_table_options

create_table_options:
	create_table_option
	| create_table_option create_table_options

create_table_option:
	TYPE_SYM EQ table_types			{ Lex->db_type= $3; }
	| MAX_ROWS EQ ULONGLONG_NUM		{ Lex->max_rows= $3; }
	| AVG_ROW_LENGTH EQ ULONG_NUM		{ Lex->avg_length=$3; }
	| PASSWORD EQ TEXT_STRING		{ Lex->password=$3.str; }
	| MIN_ROWS EQ ULONGLONG_NUM		{ }
	| COMMENT_SYM EQ TEXT_STRING		{ }
	| AUTO_INC EQ ULONGLONG_NUM		{ }
	| PACK_KEYS_SYM EQ ULONG_NUM		{ }
	| CHECKSUM_SYM EQ ULONG_NUM		{ }
	| DELAY_KEY_WRITE_SYM EQ ULONG_NUM	{ }

table_types:
	ISAM_SYM { $$= DB_TYPE_ISAM; }
	| MYISAM_SYM { $$= DB_TYPE_MYISAM; }
	| HEAP_SYM { $$= DB_TYPE_HEAP; }

udf_type:
	STRING_SYM {$$ = (int) STRING_RESULT; }
	| REAL {$$ = (int) REAL_RESULT; }
	| INT_SYM {$$ = (int) INT_RESULT; }

field_list:
	  field_list_item
	| field_list ',' field_list_item


field_list_item:
	  field_spec
	| field_spec references
	  {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
	| key_type opt_ident '(' key_list ')'
	  {
	    Lex->key_list.push_back(new Key($1,$2,Lex->col_list));
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
	| opt_constraint FOREIGN KEY_SYM '(' key_list ')' references
	  {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
	| CHECK_SYM '(' expr ')'
	  {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }

opt_constraint:
	/* empty */
	| CONSTRAINT opt_ident

field_spec:
	field_ident
	 {
	   Lex->length=Lex->dec=0; Lex->type=0; Lex->interval=0;
	   Lex->default_value=0;
	 }
	type opt_attribute
	{
	  if (add_field_to_list($1.str,
				(enum enum_field_types) $3,
				Lex->length,Lex->dec,Lex->type,
				Lex->default_value,Lex->change,
				Lex->interval))
	    YYABORT;
	}

type:
	int_type opt_len field_options	{ Lex->length=$2; $$=$1; }
	| real_type opt_precision field_options { $$=$1; }
	| FLOAT_SYM float_options field_options { $$=FIELD_TYPE_FLOAT; }
	| BIT_SYM			{ Lex->length="1";
					  $$=FIELD_TYPE_TINY; }
	| BOOL_SYM			{ Lex->length="1";
					  $$=FIELD_TYPE_TINY; }
	| CHAR_SYM '(' NUM ')' opt_binary { Lex->length=$3.str;
					  $$=FIELD_TYPE_STRING; }
	| CHAR_SYM opt_binary		{ Lex->length="1";
					  $$=FIELD_TYPE_STRING; }
	| BINARY '(' NUM ')' 		{ Lex->length=$3.str;
					  Lex->type|=BINARY_FLAG;
					  $$=FIELD_TYPE_STRING; }
	| varchar '(' NUM ')' opt_binary { Lex->length=$3.str;
					  $$=FIELD_TYPE_VAR_STRING; }
	| VARBINARY '(' NUM ')' 	{ Lex->length=$3.str;
					  Lex->type|=BINARY_FLAG;
					  $$=FIELD_TYPE_VAR_STRING; }
	| YEAR_SYM opt_len field_options { $$=FIELD_TYPE_YEAR; Lex->length=$2; }
	| DATE_SYM			{ $$=FIELD_TYPE_DATE; }
	| TIME_SYM			{ $$=FIELD_TYPE_TIME; }
	| TIMESTAMP			{ $$=FIELD_TYPE_TIMESTAMP; }
	| TIMESTAMP '(' NUM ')'		{ Lex->length=$3.str;
					  $$=FIELD_TYPE_TIMESTAMP; }
	| DATETIME			{ $$=FIELD_TYPE_DATETIME; }
	| TINYBLOB			{ Lex->type|=BINARY_FLAG;
					  $$=FIELD_TYPE_TINY_BLOB; }
	| BLOB_SYM			{ Lex->type|=BINARY_FLAG;
					  $$=FIELD_TYPE_BLOB; }
	| MEDIUMBLOB			{ Lex->type|=BINARY_FLAG;
					  $$=FIELD_TYPE_MEDIUM_BLOB; }
	| LONGBLOB			{ Lex->type|=BINARY_FLAG;
					  $$=FIELD_TYPE_LONG_BLOB; }
	| LONG_SYM VARBINARY		{ Lex->type|=BINARY_FLAG;
					  $$=FIELD_TYPE_MEDIUM_BLOB; }
	| LONG_SYM varchar		{ $$=FIELD_TYPE_MEDIUM_BLOB; }
	| TINYTEXT			{ $$=FIELD_TYPE_TINY_BLOB; }
	| TEXT_SYM			{ $$=FIELD_TYPE_BLOB; }
	| MEDIUMTEXT			{ $$=FIELD_TYPE_MEDIUM_BLOB; }
	| LONGTEXT			{ $$=FIELD_TYPE_LONG_BLOB; }
	| DECIMAL_SYM '(' NUM ',' NUM ')' field_options
					{ Lex->length=$3.str; Lex->dec=$5.str;
					  $$=FIELD_TYPE_DECIMAL;}
	| NUMERIC_SYM '(' NUM ',' NUM ')' field_options
					{ Lex->length=$3.str; Lex->dec=$5.str;
					  $$=FIELD_TYPE_DECIMAL;}
	| ENUM {Lex->interval_list.empty();} '(' string_list ')'
	  {
	    Lex->interval=typelib(Lex->interval_list);
	    $$=FIELD_TYPE_ENUM;
	    Lex->interval_list.empty();		/* Alloced by sql_alloc */
	  }
	| SET { Lex->interval_list.empty();} '(' string_list ')'
	  {
	    Lex->interval=typelib(Lex->interval_list);
	    $$=FIELD_TYPE_SET;
	    Lex->interval_list.empty();		/* Alloced by sql_alloc */
	  }

varchar:
	CHAR_SYM VARYING {}
	| VARCHAR {}

int_type:
	INT_SYM		{ $$=FIELD_TYPE_LONG; }
	| TINYINT	{ $$=FIELD_TYPE_TINY; }
	| SMALLINT	{ $$=FIELD_TYPE_SHORT; }
	| MEDIUMINT	{ $$=FIELD_TYPE_INT24; }
	| BIGINT	{ $$=FIELD_TYPE_LONGLONG; }

real_type:
	REAL		{ $$=FIELD_TYPE_DOUBLE; }
	| DOUBLE_SYM	{ $$=FIELD_TYPE_DOUBLE; }
	| DOUBLE_SYM PRECISION { $$=FIELD_TYPE_DOUBLE; }


float_options:
	/* empty */		{}
	| '(' NUM ')'		{ Lex->length=$2.str; }
	| '(' NUM ',' NUM ')'	{ Lex->length=$2.str; Lex->dec=$4.str; }

field_options:
	/* empty */		{}
	| field_opt_list	{}

field_opt_list:
	field_opt_list field_option {}
	| field_option {}

field_option:
	UNSIGNED	{ Lex->type|= UNSIGNED_FLAG;}
	| ZEROFILL	{ Lex->type|= UNSIGNED_FLAG | ZEROFILL_FLAG; }

opt_len:
	/* empty */	{ $$=(char*) 0; }	/* use default length */
	| '(' NUM ')'	{ $$=$2.str; }

opt_precision:
	/* empty */	{}
	| '(' NUM ',' NUM ')'	{ Lex->length=$2.str; Lex->dec=$4.str; }

opt_attribute:
	/* empty */ {}
	| opt_attribute_list {}

opt_attribute_list:
	opt_attribute_list attribute {}
	| attribute

attribute:
	NULL_SYM	  { Lex->type&= ~ NOT_NULL_FLAG; }
	| NOT NULL_SYM	  { Lex->type|= NOT_NULL_FLAG; }
	| DEFAULT literal { Lex->default_value=$2; }
	| AUTO_INC	  { Lex->type|= AUTO_INCREMENT_FLAG; }
	| PRIMARY_SYM KEY_SYM { Lex->type|= PRI_KEY_FLAG | NOT_NULL_FLAG; }

opt_binary:
	/* empty */	{}
	| BINARY	{ Lex->type|=BINARY_FLAG; }

references:
	REFERENCES table_ident opt_on_delete {}
	| REFERENCES table_ident '(' key_list ')' opt_on_delete
	  {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }

opt_on_delete:
	/* empty */ {}
	| opt_on_delete_list {}

opt_on_delete_list:
	opt_on_delete_list opt_on_delete_item {}
	| opt_on_delete_item {}


opt_on_delete_item:
	ON DELETE_SYM delete_option {}
	| ON UPDATE_SYM delete_option {}
	| MATCH FULL	{}
	| MATCH PARTIAL {}

delete_option:
	RESTRICT	 {}
	| CASCADE	 {}
	| SET NULL_SYM {}
	| NO_SYM ACTION {}
	| SET DEFAULT {}

key_type:
	opt_constraint PRIMARY_SYM KEY_SYM { $$= Key::PRIMARY; }
	| key_or_index			   { $$= Key::MULTIPLE; }
	| opt_constraint UNIQUE_SYM	   { $$= Key::UNIQUE; }
	| opt_constraint UNIQUE_SYM key_or_index { $$= Key::UNIQUE; }

key_or_index:
	KEY_SYM {}
	| INDEX {}

keys_or_index:
	KEYS {}
	| INDEX {}

opt_unique:
	/* empty */	{ $$= Key::MULTIPLE; }
	| UNIQUE_SYM	{ $$= Key::UNIQUE; }

key_list:
	key_list ',' key_part order_dir { Lex->col_list.push_back($3); }
	| key_part order_dir		{ Lex->col_list.push_back($1); }

key_part:
	ident			{ $$=new key_part_spec($1.str); }
	| ident '(' NUM ')'	{ $$=new key_part_spec($1.str,(uint) atoi($3.str)); }

opt_ident:
	/* empty */	{ $$=(char*) 0; }	/* Defaultlength */
	| field_ident	{ $$=$1.str; }

string_list:
	text_string			{ Lex->interval_list.push_back($1); }
	| string_list ',' text_string	{ Lex->interval_list.push_back($3); }

/*
** Alter table
*/

alter:
	ALTER opt_ignore TABLE_SYM table_ident
	{
	  Lex->sql_command = SQLCOM_ALTER_TABLE;
	  Lex->name=0;
	  if (!add_table_to_list($4, NULL))
	    YYABORT;
	  Lex->drop_primary=0;
	  Lex->create_list.empty();
	  Lex->key_list.empty();
	  Lex->col_list.empty();
	  Lex->drop_list.empty();
	  Lex->alter_list.empty();
	  Lex->db=Lex->name=0;
	  Lex->password=0;
	}
	alter_list

alter_list:
	  alter_list_item
	| alter_list ',' alter_list_item


alter_list_item:
	ADD opt_column { Lex->change=0;} field_list_item opt_place
	| CHANGE opt_column field_ident { Lex->change= $3.str; } field_spec
	| MODIFY_SYM opt_column field_ident
	  {
	    Lex->length=Lex->dec=0; Lex->type=0; Lex->interval=0;
	    Lex->default_value=0;
	  }
	  type opt_attribute
	  {
	    if (add_field_to_list($3.str,
				  (enum enum_field_types) $5,
				  Lex->length,Lex->dec,Lex->type,
				  Lex->default_value, $3.str,
				  Lex->interval))
	     YYABORT;
	  }
	| DROP opt_column field_ident opt_restrict
	  { Lex->drop_list.push_back(new Alter_drop(Alter_drop::COLUMN,
						    $3.str)); }
	| DROP PRIMARY_SYM KEY_SYM { Lex->drop_primary=1; }
	| DROP FOREIGN KEY_SYM opt_ident {}
	| DROP key_or_index field_ident
	  { Lex->drop_list.push_back(new Alter_drop(Alter_drop::KEY,
						    $3.str)); }
	| ALTER opt_column field_ident SET DEFAULT literal
	  { Lex->alter_list.push_back(new Alter_column($3.str,$6)); }
	| ALTER opt_column field_ident DROP DEFAULT
	  { Lex->alter_list.push_back(new Alter_column($3.str,(Item*) 0)); }
	| RENAME table_alias table_ident
	  { Lex->db=$3->db.str ; Lex->name= $3->table.str; }
	| create_table_option

opt_column:
	/* empty */	{}
	| COLUMN_SYM	{}

opt_ignore:
	/* empty */	{ Lex->duplicates=DUP_ERROR; }
	| IGNORE_SYM	{ Lex->duplicates=DUP_IGNORE; }

opt_restrict:
	/* empty */	{}
	| RESTRICT	{}
	| CASCADE	{}

opt_place:
	/* empty */	{}
	| AFTER_SYM ident { store_position_for_column($2.str); }
	| FIRST_SYM	  { store_position_for_column(first_keyword); }

optimize:
	OPTIMIZE TABLE_SYM table_ident
	{
	   Lex->sql_command = SQLCOM_OPTIMIZE;
	   if (!add_table_to_list($3, NULL))
	     YYABORT;
	}

/*
** Select : retrieve data from table
*/


select:
	SELECT_SYM
	{
	  LEX *lex=Lex;
	  lex->where=lex->having=0;
	  lex->select_limit=current_thd->default_select_limit;
	  lex->offset_limit=0L;
	  lex->options=0;
	  lex->sql_command= SQLCOM_SELECT;
	  Lex->exchange = 0;
	}
	select_options select_item_list select_into

select_into:
	/* empty */
	| select_from
	| opt_into select_from
	| select_from opt_into

select_from:
	FROM join_table_list where_clause group_clause having_clause order_clause limit_clause procedure_clause


select_options:
	/* empty*/
	| select_option_list

select_option_list:
	select_option_list select_option
	| select_option

select_option:
	STRAIGHT_JOIN { Lex->options|= SELECT_STRAIGHT_JOIN; }
	| HIGH_PRIORITY { Lex->options|= SELECT_HIGH_PRIORITY; }
	| DISTINCT	{ Lex->options|= SELECT_DISTINCT; }
	| SQL_SMALL_RESULT { Lex->options|= SELECT_SMALL_RESULT; }
	| SQL_BIG_RESULT {}
	| ALL		 {}

select_item_list:
	  select_item_list ',' select_item
	| select_item
	| '*'
	  {
	    if (add_item_to_list(new Item_field(NULL,NULL,"*")))
	      YYABORT;
	  }


select_item:
	  remember_name select_item2 remember_end select_alias
	  {
	    if (add_item_to_list($2))
	      YYABORT;
	    if ($4.str)
	      $2->set_name($4.str);
	    else if (!$2->name)
	      $2->set_name($1,(uint) ($3 - $1));
	  }

remember_name:
	{ $$=(char*) Lex->tok_start; }

remember_end:
	{ $$=(char*) Lex->tok_end; }

select_item2:
	table_wild	{ $$=$1; } /* table.* */
	| expr		{ $$=$1; }

select_alias:
	{ $$.str=0;}
	| AS ident { $$=$2; }
	| AS TEXT_STRING  { $$=$2; }
	| ident { $$=$1; }
	| TEXT_STRING  { $$=$1; }

/* all possible expressions */
expr:	expr_expr	{$$ = $1; }
	| simple_expr	{$$ = $1; }

/* expressions that begin with 'expr' */
expr_expr:
	expr IN_SYM '(' expr_list ')'
	  { $$= new Item_func_in($1,*$4); }
	| expr NOT IN_SYM '(' expr_list ')'
	  { $$= new Item_func_not(new Item_func_in($1,*$5)); }
	| expr BETWEEN_SYM no_and_expr AND expr
	  { $$= new Item_func_between($1,$3,$5); }
	| expr NOT BETWEEN_SYM no_and_expr AND expr
	  { $$= new Item_func_not(new Item_func_between($1,$4,$6)); }
	| expr OR expr		{ $$= new Item_cond_or($1,$3); }
	| expr AND expr		{ $$= new Item_cond_and($1,$3); }
	| expr LIKE simple_expr opt_escape { $$= new Item_func_like($1,$3,$4); }
	| expr NOT LIKE simple_expr opt_escape	{ $$= new Item_func_not(new Item_func_like($1,$4,$5));}
	| expr REGEXP expr { $$= new Item_func_regex($1,$3); }
	| expr NOT REGEXP expr { $$= new Item_func_not(new Item_func_regex($1,$4)); }
	| expr IS NULL_SYM	{ $$= new Item_func_isnull($1); }
	| expr IS NOT NULL_SYM { $$= new Item_func_isnotnull($1); }
	| expr EQ expr		{ $$= new Item_func_eq($1,$3); }
	| expr GE expr		{ $$= new Item_func_ge($1,$3); }
	| expr GT_SYM expr	{ $$= new Item_func_gt($1,$3); }
	| expr LE expr		{ $$= new Item_func_le($1,$3); }
	| expr LT expr		{ $$= new Item_func_lt($1,$3); }
	| expr NE expr		{ $$= new Item_func_ne($1,$3); }
	| expr SHIFT_LEFT expr	{ $$= new Item_func_shift_left($1,$3); }
	| expr SHIFT_RIGHT expr { $$= new Item_func_shift_right($1,$3); }
	| expr '+' expr		{ $$= new Item_func_plus($1,$3); }
	| expr '-' expr		{ $$= new Item_func_minus($1,$3); }
	| expr '*' expr		{ $$= new Item_func_mul($1,$3); }
	| expr '/' expr		{ $$= new Item_func_div($1,$3); }
	| expr '|' expr		{ $$= new Item_func_bit_or($1,$3); }
	| expr '&' expr		{ $$= new Item_func_bit_and($1,$3); }
	| expr '%' expr		{ $$= new Item_func_mod($1,$3); }

/* expressions that begin with 'expr' that do NOT follow IN_SYM */
no_in_expr:
	no_in_expr BETWEEN_SYM no_and_expr AND expr
	  { $$= new Item_func_between($1,$3,$5); }
	| no_in_expr NOT BETWEEN_SYM no_and_expr AND expr
	  { $$= new Item_func_not(new Item_func_between($1,$4,$6)); }
	| no_in_expr OR expr		{ $$= new Item_cond_or($1,$3); }
	| no_in_expr AND expr		{ $$= new Item_cond_and($1,$3); }
	| no_in_expr LIKE simple_expr opt_escape { $$= new Item_func_like($1,$3,$4); }
	| no_in_expr NOT LIKE simple_expr opt_escape { $$= new Item_func_not(new Item_func_like($1,$4,$5)); }
	| no_in_expr REGEXP expr { $$= new Item_func_regex($1,$3); }
	| no_in_expr NOT REGEXP expr { $$= new Item_func_not(new Item_func_regex($1,$4)); }
	| no_in_expr IS NULL_SYM	{ $$= new Item_func_isnull($1); }
	| no_in_expr IS NOT NULL_SYM { $$= new Item_func_isnotnull($1); }
	| no_in_expr EQ expr		{ $$= new Item_func_eq($1,$3); }
	| no_in_expr GE expr		{ $$= new Item_func_ge($1,$3); }
	| no_in_expr GT_SYM expr	{ $$= new Item_func_gt($1,$3); }
	| no_in_expr LE expr		{ $$= new Item_func_le($1,$3); }
	| no_in_expr LT expr		{ $$= new Item_func_lt($1,$3); }
	| no_in_expr NE expr		{ $$= new Item_func_ne($1,$3); }
	| no_in_expr SHIFT_LEFT expr  { $$= new Item_func_shift_left($1,$3); }
	| no_in_expr SHIFT_RIGHT expr { $$= new Item_func_shift_right($1,$3); }
	| no_in_expr '+' expr		{ $$= new Item_func_plus($1,$3); }
	| no_in_expr '-' expr		{ $$= new Item_func_minus($1,$3); }
	| no_in_expr '*' expr		{ $$= new Item_func_mul($1,$3); }
	| no_in_expr '/' expr		{ $$= new Item_func_div($1,$3); }
	| no_in_expr '|' expr		{ $$= new Item_func_bit_or($1,$3); }
	| no_in_expr '&' expr		{ $$= new Item_func_bit_and($1,$3); }
	| no_in_expr '%' expr		{ $$= new Item_func_mod($1,$3); }
	| simple_expr

/* expressions that begin with 'expr' that does NOT follow AND */
no_and_expr:
	no_and_expr IN_SYM '(' expr_list ')'
	{ $$= new Item_func_in($1,*$4); }
	| no_and_expr NOT IN_SYM '(' expr_list ')'
	  { $$= new Item_func_not(new Item_func_in($1,*$5)); }
	| no_and_expr BETWEEN_SYM no_and_expr AND expr
	  { $$= new Item_func_between($1,$3,$5); }
	| no_and_expr NOT BETWEEN_SYM no_and_expr AND expr
	  { $$= new Item_func_not(new Item_func_between($1,$4,$6)); }
	| no_and_expr OR expr		{ $$= new Item_cond_or($1,$3); }
	| no_and_expr LIKE simple_expr opt_escape { $$= new Item_func_like($1,$3,$4); }
	| no_and_expr NOT LIKE simple_expr opt_escape	{ $$= new Item_func_not(new Item_func_like($1,$4,$5)); }
	| no_and_expr REGEXP expr { $$= new Item_func_regex($1,$3); }
	| no_and_expr NOT REGEXP expr { $$= new Item_func_not(new Item_func_regex($1,$4)); }
	| no_and_expr IS NULL_SYM	{ $$= new Item_func_isnull($1); }
	| no_and_expr IS NOT NULL_SYM { $$= new Item_func_isnotnull($1); }
	| no_and_expr EQ expr		{ $$= new Item_func_eq($1,$3); }
	| no_and_expr GE expr		{ $$= new Item_func_ge($1,$3); }
	| no_and_expr GT_SYM expr	{ $$= new Item_func_gt($1,$3); }
	| no_and_expr LE expr		{ $$= new Item_func_le($1,$3); }
	| no_and_expr LT expr		{ $$= new Item_func_lt($1,$3); }
	| no_and_expr NE expr		{ $$= new Item_func_ne($1,$3); }
	| no_and_expr SHIFT_LEFT expr  { $$= new Item_func_shift_left($1,$3); }
	| no_and_expr SHIFT_RIGHT expr { $$= new Item_func_shift_right($1,$3); }
	| no_and_expr '+' expr		{ $$= new Item_func_plus($1,$3); }
	| no_and_expr '-' expr		{ $$= new Item_func_minus($1,$3); }
	| no_and_expr '*' expr		{ $$= new Item_func_mul($1,$3); }
	| no_and_expr '/' expr		{ $$= new Item_func_div($1,$3); }
	| no_and_expr '|' expr		{ $$= new Item_func_bit_or($1,$3); }
	| no_and_expr '&' expr		{ $$= new Item_func_bit_and($1,$3); }
	| no_and_expr '%' expr		{ $$= new Item_func_mod($1,$3); }
	| simple_expr

simple_expr:
	simple_ident
	| literal
	| sum_expr
	| '-' expr %prec NEG	{ $$= new Item_func_neg($2); }
	| NOT expr %prec NEG	{ $$= new Item_func_not($2); }
	| '!' expr %prec NEG	{ $$= new Item_func_not($2); }
	| '(' expr ')'		{ $$= $2; }
	| '{' ident expr '}'	{ $$= $3; }
	| ABS '(' expr ')'	{ $$= new Item_func_abs($3); }
	| ACOS	'(' expr ')'
	  { $$= new Item_func_acos($3); }
	| ASCII '(' expr ')'
	  { $$= new Item_func_ascii($3); }
	| ASIN	'(' expr ')'
	  { $$= new Item_func_asin($3); }
	| ATAN	'(' expr ')'
	  { $$= new Item_func_atan($3); }
	| ATAN	'(' expr ',' expr ')'
	  { $$= new Item_func_atan($3,$5); }
	| BIN '(' expr ')'
	  { $$= new Item_func_conv($3,new Item_int((int32) 10,2),
				      new Item_int((int32) 2,1)); }
	| BIT_COUNT '(' expr ')' { $$=new Item_func_bit_count($3); }
	| CEILING '(' expr ')'	{ $$= new Item_func_ceiling($3); }
	| CHAR_SYM '(' expr_list ')'
	  { $$= new Item_func_char(*$3); }
	| CONCAT '(' expr_list ')'
	  { $$= new Item_func_concat(* $3); }
	| CONV '(' expr ',' expr ',' expr ')'
	  { $$= new Item_func_conv($3,$5,$7); }
	| COS  '(' expr ')'
	  { $$= new Item_func_cos($3); }
	| COT  '(' expr ')'
	  { $$= new Item_func_div(new Item_int("1",1,1),
				  new Item_func_tan($3)); }
	| CURDATE
	  { $$= new Item_func_curdate(); }
	| CURDATE '(' ')'
	  { $$= new Item_func_curdate(); }
	| CURTIME
	  { $$= new Item_func_curtime(); }
	| CURTIME '(' ')'
	  { $$= new Item_func_curtime(); }
	| CURTIME '(' expr ')'
	  { $$= new Item_func_curtime($3); }
	| DATABASE '(' ')'
	  { $$= new Item_func_database(); }
	| DATE_ADD_INTERVAL '(' expr ',' INTERVAL_SYM expr interval ')'
	  { $$= new Item_date_add_interval($3,$6,$7,0); }
	| DATE_FORMAT_SYM '(' expr ',' expr ')'
	  { $$=new Item_func_date_format($3,$5,0); }
	| DATE_SUB_INTERVAL '(' expr ',' INTERVAL_SYM expr interval ')'
	  { $$= new Item_date_add_interval($3,$6,$7,1); }
	| DAY_OF_MONTH '(' expr ')'
	  { $$= new Item_func_dayofmonth($3); }
	| DAY_OF_WEEK '(' expr ')'
	  { $$= new Item_func_weekday(new Item_func_to_days($3),1); }
	| DAY_OF_YEAR '(' expr ')'
	  { $$= new Item_func_dayofyear($3); }
	| DAYNAME '(' expr ')'
	  { $$= new Item_func_dayname(new Item_func_to_days($3)); }
	| DEGREES '(' expr ')'
	  { $$= new Item_func_units("degrees",$3,180/M_PI,0.0); }
	| ELT_FUNC '(' expr ',' expr_list ')'
	  { $$= new Item_func_elt($3, *$5); }
	| MAKE_SET_SYM '(' expr ',' expr_list ')'
	  { $$= new Item_func_make_set($3, *$5); }
	| ENCRYPT '(' expr ')' 		  { $$= new Item_func_encrypt($3); }
	| ENCRYPT '(' expr ',' expr ')'   { $$= new Item_func_encrypt($3,$5); }
	| DECODE_SYM '(' expr ',' TEXT_STRING ')'
	  { $$= new Item_func_decode($3,$5.str); }
	| ENCODE_SYM '(' expr ',' TEXT_STRING ')'
	 { $$= new Item_func_encode($3,$5.str); }
	| EXP '(' expr ')'	{ $$= new Item_func_exp($3); }
	| FIELD_FUNC '(' expr ',' expr_list ')'
	  { $$= new Item_func_field($3, *$5); }
	| FIND_IN_SET '(' expr ',' expr ')'
	  { $$= new Item_func_find_in_set($3, $5); }
	| FLOOR '(' expr ')'	{ $$= new Item_func_floor($3); }
	| FORMAT '(' expr ',' NUM ')'
	  { $$= new Item_func_format($3,atoi($5.str)); }
	| FROM_DAYS '(' expr ')'
	  { $$= new Item_func_from_days($3); }
	| FROM_UNIXTIME '(' expr ')'
	  { $$= new Item_func_from_unixtime($3); }
	| FROM_UNIXTIME '(' expr ',' expr ')'
	  {
	    $$= new Item_func_date_format(new Item_func_from_unixtime($3),$5,0);
	  }
	| GET_LOCK '(' expr ',' expr ')'
	  { $$= new Item_func_get_lock($3, $5);}
	| HEX '(' expr ')'
	  { $$= new Item_func_conv($3,new Item_int((int32) 10,2),
				      new Item_int((int32) 16,2)); }
	| HOUR_SYM '(' expr ')'
	  { $$= new Item_func_hour($3); }
	| IF '(' expr ',' expr ',' expr ')'
	  { $$= new Item_func_if($3,$5,$7); }
	| IFNULL '(' expr ',' expr ')'
	  { $$= new Item_func_ifnull($3,$5); }
	| INSERT '(' expr ',' expr ',' expr ',' expr ')'
	  { $$= new Item_func_insert($3,$5,$7,$9); }
	| INSTR '(' expr ',' expr ')'
	  { $$= new Item_func_locate($3,$5); }
	| INTERVAL_SYM '(' expr ',' expr_list ')'
	  { $$= new Item_func_interval($3,* $5); }
	| ISNULL '(' expr ')'
	  { $$= new Item_func_isnull($3); }
	| LAST_INSERT_ID '(' ')'
	  {
	    $$= new Item_int("last_insert_id()",
			     current_thd->insert_id(),21);
	  }
	| LAST_INSERT_ID '(' expr ')'
	  {
	    $$= new Item_func_set_last_insert_id($3);
	  }
	| LCASE '(' expr ')'	  { $$= new Item_func_lcase($3); }
	| LEFT '(' expr ',' expr ')'
	  { $$= new Item_func_left($3,$5); }
	| LENGTH '(' expr ')' 	  { $$= new Item_func_length($3); }
	| LOCATE '(' expr ',' expr ')'
	  { $$= new Item_func_locate($5,$3); }
	| LOCATE '(' expr ',' expr ',' expr ')'
	  { $$= new Item_func_locate($5,$3,$7); }
	| LOG '(' expr ')'	{ $$= new Item_func_log($3); }
	| LOG10 '(' expr ')'	{ $$= new Item_func_log10($3); }
	| LPAD '(' expr ',' expr ',' expr ')'
	 { $$= new Item_func_lpad($3,$5,$7); }
	| LTRIM '(' expr ')'
	  { $$= new Item_func_ltrim($3,new Item_string(" ",1)); }
	| GREATEST_SYM '(' expr ',' expr_list ')'
	  { $5->push_front($3); $$= new Item_func_max(*$5); }
	| LEAST_SYM '(' expr ',' expr_list ')'
	  { $5->push_front($3); $$= new Item_func_min(*$5); }
	| MINUTE_SYM '(' expr ')'
	  { $$= new Item_func_minute($3); }
	| MOD_SYM '(' expr ',' expr ')'
	  { $$= new Item_func_mod($3,$5); }
	| MONTH_NAME_SYM '(' expr ')'
	  { $$= new Item_func_monthname($3); }
	| MONTH_SYM '(' expr ')'
	  { $$= new Item_func_month($3); }
	| NOW_SYM
	  { $$= new Item_func_now(); }
	| NOW_SYM '(' ')'
	  { $$= new Item_func_now(); }
	| NOW_SYM '(' expr ')'
	  { $$= new Item_func_now($3); }
	| OCT '(' expr ')'
	  { $$= new Item_func_conv($3,new Item_int((int32) 10,2),
				      new Item_int((int32) 8,1)); }
	| PASSWORD '(' expr ')' 	  { $$= new Item_func_password($3); }
	| PERIOD_ADD '(' expr ',' expr ')'
	  { $$= new Item_func_period_add($3,$5); }
	| PERIOD_DIFF '(' expr ',' expr ')'
	  { $$= new Item_func_period_diff($3,$5); }
	| PI_SYM '(' ')'
	  { $$= new Item_real("PI()",M_PI,6,8); }
	| POSITION_SYM '(' no_in_expr IN_SYM expr ')'
	  { $$ = new Item_func_locate($5,$3); }
	| POW '(' expr ',' expr ')'
	  { $$= new Item_func_pow($3,$5); }
	| QUARTER '(' expr ')'
	  { $$= new Item_func_quarter($3); }
	| RADIANS '(' expr ')'
	  { $$= new Item_func_units("radians",$3,M_PI/180,0.0); }
	| RAND '(' expr ')'	{ $$= new Item_func_rand($3); }
	| RAND '(' ')'		{ $$= new Item_func_rand(); }
	| RELEASE_LOCK '(' expr ')'
	  {
	     $$= new Item_func_release_lock($3);
	  }
	| REPEAT '(' expr ',' expr ')'
	  { $$= new Item_func_repeat($3,$5); }
	| REPLACE '(' expr ',' expr ',' expr ')'
	  { $$= new Item_func_replace($3,$5,$7); }
	| REVERSE '(' expr ')'  { $$= new Item_func_reverse($3); }
	| RIGHT '(' expr ',' expr ')'
	  { $$= new Item_func_right($3,$5); }
	| ROUND '(' expr ')'
	  { $$= new Item_func_round($3, new Item_int("0",0,1),0); }
	| ROUND '(' expr ',' expr ')' { $$= new Item_func_round($3,$5,0); }
	| RPAD '(' expr ',' expr ',' expr ')'
	 { $$= new Item_func_rpad($3,$5,$7); }
	| RTRIM '(' expr ')'
	  { $$= new Item_func_rtrim($3,new Item_string(" ",1)); }
	| SEC_TO_TIME '(' expr ')'
	  { $$= new Item_func_sec_to_time($3); }
	| SECOND_SYM '(' expr ')'
	  { $$= new Item_func_second($3); }
	| SIGN '(' expr ')'	{ $$= new Item_func_sign($3); }
	| SIN  '(' expr ')'
	  { $$= new Item_func_sin($3); }
	| SPACE '(' expr ')'
	  { $$= new Item_func_repeat(new Item_string(" ",1),$3); }
	| SOUNDEX '(' expr ')'
	  { $$= new Item_func_soundex($3); }
	| SQRT '(' expr ')'	{ $$= new Item_func_sqrt($3); }
	| STRCMP '(' expr ',' expr ')'
	  { $$= new Item_func_strcmp($3,$5); }
	| SUBSTRING '(' expr ',' expr ',' expr ')'
	  { $$= new Item_func_substr($3,$5,$7); }
	| SUBSTRING '(' expr ',' expr ')'
	  { $$= new Item_func_substr($3,$5); }
	| SUBSTRING '(' expr FROM expr FOR_SYM expr ')'
	  { $$= new Item_func_substr($3,$5,$7); }
	| SUBSTRING '(' expr FROM expr ')'
	  { $$= new Item_func_substr($3,$5); }
	| SUBSTRING_INDEX '(' expr ',' expr ',' expr ')'
	  { $$= new Item_func_substr_index($3,$5,$7); }
	| TAN  '(' expr ')'
	  { $$= new Item_func_tan($3); }
	| TIME_FORMAT_SYM '(' expr ',' expr ')'
	  { $$=new Item_func_date_format($3,$5,1); }
	| TIME_TO_SEC '(' expr ')'
	  { $$= new Item_func_time_to_sec($3); }
	| TO_DAYS '(' expr ')'
	  { $$= new Item_func_to_days($3); }
	| TRIM '(' expr ')'
	  { $$= new Item_func_trim($3,new Item_string(" ",1)); }
	| TRIM '(' LEADING opt_pad FROM expr ')'
	  { $$= new Item_func_ltrim($6,$4); }
	| TRIM '(' TRAILING opt_pad FROM expr ')'
	  { $$= new Item_func_rtrim($6,$4); }
	| TRIM '(' BOTH opt_pad FROM expr ')'
	  { $$= new Item_func_trim($6,$4); }
	| TRIM '(' expr FROM expr ')'
	  { $$= new Item_func_trim($5,$3); }
	| TRUNCATE '(' expr ',' expr ')' { $$= new Item_func_round($3,$5,1); }
	| UCASE '(' expr ')'	  { $$= new Item_func_ucase($3); }
	| UDF_CHAR_FUNC '(' udf_expr_list ')'
	  {
	    if ($3 != NULL)
	      $$ = new Item_func_udf_str($1, *$3);
	    else
	      $$ = new Item_func_udf_str($1);
	  }
	| UDF_FLOAT_FUNC '(' udf_expr_list ')'
	  {
	    if ($3 != NULL)
	      $$ = new Item_func_udf_float($1, *$3);
	    else
	      $$ = new Item_func_udf_float($1);
	  }
	| UDF_INT_FUNC '(' udf_expr_list ')'
	  {
	    if ($3 != NULL)
	      $$ = new Item_func_udf_int($1, *$3);
	    else
	      $$ = new Item_func_udf_int($1);
	  }
	| UNIQUE_USERS '(' text_literal ',' NUM ',' NUM ',' expr_list ')'
	  { $$= new Item_func_unique_users($3,atoi($5.str),atoi($7.str), * $9); }
	| UNIX_TIMESTAMP '(' ')'
	  { $$= new Item_func_unix_timestamp(); }
	| UNIX_TIMESTAMP '(' expr ')'
	  { $$= new Item_func_unix_timestamp($3); }
	| USER '(' ')'
	  { $$= new Item_func_user(); }
	| VERSION_SYM '(' ')'
	  { $$= new Item_string("version()",server_version,
				strlen(server_version)); }
	| WEEK_SYM '(' expr ')'
	  { $$= new Item_func_week($3,new Item_int("0",0,1)); }
	| WEEK_SYM '(' expr ',' expr ')'
	  { $$= new Item_func_week($3,$5); }
	| WEEKDAY '(' expr ')'
	  { $$= new Item_func_weekday(new Item_func_to_days($3),0); }
	| YEAR_SYM '(' expr ')'
	  { $$= new Item_func_year($3); }
	| BENCHMARK_SYM '(' ULONG_NUM ',' expr ')'
	  { $$=new Item_func_benchmark($3,$5); }

udf_expr_list:
	/* empty */	{ $$= NULL; }
	| expr_list	{ $$= $1;}

sum_expr:
	AVG_SYM '(' in_sum_expr ')'
	  { $$=new Item_sum_avg($3); }
	| BIT_AND  '(' in_sum_expr ')'
	  { $$=new Item_sum_and($3); }
	| BIT_OR  '(' in_sum_expr ')'
	  { $$=new Item_sum_or($3); }
	| COUNT_SYM '(' '*' ')'
	  { $$=new Item_sum_count(new Item_int((int32) 0L,1)); }
	| COUNT_SYM '(' in_sum_expr ')'
	  { $$=new Item_sum_count($3); }
	| GROUP_UNIQUE_USERS '(' text_literal ',' NUM ',' NUM ',' in_sum_expr ')'
	  { $$= new Item_sum_unique_users($3,atoi($5.str),atoi($7.str),$9); }
	| MIN_SYM '(' in_sum_expr ')'
	  { $$=new Item_sum_min($3); }
	| MAX_SYM '(' in_sum_expr ')'
	  { $$=new Item_sum_max($3); }
	| STD_SYM '(' in_sum_expr ')'
	  { $$=new Item_sum_std($3); }
	| SUM_SYM '(' in_sum_expr ')'
	  { $$=new Item_sum_sum($3); }

in_sum_expr:
	{ Lex->in_sum_expr++ }
	expr
	{
	  Lex->in_sum_expr--;
	  $$=$2;
	}

expr_list:
	{ Lex->expr_list.push_front(new List<Item>); }
	expr_list2
	{ $$= Lex->expr_list.pop(); }

expr_list2:
	expr { Lex->expr_list.head()->push_back($1); }
	| expr_list2 ',' expr { Lex->expr_list.head()->push_back($3); }

opt_pad:
	/* empty */ { $$=new Item_string(" ",1); }
	| expr	    { $$=$1; }

join_table_list:
	'(' join_table_list ')'	{ $$=$2; }
	| join_table		{ $$=$1; }
	| join_table_list ',' join_table { $$=$3 }
	| join_table_list JOIN_SYM join_table { $$=$3 }
	| join_table_list STRAIGHT_JOIN join_table { $$=$3 ; $$->straight=1; }
	| join_table_list CROSS JOIN_SYM join_table { $$=$4 }
	| join_table_list LEFT opt_outer JOIN_SYM join_table ON expr
	  { add_left_join_on($1,$5,$7); $$=$5; }
	| join_table_list LEFT opt_outer JOIN_SYM join_table
	  { Lex->db1=$1->db; Lex->table1=$1->name;
	    Lex->db2=$5->db; Lex->table2=$5->name; }
	  USING '(' using_list ')'
	  { add_left_join_on($1,$5,$9); $$=$5; }
	| join_table_list NATURAL LEFT opt_outer JOIN_SYM join_table
	  { add_left_join_natural($1,$6); $$=$6; }

join_table:
	table_ident opt_table_alias
	  { if (!($$=add_table_to_list($1,$2))) YYABORT; }
	| '{' ident join_table LEFT OUTER JOIN_SYM join_table ON expr '}'
	  { add_left_join_on($3,$7,$9); $$=$7; }

opt_outer:
	/* empty */	{}
	| OUTER		{}

using_list:
	ident
	  { if (!($$= new Item_func_eq(new Item_field(Lex->db1,Lex->table1, $1.str), new Item_field(Lex->db2,Lex->table2,$1.str))))
	      YYABORT;
	  }
	| using_list ',' ident
	  {
	    if (!($$= new Item_cond_and(new Item_func_eq(new Item_field(Lex->db1,Lex->table1,$3.str), new Item_field(Lex->db2,Lex->table2,$3.str)), $1)))
	      YYABORT;
	  }

interval:
	 DAY_HOUR_SYM		{ $$=INTERVAL_DAY_HOUR; }
	| DAY_MINUTE_SYM	{ $$=INTERVAL_DAY_MINUTE; }
	| DAY_SECOND_SYM	{ $$=INTERVAL_DAY_SECOND; }
	| DAY_SYM		{ $$=INTERVAL_DAY; }
	| HOUR_MINUTE_SYM	{ $$=INTERVAL_HOUR_MINUTE; }
	| HOUR_SECOND_SYM	{ $$=INTERVAL_HOUR_SECOND; }
	| HOUR_SYM		{ $$=INTERVAL_HOUR; }
	| MINUTE_SECOND_SYM	{ $$=INTERVAL_MINUTE_SECOND; }
	| MINUTE_SYM		{ $$=INTERVAL_MINUTE; }
	| MONTH_SYM		{ $$=INTERVAL_MONTH; }
	| SECOND_SYM		{ $$=INTERVAL_SECOND; }
	| YEAR_MONTH_SYM	{ $$=INTERVAL_YEAR_MONTH; }
	| YEAR_SYM		{ $$=INTERVAL_YEAR; }

table_alias:
	/* empty */
	| AS
	| EQ

opt_table_alias:
	/* empty */		{ $$=0; }
	| table_alias ident
	  { $$= (LEX_STRING*) sql_memdup(&$2,sizeof(LEX_STRING)); }


where_clause:
	/* empty */  { Lex->where= 0; }
	| WHERE expr { Lex->where= $2; }

having_clause:
	/* empty */
	| HAVING { Lex->create_refs=1; } expr
	{ Lex->having= $3; Lex->create_refs=0; }

opt_escape:
	ESCAPE_SYM TEXT_STRING	{ $$= $2.str; }
	| /* empty */		{ $$= "\\"; }


/*
** group by statement in select
*/

group_clause:
	/* empty */
	| GROUP BY group_list

group_list:
	group_list ',' group_ident order_dir
		{ if (add_group_to_list($3,(bool) $4)) YYABORT; }
	| group_ident order_dir
		{ if (add_group_to_list($1,(bool) $2)) YYABORT; }

/*
** Order by statement in select
*/

order_clause:
	/* empty */
	| ORDER_SYM BY order_list

order_list:
	order_list ',' order_ident order_dir
	  { if (add_order_to_list($3,(bool) $4)) YYABORT; }
	| order_ident order_dir
	  { if (add_order_to_list($1,(bool) $2)) YYABORT; }

order_dir:
	/* empty */ { $$ =  1; }
	| ASC  { $$ =  1; }
	| DESC { $$ =  0; }


limit_clause:
	/* empty */
	{
	  Lex->select_limit= current_thd->default_select_limit;
	  Lex->offset_limit= 0L;
	}
	| LIMIT ULONG_NUM
	  { Lex->select_limit= $2; Lex->offset_limit=0L; }
	| LIMIT ULONG_NUM ',' ULONG_NUM
	  { Lex->select_limit= $4; Lex->offset_limit=$2; }

delete_limit_clause:
	/* empty */
	{
	  Lex->select_limit= HA_POS_ERROR;
	}
	| LIMIT ULONGLONG_NUM
	{ Lex->select_limit= (ha_rows) $2; }

ULONG_NUM:
	NUM { $$= strtoul($1.str,NULL,10); }
	| REAL_NUM { $$= strtoul($1.str,NULL,10); }

ULONGLONG_NUM:
	NUM	   { $$= (ulonglong) strtoul($1.str,NULL,10); }
	| LONG_NUM { $$= strtoull($1.str,NULL,10); }
	| REAL_NUM { $$= strtoull($1.str,NULL,10); }

procedure_clause:
	/* empty */
	| PROCEDURE ident			/* Procedure name */
	  {
	    THD *thd=current_thd;
	    thd->proc_list.elements=0;
	    thd->proc_list.first=0;
	    thd->proc_list.next= (byte**) &thd->proc_list.first;
	    if (add_proc_to_list(new Item_field(NULL,NULL,$2.str)))
	      YYABORT;
	  }
	  '(' procedure_list ')'


procedure_list:
	procedure_list ',' procedure_item
	| procedure_item

procedure_item:
	  remember_name expr
	  {
	    if (add_proc_to_list($2))
	      YYABORT;
	    if (!$2->name)
	      $2->set_name($1,(uint) ((char*) Lex->tok_end - $1));
	  }

opt_into:
	INTO OUTFILE TEXT_STRING
	{
	  if (!(Lex->exchange= new sql_exchange($3.str)))
	    YYABORT;
	}
	opt_field_term opt_line_term

/*
** Drop : delete tables or index
*/

drop:
	DROP TABLE_SYM if_exists table_list
	{
	  Lex->sql_command = SQLCOM_DROP_TABLE;
	  Lex->drop_if_exists = $3;
	}
	| DROP INDEX ident ON table_ident {}
	  {
	     Lex->sql_command= SQLCOM_DROP_INDEX;
	     Lex->drop_list.empty();
	     Lex->drop_list.push_back(new Alter_drop(Alter_drop::KEY,
						     $3.str));
	     if (!add_table_to_list($5,NULL))
	      YYABORT;
	  }
	| DROP DATABASE if_exists ident
	  {
	    Lex->sql_command= SQLCOM_DROP_DB;
	    Lex->drop_if_exists=$3;
	    Lex->name=$4.str;
	 }
	| DROP UDF_SYM ident
	  {
	    Lex->sql_command = SQLCOM_DROP_FUNCTION;
	    Lex->udf.name=$3.str;
	  }


table_list:
	table
	| table_list ',' table

table:
	table_ident
	{ if (!add_table_to_list($1,NULL)) YYABORT; }

if_exists:
	/* empty */ { $$=0; }
	| IF EXISTS { $$= 1; }

/*
** Insert : add new data to table
*/

insert:
	INSERT { Lex->sql_command = SQLCOM_INSERT; } insert_lock_option opt_ignore insert2 insert_field_spec

replace:
	REPLACE { Lex->sql_command = SQLCOM_REPLACE; } insert_lock_option insert2 insert_field_spec


insert_lock_option:
	/* empty */	{ Lex->lock_option= current_thd->update_lock_default; }
	| LOW_PRIORITY	{ Lex->lock_option= TL_WRITE_LOW_PRIORITY; }
	| DELAYED_SYM	{ Lex->lock_option= TL_WRITE_DELAYED; }

insert2:
	INTO insert_table {}
	| insert_table {}

insert_table:
	table
	{
	  current_thd->field_list.empty();
	  Lex->many_values.empty();
	  Lex->insert_list=0;
	}

insert_field_spec:
	opt_field_spec insert_values {}
	| SET
	  {
	    if (!(Lex->insert_list = new List_item) ||
		Lex->many_values.push_back(Lex->insert_list))
	      YYABORT;
	   }
	   ident_eq_list

opt_field_spec:
	/* empty */	  { }
	| '(' fields ')'  { }

fields:
	fields ',' insert_ident { current_thd->field_list.push_back($3); }
	| insert_ident		{ current_thd->field_list.push_back($1); }

insert_values:
	VALUES	values_list  {}
	| SELECT_SYM
	  {
	    LEX *lex=Lex;
	    lex->where=lex->having=0;
	    lex->select_limit=current_thd->default_select_limit;
	    lex->offset_limit=0L;
	    lex->options=0;
	    lex->sql_command = (lex->sql_command == SQLCOM_INSERT ?
				SQLCOM_INSERT_SELECT : SQLCOM_REPLACE_SELECT);
	  }
	  select_options select_item_list select_from {}

values_list:
	values_list ','  no_braces
	| no_braces

ident_eq_list:
	ident_eq_list ',' ident_eq_value
	|
	ident_eq_value

ident_eq_value:
	simple_ident EQ expr
	 {
	  if (current_thd->field_list.push_back($1) ||
	      Lex->insert_list->push_back($3))
	    YYABORT;
	 }

no_braces:
	 '('
	 {
	    if (!(Lex->insert_list = new List_item))
	      YYABORT;
	 }
	 values ')'
	 {
	  if (Lex->many_values.push_back(Lex->insert_list))
	    YYABORT;
	 }

values:
	values ','  expr
	{
	  if (Lex->insert_list->push_back($3))
	    YYABORT;
	}
	| expr
	{
	  if (Lex->insert_list->push_back($1))
	    YYABORT;
	}

/* Update rows in a table */

update:
	UPDATE_SYM opt_low_priority table SET update_list where_clause
	{ Lex->sql_command = SQLCOM_UPDATE; }

update_list:
	update_list ',' simple_ident EQ expr
	{
	  if (add_item_to_list($3) || add_value_to_list($5))
	    YYABORT;
	}
	| simple_ident EQ expr
	  {
	    if (add_item_to_list($1) || add_value_to_list($3))
	      YYABORT;
	  }

opt_low_priority:
	/* empty */	{ Lex->lock_option= current_thd->update_lock_default; }
	| LOW_PRIORITY	{ Lex->lock_option= TL_WRITE_LOW_PRIORITY; }

/* Delete rows from a table */

delete:
	DELETE_SYM opt_low_priority FROM table where_clause delete_limit_clause
	{ Lex->sql_command= SQLCOM_DELETE; }


/* Show things */

show:	SHOW { Lex->wild=0;} show_param

show_param:
	DATABASES wild
	  { Lex->sql_command= SQLCOM_SHOW_DATABASES; }
	| TABLES opt_db wild
	  { Lex->sql_command= SQLCOM_SHOW_TABLES; Lex->db= $2; }
	| COLUMNS FROM table_ident opt_db wild
	  {
	    Lex->sql_command= SQLCOM_SHOW_FIELDS;
	    if ($4)
	      $3->change_db($4);
	    if (!add_table_to_list($3,NULL))
	      YYABORT;
	  }
	| keys_or_index FROM table_ident opt_db
	  {
	    Lex->sql_command= SQLCOM_SHOW_KEYS;
	    if ($4)
	      $3->change_db($4);
	    if (!add_table_to_list($3,NULL))
	      YYABORT;
	  }
	| STATUS_SYM
	  { Lex->sql_command= SQLCOM_SHOW_STATUS; }
	| PROCESSLIST_SYM
	  { Lex->sql_command= SQLCOM_SHOW_PROCESSLIST; }
	| VARIABLES wild
	  { Lex->sql_command= SQLCOM_SHOW_VARIABLES; }

opt_db:
	/* empty */  { $$= 0; }
	| FROM ident { $$= $2.str; }

wild:
	/* empty */
	| LIKE text_string { Lex->wild= $2; }

/* A Oracle compatible synonym for show */
describe:
	describe_command table_ident
	{
	  Lex->wild=0;
	  Lex->sql_command=SQLCOM_SHOW_FIELDS;
	  if (!add_table_to_list($2, NULL))
	    YYABORT;
	}
	opt_describe_column
	| describe_command select { Lex->options|= SELECT_DESCRIBE };


describe_command:
	DESC
	| DESCRIBE

opt_describe_column:
	/* empty */	{}
	| text_string	{ Lex->wild= $1; }
	| ident		{ Lex->wild= new String((const char*) $1.str,$1.length); }


/* flush things */

flush:
	FLUSH_SYM {Lex->sql_command= SQLCOM_FLUSH; Lex->type=0; } flush_options

flush_options:
	flush_options ',' flush_option
	| flush_option

flush_option:
	TABLES		{ Lex->type|= REFRESH_TABLES; }
	| HOSTS_SYM	{ Lex->type|= REFRESH_HOSTS; }
	| PRIVILEGES	{ Lex->type|= REFRESH_GRANT; }
	| LOGS_SYM	{ Lex->type|= REFRESH_LOG; }
	| STATUS_SYM	{ Lex->type|= REFRESH_STATUS; }


/* kill threads */

kill:
	KILL_SYM NUM
	{
	  Lex->sql_command=SQLCOM_KILL;
	  Lex->thread_id= (ulong) strtoul($2.str,NULL,10);
	}

/* change database */

use:	USE_SYM ident
	{ Lex->sql_command=SQLCOM_CHANGE_DB; Lex->db= $2.str; }

/* import, export of files */

load:	LOAD DATA_SYM opt_local INFILE TEXT_STRING
	{
	  Lex->sql_command= SQLCOM_LOAD;
	  Lex->local_file= $3;
	  if (!(Lex->exchange= new sql_exchange($5.str)))
	    YYABORT;
	  current_thd->field_list.empty();
	}
	opt_duplicate INTO TABLE_SYM table_ident opt_field_term opt_line_term
	opt_ignore_lines opt_field_spec
	{
	  if (!add_table_to_list($10,NULL))
	    YYABORT;
	}

opt_local:
	/* empty */	{ $$=0;}
	| LOCAL_SYM	{ $$=1;}

opt_duplicate:
	/* empty */	{ Lex->duplicates=DUP_ERROR; }
	| REPLACE	{ Lex->duplicates=DUP_REPLACE; }
	| IGNORE_SYM	{ Lex->duplicates=DUP_IGNORE; }

opt_field_term:
	/* empty */
	| COLUMNS field_term_list

field_term_list:
	field_term_list field_term
	| field_term

field_term:
	TERMINATED BY text_string { Lex->exchange->field_term= $3;}
	| OPTIONALLY ENCLOSED BY text_string
	  { Lex->exchange->enclosed= $4; Lex->exchange->opt_enclosed=1;}
	| ENCLOSED BY text_string { Lex->exchange->enclosed= $3;}
	| ESCAPED BY text_string  { Lex->exchange->escaped= $3;}

opt_line_term:
	/* empty */
	| LINES line_term_list

line_term_list:
	line_term_list line_term
	| line_term

line_term:
	TERMINATED BY text_string { Lex->exchange->line_term= $3;}
	| STARTING BY text_string { Lex->exchange->line_start= $3;}

opt_ignore_lines:
	/* empty */
	| IGNORE_SYM NUM LINES
	  { Lex->exchange->skip_lines=atol($2.str); }

/* Common definitions */

text_literal:
	TEXT_STRING { $$ = new Item_string($1.str,$1.length); }
	| text_literal TEXT_STRING
	{ ((Item_string*) $1)->append($2.str,$2.length); }

text_string:
	TEXT_STRING	{ $$=  new String($1.str,$1.length); }
	| HEX_NUM
	  {
	    Item *tmp = new Item_varbinary($1.str,$1.length);
	    $$= tmp ? tmp->str((String*) 0) : (String*) 0;
	  }

literal:
	text_literal	{ $$ =	$1; }
	| NUM		{ $$ =	new Item_int((int32) atol($1.str),$1.length); }
	| LONG_NUM	{ $$ =	new Item_int($1.str); }
	| REAL_NUM	{ $$ =	new Item_real($1.str); }
	| NULL_SYM	{ $$ =	new Item_null();
			  Lex->next_state=STATE_OPERATOR_OR_IDENT;}
	| HEX_NUM	{ $$ =	new Item_varbinary($1.str,$1.length)};
	| DATE_SYM text_literal { $$ = $2; }
	| TIME_SYM text_literal { $$ = $2; }
	| TIMESTAMP text_literal { $$ = $2; }

/**********************************************************************
** Createing different items.
**********************************************************************/

insert_ident:
	simple_ident	 { $$=$1; }
	| table_wild	 { $$=$1; }

table_wild:
	ident '.' '*' { $$ = new Item_field(NullS,$1.str,"*"); }
	| ident '.' ident '.' '*'
	{ $$ = new Item_field((current_thd->client_capabilities & CLIENT_NO_SCHEMA ? NullS : $1.str),$3.str,"*"); }

group_ident:
	simple_ident   { $$=$1; }
	| NUM	       { $$ = new Item_int($1.str); }
	| text_literal { $$=$1; }

order_ident:
	simple_ident { $$=$1; }
	| NUM	     { $$ = new Item_int($1.str); }
	| text_literal { $$=$1; }

simple_ident:
	ident
	{ $$ = !Lex->create_refs || Lex->in_sum_expr > 0 ? (Item*) new Item_field(NullS,NullS,$1.str) : (Item*) new Item_ref(NullS,NullS,$1.str); }
	| ident '.' ident
	{ $$ = !Lex->create_refs || Lex->in_sum_expr > 0 ? (Item*) new Item_field(NullS,$1.str,$3.str) : (Item*) new Item_ref(NullS,$1.str,$3.str); }
	| '.' ident '.' ident
	{ $$ = !Lex->create_refs || Lex->in_sum_expr > 0 ? (Item*) new Item_field(NullS,$2.str,$4.str) : (Item*) new Item_ref(NullS,$2.str,$4.str); }
	| ident '.' ident '.' ident
	{ $$ = !Lex->create_refs || Lex->in_sum_expr > 0 ? (Item*) new Item_field((current_thd->client_capabilities & CLIENT_NO_SCHEMA ? NullS :$1.str),$3.str,$5.str) : (Item*) new Item_ref((current_thd->client_capabilities & CLIENT_NO_SCHEMA ? NullS :$1.str),$3.str,$5.str); }


field_ident:
	ident			{ $$=$1;}
	| ident '.' ident	{ $$=$3;}	/* Skipp schema name in create*/
	| '.' ident		{ $$=$2;}	/* For Delphi */

table_ident:
	ident			{ $$=new Table_ident($1); }
	| ident '.' ident	{ $$=new Table_ident($1,$3,0);}
	| '.' ident		{ $$=new Table_ident($2);}	/* For Delphi */

ident:
	IDENT	    { $$=$1; }
	| keyword
	{
	  $$.str=sql_strmake($1.str,$1.length);
	  $$.length=$1.length;
	  if (Lex->next_state != STATE_END)
	    Lex->next_state=STATE_OPERATOR_OR_IDENT;
	}

ident_or_text:
	ident 		{ $$=$1;}
	| TEXT_STRING	{ $$=$1;} 
	| LEX_HOSTNAME	{ $$=$1;}

user:
	ident_or_text
	{
	  if (!($$=(LEX_USER*) sql_alloc(sizeof(st_lex_user))))
	    YYABORT;
	  $$->user = $1; $$->host.str=NullS;
	  }
	| ident_or_text '@' ident_or_text
	  {
	  if (!($$=(LEX_USER*) sql_alloc(sizeof(st_lex_user))))
	      YYABORT;
	    $$->user = $1; $$->host=$3;
	  }

/* Keyword that we allow for identifiers */

keyword:
	TIME_SYM		{}
	| DATE_SYM		{}
	| TIMESTAMP		{}
	| DATETIME		{}
	| TEXT_SYM		{}
	| BIT_SYM		{}
	| ENUM			{}
	| NO_SYM		{}
	| ACTION		{}
	| CHECK_SYM		{}
	| YEAR_SYM		{}
	| MONTH_SYM		{}
	| DAY_SYM		{}
	| HOUR_SYM		{}
	| MINUTE_SYM		{}
	| PROCESSLIST_SYM	{}
	| SECOND_SYM		{}
	| STATUS_SYM		{}
	| VARIABLES		{}
	| UDF_SYM		{}
	| AGGREGATE_SYM		{}
	| STRING_SYM		{}
	| PASSWORD		{}
	| BOOL_SYM		{}
	| AFTER_SYM		{}
	| FIRST_SYM		{}
	| LOCAL_SYM		{}
	| ROW_SYM		{}
	| ROWS_SYM		{}
	| AVG_SYM		{}
	| MAX_SYM		{}
	| TYPE_SYM		{}
	| HEAP_SYM		{}
	| ISAM_SYM		{}
	| MYISAM_SYM		{}
	| ESCAPE_SYM		{}
	| LOGS_SYM		{}
	| HOSTS_SYM		{}
	| FLUSH_SYM		{}
	| RELOAD		{}
	| SHUTDOWN		{}
	| FILE_SYM		{}
	| PROCESS		{}
	| IDENTIFIED_SYM	{}
	| GLOBAL_SYM		{}
	| MODIFY_SYM		{}
	| DELAYED_SYM		{}
	| COMMENT_SYM		{}
	| LENGTH		{}
	| AVG_ROW_LENGTH	{}
	| MAX_ROWS		{}
	| MIN_ROWS		{}
	| DATA_SYM		{}
	| PACK_KEYS_SYM		{}
	| CHECKSUM_SYM		{}

/* Option functions */

set:
	SET opt_option
	{
	  Lex->sql_command= SQLCOM_SET_OPTION;
	  Lex->options=current_thd->options;
	  Lex->select_limit=current_thd->default_select_limit;
	}
	option_value_list

opt_option:
	/* empty */ {}
	| OPTION {}

option_value_list:
	option_value
	| option_value_list ',' option_value

option_value:
	set_option EQ NUM
	{
	  if (atoi($3.str) == 0)
	    Lex->options&= ~$1;
	  else
	    Lex->options|= $1;
	}
	| SQL_SELECT_LIMIT EQ ULONG_NUM
	{
	  Lex->select_limit= $3;
	}
	| SQL_SELECT_LIMIT EQ DEFAULT
	{
	  Lex->select_limit= HA_POS_ERROR;
	}
	| TIMESTAMP EQ ULONG_NUM
	{
	  current_thd->set_time((time_t) $3);
	}
	| TIMESTAMP EQ DEFAULT
	{
	  current_thd->user_time=0;
	}
	| LAST_INSERT_ID EQ ULONGLONG_NUM
	{
	  current_thd->insert_id($3);
	}
	| INSERT_ID EQ ULONGLONG_NUM
	{
	  current_thd->next_insert_id=$3;
	}
	| CHAR_SYM SET IDENT
	{
	  CONVERT *tmp;
	  if (!(tmp=get_convert_set($3.str)))
	  {
	    net_printf(&current_thd->net,ER_UNKNOWN_CHARACTER_SET,$3);
	    YYABORT;
	  }
	  current_thd->convert_set=tmp;
	}
	| CHAR_SYM SET DEFAULT
	{
	  current_thd->convert_set=0;
	}
	| PASSWORD EQ text_or_password
	 {
	   if (change_password(current_thd,current_thd->host,
			       current_thd->priv_user,$3))
	     YYABORT;
	 }
	| PASSWORD FOR_SYM user EQ text_or_password
	 {
	   if (change_password(current_thd,
			       $3->host.str ? $3->host.str : current_thd->host,
			       $3->user.str,$5))
	     YYABORT;
	 }

text_or_password:
	TEXT_STRING { $$=$1.str;}
	| PASSWORD '(' TEXT_STRING ')'
	  {
	    if (!$3.length)
	      $$=$3.str;
	    else
	    {
	      char *buff=sql_alloc(17);
	      make_scrambled_password(buff,$3.str);
	      $$=buff;
	    }
	  }

set_option:
	SQL_BIG_TABLES		{ $$= OPTION_BIG_TABLES; }
	| SQL_BIG_SELECTS	{ $$= OPTION_BIG_SELECTS; }
	| SQL_LOG_OFF		{ $$= OPTION_LOG_OFF; }
	| SQL_LOG_UPDATE	{ $$= OPTION_UPDATE_LOG; }
	| SQL_WARNINGS		{ $$= OPTION_WARNINGS; }
	| SQL_LOW_PRIORITY_UPDATES { $$= OPTION_LOW_PRIORITY_UPDATES; }
	| SQL_AUTO_IS_NULL	{ $$= OPTION_AUTO_IS_NULL; }
	| SQL_SAFE_UPDATES	{ $$= OPTION_SAFE_UPDATES; }

/* Lock function */

lock:
	LOCK_SYM table_or_tables
	{
	  Lex->sql_command=SQLCOM_LOCK_TABLES;
	}
	table_lock_list

table_or_tables:
	TABLE_SYM
	| TABLES

table_lock_list:
	table_lock
	| table_lock_list ',' table_lock

table_lock:
	table_ident opt_table_alias lock_option
	{ if (!add_table_to_list($1,$2,(thr_lock_type) $3)) YYABORT; }

lock_option:
	READ_SYM	{ $$=TL_READ; }
	| WRITE_SYM	{ $$=TL_WRITE; }
	| LOW_PRIORITY WRITE_SYM { $$=TL_WRITE_LOW_PRIORITY; }

unlock:
	UNLOCK_SYM table_or_tables { Lex->sql_command=SQLCOM_UNLOCK_TABLES; }


/* GRANT / REVOKE */

revoke:
	REVOKE
	{
	  Lex->sql_command = SQLCOM_REVOKE;
	  Lex->users_list.empty();
	  Lex->columns.empty();
	  Lex->global_grant = Lex->grant= Lex->grant_tot_col=0;
	  Lex->db=0;
	}
	global_option grant_privileges ON opt_table FROM user_list

grant:
	GRANT
	{
	  Lex->sql_command = SQLCOM_GRANT;
	  Lex->users_list.empty();
	  Lex->columns.empty();
	  Lex->global_grant = Lex->grant= Lex->grant_tot_col=0;
	  Lex->db=0;
	}
	global_option grant_privileges ON opt_table TO_SYM user_list
	grant_option

global_option:
	/* empty */ {Lex->global_grant = 0;}
	| GLOBAL_SYM {Lex->global_grant = 1;}

grant_privileges:
	grant_privilege_list {}
	| ALL PRIVILEGES	{ Lex->grant = UINT_MAX;}
	| ALL			{ Lex->grant = UINT_MAX;}

grant_privilege_list:
	grant_privilege
	| grant_privilege_list ',' grant_privilege

grant_privilege:
	SELECT_SYM
	  { Lex->which_columns = SELECT_ACL;}
	  opt_column_list
	| INSERT
	  { Lex->which_columns = INSERT_ACL; }
	  opt_column_list
	| UPDATE_SYM
	  { Lex->which_columns = UPDATE_ACL; }
	  opt_column_list
	| DELETE_SYM { Lex->grant |= DELETE_ACL;}
	| REFERENCES { Lex->which_columns = REFERENCES_ACL;} opt_column_list
	| USAGE {}
	| INDEX		{ Lex->grant |= INDEX_ACL;}
	| ALTER		{ Lex->grant |= ALTER_ACL;}
	| CREATE	{ Lex->grant |= CREATE_ACL;}
	| DROP		{ Lex->grant |= DROP_ACL;}
	| RELOAD	{ Lex->grant |= RELOAD_ACL;}
	| SHUTDOWN	{ Lex->grant |= SHUTDOWN_ACL;}
	| PROCESS	{ Lex->grant |= PROCESS_ACL;}
	| FILE_SYM	{ Lex->grant |= FILE_ACL;}
	| GRANT OPTION  { Lex->grant |= GRANT_ACL;}

opt_table:
	'*'
	  {
	    Lex->db=current_thd->db;
	    if (Lex->grant == UINT_MAX)
	      Lex->grant = DB_ACLS & ~GRANT_ACL;
	    else if (Lex->columns.elements)
	    {
	       net_printf(&current_thd->net,ER_ILLEGAL_GRANT_FOR_TABLE);
	       YYABORT;
	     }
	  }
	| ident '.' '*'
	  {
	    Lex->db = $1.str;
	    if (Lex->grant == UINT_MAX)
	      Lex->grant = DB_ACLS & ~GRANT_ACL;
	    else if (Lex->columns.elements)
	    {
	      net_printf(&current_thd->net,ER_ILLEGAL_GRANT_FOR_TABLE);
	      YYABORT;
	    }
	  }
	| '*' '.' '*'
	  {
	    Lex->db = NULL;
	    if (Lex->grant == UINT_MAX)
	      Lex->grant = GLOBAL_ACLS & ~GRANT_ACL;
	    else if (Lex->columns.elements)
	    {
	      net_printf(&current_thd->net,ER_ILLEGAL_GRANT_FOR_TABLE);
	      YYABORT;
	    }
	  }
	| table_ident
	  {
	    if (!add_table_to_list($1,NULL))
	      YYABORT;
	    if (Lex->grant == UINT_MAX)
	      Lex->grant =  TABLE_ACLS;
	  }


user_list:
	grant_user	     { if (Lex->users_list.push_back($1)) YYABORT;}
	| user_list ',' grant_user { if (Lex->users_list.push_back($3)) YYABORT;}


grant_user:
	user IDENTIFIED_SYM BY TEXT_STRING { $$=$1; $1->password=$4 ; }
	| user				   { $$=$1; $1->password.str=NullS; }


opt_column_list:
	/* empty */ { Lex->grant |= Lex->which_columns; }
	| '(' column_list ')'

column_list:
	column_list ',' column_list_id
	| column_list_id

column_list_id:
	ident
	{
	  String *new_str = new String((const char*) $1.str,$1.length);
	  List_iterator <LEX_COLUMN> iter(Lex->columns);
	  class LEX_COLUMN *point;
	  while ((point=iter++))
	  {
	    if (!my_strcasecmp(point->column.ptr(),new_str->ptr()))
		break;
	  }
	  Lex->grant_tot_col|= Lex->which_columns;
	  if (point)
	    point->rights |= Lex->which_columns;
	  else
	    Lex->columns.push_back(new LEX_COLUMN (*new_str,Lex->which_columns));
	}

grant_option:
	/* empty */ {}
	| WITH GRANT OPTION { Lex->grant |= GRANT_ACL;}
