from typing import List

import xml.sax
from xml.sax.xmlreader import InputSource
from xml.sax.handler import ContentHandler, ErrorHandler

class SAXException(Exception):
    def __init__(self, msg, exception=None): ...
    def getMessage(self): ...
    def getException(self): ...
    def __getitem__(self, ix): ...

class SAXParseException(SAXException):
    def __init__(self, msg, exception, locator): ...
    def getColumnNumber(self): ...
    def getLineNumber(self): ...
    def getPublicId(self): ...
    def getSystemId(self): ...

class SAXNotRecognizedException(SAXException): ...
class SAXNotSupportedException(SAXException): ...
class SAXReaderNotAvailable(SAXNotSupportedException): ...

default_parser_list = ...  # type: List[str]

def make_parser(parser_list: List[str]) -> xml.sax.xmlreader.XMLReader: ...

def parse(source: str, handler: xml.sax.handler.ContentHandler,
          errorHandler: xml.sax.handler.ErrorHandler=...): ...

def parseString(string: str, handler: xml.sax.handler.ContentHandler,
                errorHandler: xml.sax.handler.ErrorHandler=...): ...

def _create_parser(parser_name: str) -> xml.sax.xmlreader.XMLReader: ...
