/*
 *   mwmclss1.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <mwmparse.h>
#include <mwmparsi.h>

static char szThisFile[] = "MWMCLSS1.C";

USHORT  mwmClss1ModToXRAT(PUSHORT pusParm);

USHORT  mwmClss1FTSCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss1::mwmClss1FTSCommand entry\n");
  if ( (psi->usNextPPIndex + 3) < PP_BUFFER_THRESHOLD)
  {
    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                        &psi->usNextATIndex);

    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x0031;
    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x8001;
    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss1::mwmClss1FTSCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

USHORT  mwmClss1FRSCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm = 0;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss1::mwmClss1FRSCommand entry\n");
  if ( (psi->usNextPPIndex + 3) < PP_BUFFER_THRESHOLD)
  {
    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                        &psi->usNextATIndex);

    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x0031;
    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x8005;
    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss1::mwmClss1FRSCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

USHORT  mwmClss1FTMCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm = 0;
  USHORT usUIMessage = 0;
  USHORT usUseConnectSpeed = 0;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss1::mwmClss1FTMCommand entry\n");
  if ( (psi->usNextPPIndex + 3) < PP_BUFFER_THRESHOLD)
  {

    if ( psi->achCommandBuffer[psi->usNextATIndex] == '?' )
    {
      /********************************************************************/
      /* This is the +FTM=? command.  It is handled here because          */
      /* of the similarities to the +FTM= command.                        */
      /********************************************************************/
      usParserStatus = mwmParseEchoString(psi,psi->achClass1Capabilities);

      /********************************************************************/
      /* Since this was a question mark, step the AT Command pointer over */
      /* it to position it for the next command.                          */
      /* Also, don't step this forward if the buffer is full...we must be */
      /* able to back up to the beginning of the command.                 */
      /********************************************************************/
      if (!(usParserStatus & MWM_GET_MORE_BUFFERS) )
        psi->usNextATIndex++;
    }
    else
    {
      usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                          &psi->usNextATIndex);

      if (usParm == 3)
      {
        usUIMessage = MWM_STATE_NEGOTIATING;
        usUseConnectSpeed = 0;
      }
      else
      {
        usUIMessage = MWM_STATE_FAXSEND;
        usUseConnectSpeed = 1;
      }
      mwmParsePostMessage( WM_MWM_UPDATE_STATUS, usUIMessage, usUseConnectSpeed);

      if ( mwmClss1ModToXRAT(&usParm) )
        return MWM_ATCMD_ERROR;

      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x0031;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x0001;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
    }
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss1::mwmClss1FTMCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

USHORT  mwmClss1FRMCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm = 0;
  USHORT usUIMessage = 0;
  USHORT usUseConnectSpeed = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss1::mwmClss1FRMCommand entry\n");
  if ( (psi->usNextPPIndex + 3) < PP_BUFFER_THRESHOLD)
  {

    if ( psi->achCommandBuffer[psi->usNextATIndex] == '?' )
    {
      /********************************************************************/
      /* This is the +FRM=? command.  It is handled here because          */
      /* of the similarities to the +FRM= command.                        */
      /********************************************************************/
      usParserStatus = mwmParseEchoString(psi,psi->achClass1Capabilities);

      /********************************************************************/
      /* Since this was a question mark, step the AT Command pointer over */
      /* it to position it for the next command.                          */
      /* Also, don't step this forward if the buffer is full...we must be */
      /* able to back up to the beginning of the command.                 */
      /********************************************************************/
      if (!(usParserStatus & MWM_GET_MORE_BUFFERS) )
        psi->usNextATIndex++;
    }
    else
    {
      usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                          &psi->usNextATIndex);

      if (usParm == 3)
      {
        usUIMessage = MWM_STATE_NEGOTIATING;
        usUseConnectSpeed = 0;
      }
      else
      {
        usUIMessage = MWM_STATE_FAXRECEIVE;
        usUseConnectSpeed = 1;
      }
      mwmParsePostMessage( WM_MWM_UPDATE_STATUS, usUIMessage, usUseConnectSpeed);

      if ( mwmClss1ModToXRAT(&usParm) )
        return MWM_ATCMD_ERROR;

      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x0031;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x0005;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
    }
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss1::mwmClss1FRMCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

USHORT  mwmClss1FTHCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm = 0;
  USHORT usUIMessage = 0;
  USHORT usUseConnectSpeed = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss1::mwmClss1FTHCommand entry\n");
  if ( (psi->usNextPPIndex + 3) < PP_BUFFER_THRESHOLD)
  {

    if ( psi->achCommandBuffer[psi->usNextATIndex] == '?' )
    {
      /********************************************************************/
      /* This is the +FTH=? command.  It is handled here because          */
      /* of the similarities to the +FTH= command.                        */
      /********************************************************************/
      usParserStatus = mwmParseEchoString(psi,psi->achClass1Capabilities);

      /********************************************************************/
      /* Since this was a question mark, step the AT Command pointer over */
      /* it to position it for the next command.                          */
      /* Also, don't step this forward if the buffer is full...we must be */
      /* able to back up to the beginning of the command.                 */
      /********************************************************************/
      if (!(usParserStatus & MWM_GET_MORE_BUFFERS) )
        psi->usNextATIndex++;
    }
    else
    {
      usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                          &psi->usNextATIndex);


      if (usParm == 3)
      {
        usUIMessage = MWM_STATE_NEGOTIATING;
        usUseConnectSpeed = 0;
      }
      else
      {
        usUIMessage = MWM_STATE_FAXSEND;
        usUseConnectSpeed = 1;
      }
      mwmParsePostMessage( WM_MWM_UPDATE_STATUS, usUIMessage, usUseConnectSpeed);

      if ( mwmClss1ModToXRAT(&usParm) )
        return MWM_ATCMD_ERROR;

      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x0031;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x0009;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
    }
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss1::mwmClss1FTHCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

USHORT  mwmClss1FRHCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm = 0;
  USHORT usUIMessage = 0;
  USHORT usUseConnectSpeed = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss1::mwmClss1FRHCommand entry\n");
  if ( (psi->usNextPPIndex + 3) < PP_BUFFER_THRESHOLD)
  {
    if ( psi->achCommandBuffer[psi->usNextATIndex] == '?' )
    {
      /********************************************************************/
      /* This is the +FRH=? command.  It is handled here because          */
      /* of the similarities to the +FRH= command.                        */
      /********************************************************************/
      usParserStatus = mwmParseEchoString(psi,psi->achClass1Capabilities);

      /********************************************************************/
      /* Since this was a question mark, step the AT Command pointer over */
      /* it to position it for the next command.                          */
      /* Also, don't step this forward if the buffer is full...we must be */
      /* able to back up to the beginning of the command.                 */
      /********************************************************************/
      if (!(usParserStatus & MWM_GET_MORE_BUFFERS) )
        psi->usNextATIndex++;
    }
    else
    {

      usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                          &psi->usNextATIndex);

      if (usParm == 3)
      {
        usUIMessage = MWM_STATE_NEGOTIATING;
        usUseConnectSpeed = 0;
      }
      else
      {
        usUIMessage = MWM_STATE_FAXRECEIVE;
        usUseConnectSpeed = 1;
      }
      mwmParsePostMessage( WM_MWM_UPDATE_STATUS, usUIMessage, usUseConnectSpeed);

      if ( mwmClss1ModToXRAT(&usParm) )
        return MWM_ATCMD_ERROR;

      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x0031;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x000D;
      psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
    }
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmclss1::mwmClss1FRHCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

USHORT  mwmClss1ModToXRAT(PUSHORT pusParm)
{
  USHORT ausLineSpeedProtocol[2];
  ULONG  ulRC = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss1::mwmClss1ModToXRAT entry\n");
  ausLineSpeedProtocol[1] = 0; // Clear the protocol word.

  switch(*pusParm)
  {
    case 3:
      *pusParm = 0xffff;
      ausLineSpeedProtocol[0] = 300;
      break;
    case 24:
      *pusParm = 0;
      ausLineSpeedProtocol[0] = 2400;
      break;
    case 48:
      *pusParm = 2;
      ausLineSpeedProtocol[0] = 4800;
      break;
    case 72:
      *pusParm = 4;
      ausLineSpeedProtocol[0] = 7200;
      break;
    case 73:
      *pusParm = 9;
      ausLineSpeedProtocol[0] = 7200;
      break;
    case 74:
      *pusParm = 8;
      ausLineSpeedProtocol[0] = 7200;
      break;
    case 96:
      *pusParm = 6;
      ausLineSpeedProtocol[0] = 9600;
      break;
    case 97:
      *pusParm = 11;
      ausLineSpeedProtocol[0] = 9600;
      break;
    case 98:
      *pusParm = 10;
      ausLineSpeedProtocol[0] = 9600;
      break;
    case 121:
      *pusParm = 13;
      ausLineSpeedProtocol[0] = 12000;
      break;
    case 122:
      *pusParm = 12;
      ausLineSpeedProtocol[0] = 12000;
      break;
    case 145:
      *pusParm = 15;
      ausLineSpeedProtocol[0] = 14400;
      break;
    case 146:
      *pusParm = 14;
      ausLineSpeedProtocol[0] = 14400;
      break;
    default:
      return 1;
  }

  ulRC = dspMemTransfer(psi->dsp.hDSP, psi->dsp.dspaddrMDMSTAT+2,
                        ausLineSpeedProtocol, 2,
                        DSP_MEMXFER_DATA_WRITE);
  if (ulRC!=DSP_NOERROR)
  {
    mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                      MWM_DSP_ERROR, ulRC );
    return MWM_ATCMD_ERROR;
  }

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss1::mwmClss1ModToXRAT exit ulRC 0\n");
  return 0;
}

/***********************************************************************
** Function: mwmClss1ConvertXratToSpeed
**
** Purpose: Converts the already-processed FAXXRAT value from modem
**          control into the connect speed which it writes to modem
**          control's status for displaying by the GUI.
************************************************************************/
ULONG MWM_ENTRY mwmClss1ConvertXratToSpeed( USHORT usXrat )
{

  USHORT ausLineSpeedProtocol[2];
  ULONG  ulRC = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss1::mwmClss1ConvertXramToSpeed entry\n");
  ausLineSpeedProtocol[1] = 0; // Clear the protocol word.

  switch(usXrat)
  {
    case 0xffff:
      ausLineSpeedProtocol[0] = 300;
      break;
    case 0:
      ausLineSpeedProtocol[0] = 2400;
      break;
    case 2:
      ausLineSpeedProtocol[0] = 4800;
      break;
    case 4:
      ausLineSpeedProtocol[0] = 7200;
      break;
    case 9:
      ausLineSpeedProtocol[0] = 7200;
      break;
    case 8:
      ausLineSpeedProtocol[0] = 7200;
      break;
    case 6:
      ausLineSpeedProtocol[0] = 9600;
      break;
    case 11:
      ausLineSpeedProtocol[0] = 9600;
      break;
    case 10:
      ausLineSpeedProtocol[0] = 9600;
      break;
    case 13:
      ausLineSpeedProtocol[0] = 12000;
      break;
    case 12:
      ausLineSpeedProtocol[0] = 12000;
      break;
    case 15:
      ausLineSpeedProtocol[0] = 14400;
      break;
    case 14:
      ausLineSpeedProtocol[0] = 14400;
      break;
    default:
      return 1;
  }

  ulRC = dspMemTransfer(psi->dsp.hDSP, psi->dsp.dspaddrMDMSTAT+2,
                        ausLineSpeedProtocol, 2,
                        DSP_MEMXFER_DATA_WRITE);
  if (ulRC!=DSP_NOERROR)
  {
    mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                      MWM_DSP_ERROR, ulRC );
    return MWM_ATCMD_ERROR;
  }
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmclss1::mwmClss1ConvertXratToSpeed exit ulRC 0\n");
  return 0;
}


