/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 gnucache.h  -  interface for the node cache.

 the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#if !defined(__GNUCACHE_H_INCLUDED__)
#define __GNUCACHE_H_INCLUDED__

class MGnuDirector;

class MGnuCache  
{
public:
	MGnuCache(MGnuDirector*);
	virtual ~MGnuCache();
	//
	bool LoadNodes(const CString&);
	bool SaveNodes(const CString&);
	//
	void UpdateCache(const Node& node); // fast function, only checks the 'recent queue'
	void Add(const Node& node);         // slow function, checks the whole list
	void Add(const IP& ip, int nPort);  // overloaded version
	void Remove(const IP& ip);          // manual removal
	int  GetSize();                     // number of hosts
	bool IsHalfEmpty();                 // returns true if we are in big need for hosts
	//
	void SendCache(MGnuNode* pNode, int nHosts);
	bool GetRandomNode(Node& rNode, bool bRemove = true);
	CString GetNodeList(int nNodes, bool bRemove = true);
	//
	void GetNodeList(list<Node>& list);
protected:
	bool CheckIfNotRecent(const IP& ip);
	//
	MMutex         m_mutex;
	list<Node>     m_listCache;      // Node list built as program runs
	std::deque<IP> m_queueRecentIPs; // The most recent IPs
	//
	MGnuDirector* m_pDirector;
private:
	MGnuCache();                       // no implementation
	MGnuCache(const MGnuCache& rSrc);  // no implementation
};

#endif // __GNUCACHE_H_INCLUDED__

