/***************************************************************************
                          property.cpp  -  description
                             -------------------
    begin                : Sat Jul 7 2001
    copyright            : (C) 2001 by 
    email                : maksik@gmx.co.uk
 ***************************************************************************/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "mutella.h"
#include "property.h"
#include "inifile.h"

bool MProperty::SetFromStr(char * buf)
{
	if (PT_STRING!=GetPropType())
		MakeLower(buf);
	buf = StripWhite(buf);
	int n;
	double d;
	IP ip;
	switch (GetPropType())
	{
		case PT_BOOL:
			if ( 0==strcmp(buf,"true") || 0==strcmp(buf,"1") )
			{
				SetBoolValue(true);
				return true;
			}
			else if ( 0==strcmp(buf,"false") || 0==strcmp(buf,"0") )
			{
				SetBoolValue(false);
				return true;
			}
			break;
		case PT_INT:
			if (asc2num(buf, &n))
			{
				SetIntValue(n);
				return true;
			}
			break;
		case PT_DWORD:
			if (asc2num(buf, &n))
			{
				SetDwordValue(n);
				return true;
			}
			break;
		case PT_DOUBLE:
			if (asc2num(buf, &d))
			{
				SetDoubleValue(d);
				return true;
			}
			break;
		case PT_STRING:
			// TODO: parse ""
			// workaround to set an empty string
			if (0==strcmp("\"\"",buf) || 0==strcmp("\'\'",buf))
				SetStringValue("");
			else
				SetStringValue(buf);
			return true;
		case PT_IP:
		ip = StrtoIP(buf);
		if (ip.S_addr)
		{
			SetIpValue(ip);
			return true;
		}
		break;			
	}
	return false;
}

bool MProperty::Read(MIniFile* pIniFile)
{
	// somewhat lasy way
	// TODO: test if it always works
	char tmp[1024]; // TODO: check if it sufficient
	if (pIniFile->ReadStr(name, tmp, "", true)) // do trim
	{
		if (strlen(tmp))
			return SetFromStr(tmp);
		if (PT_STRING==GetPropType())
			return true; // its OK when string is set to ""
	}
	return false;
}

bool MProperty::Write(MIniFile* pIniFile)
{
	switch (GetPropType()){
		case PT_BOOL:   return pIniFile->WriteBool(name, GetBoolValue());
		case PT_INT:    return pIniFile->WriteNum(name, (long)GetIntValue());
		case PT_DWORD:  return pIniFile->WriteNum(name, GetDwordValue());
		case PT_DOUBLE: return pIniFile->WriteNum(name, GetDoubleValue());
		case PT_STRING: return pIniFile->WriteStr(name, GetStringValue());
		case PT_IP:     return pIniFile->WriteStr(name, IPtoStr(GetIpValue()).c_str());
	}
	return false;
}

////////////////////////////////////////////////////////////////////////////////
//
// MPropertyContainer implementation

MPropertyContainer::MPropertyContainer()
{
	m_pCurSec = NULL;
}

MPropertyContainer::~MPropertyContainer()
{
	sec_iterator its;
	for (its = m_secs.begin(); its != m_secs.end(); its++)
	{
		delete its->second;
	}
	prop_iterator it;
	for (it = m_props.begin(); it != m_props.end(); it++)
	{
		delete it->second;
	}
}

bool MPropertyContainer::Read(LPCSTR szName)
{
	CString path = ExpandPath(szName);
	MIniFile inifile;
	if (!inifile.LoadFile(path.c_str()))
		return false;
	bool bOK = true;
	map<CString, MProperty*>map_copy = m_props;
	for (sec_iterator its = sec_begin();its!=sec_end();its++)
	{
		MPropertySection* pS = its->second;
		inifile.SetSection(pS->m_sName.c_str());
		for (iterator it = pS->begin();it!=pS->end();it++)
		{
			if (!it->second->IsPersistent())
				map_copy.erase(it->first);
			else if(it->second->Read(&inifile))
				map_copy.erase(it->first);
		}
	}
	inifile.ResetFile();
	for (iterator it = map_copy.begin();it!=map_copy.end();it++)
	{
		if (it->second->Read(&inifile))
			map_copy.erase(it->first);
	}
	inifile.CloseFile();
	return map_copy.empty();
}

bool MPropertyContainer::Write(LPCSTR szName)
{
	CString path = ExpandPath(szName);
	MIniFile inifile(INI_FxALLOWxCREATE);
	inifile.LoadFile(path.c_str());
	//
	map<CString, MProperty*>map_copy = m_props;
	for (sec_iterator its = sec_begin();its!=sec_end();its++)
	{
		MPropertySection* pS = its->second;
		for (iterator it = pS->begin();it!=pS->end();it++)
			map_copy.erase(it->first);
	}
	//
	bool bOK = true;
	for (iterator it = map_copy.begin();it!=map_copy.end();it++)
	{
		if (it->second->IsPersistent() && !it->second->Write(&inifile))
			bOK = false;
	}
	for (sec_iterator its = sec_begin();its!=sec_end();its++)
	{
		MPropertySection* pS = its->second;
		inifile.SetSection(pS->m_sName.c_str());
		for (iterator it = pS->begin();it!=pS->end();it++)
		{
			if (it->second->IsPersistent() && !it->second->Write(&inifile))
				bOK = false;
		}
	}
	inifile.FlushFile();
	inifile.CloseFile();
	return bOK;
}

int MPropertyContainer::Transfer(MPropertyContainer* pPC)
{
	int nCountAdded = 0;
	std::queue<CString> toErase;
	map<CString, MProperty*>map_copy = pPC->m_props;
	for (sec_iterator its = pPC->sec_begin();its!=pPC->sec_end();its++)
	{
		MPropertySection* pS = its->second;
		AddSection(pS->m_sName.c_str());
		map_copy.erase(pS->m_sName);
		for (iterator it = pS->begin();it!=pS->end();it++)
		{
			if (!FindProperty(it->first.c_str()))
			{
				m_props[it->first] = it->second;
				if (m_pCurSec)
					m_pCurSec->m_props[it->first] = it->second;
				toErase.push(it->first);
				nCountAdded++;
			}
		}
	}
	SetCurrentSection(NULL);
	for (iterator it = map_copy.begin();it!=map_copy.end();it++)
	{
		if (!FindProperty(it->first.c_str()))
		{
			m_props[it->first] = it->second;
			toErase.push(it->first);
			nCountAdded++;
		}
	}
	while(toErase.size())
	{
		pPC->m_props.erase(toErase.front());
		toErase.pop();
	}
	return nCountAdded;
}
	
MProperty* MPropertyContainer::AddNewProperty(LPCSTR szName, int nType, int nStrSize)
{
	if (FindProperty(szName))
		return NULL;
	MProperty* pP = NULL;
	switch (nType) {
		case PT_BOOL: pP = new MPropBool(szName);
			break;
		case PT_INT: pP = new MPropInt(szName);
			break;
		case PT_DOUBLE: pP = new MPropDbl(szName);
			break;
		case PT_STRING: pP = new MPropString(szName, "", nStrSize);
			break;
	}
	if (pP)
	{
		m_props[szName] = pP;
		if (m_pCurSec)
			m_pCurSec->m_props[szName] = pP;
	}
	return pP;
}

MProperty* MPropertyContainer::AddProperty(LPCSTR szName, bool * pb)
{
	if (FindProperty(szName))
		return NULL;
	MProperty* pP = new MPropBool(szName, pb);
	m_props[szName] = pP;
	if (m_pCurSec)
		m_pCurSec->m_props[szName] = pP;
    return pP;
}

MProperty* MPropertyContainer::AddProperty(LPCSTR szName, bool * pb, bool bInit)
{
	if (FindProperty(szName))
		return NULL;
    MProperty* pP = new MPropBool(szName, pb, bInit);
    m_props[szName] = pP;
    if (m_pCurSec)
		m_pCurSec->m_props[szName] = pP;
    return pP;
}

MProperty* MPropertyContainer::AddProperty(LPCSTR szName, int * pn)
{
	if (FindProperty(szName))
		return NULL;
    MProperty* pP = new MPropInt(szName, pn);
    m_props[szName] = pP;
    if (m_pCurSec)
		m_pCurSec->m_props[szName] = pP;
    return pP;
}

MProperty* MPropertyContainer::AddProperty(LPCSTR szName, int * pn, int nInit)
{
	if (FindProperty(szName))
		return NULL;
    MProperty* pP = new MPropInt(szName, pn, nInit);
    m_props[szName] = pP;
    if (m_pCurSec)
		m_pCurSec->m_props[szName] = pP;
    return pP;
}

MProperty* MPropertyContainer::AddProperty(LPCSTR szName, DWORD * pdw)
{
	if (FindProperty(szName))
		return NULL;
    MProperty* pP = new MPropDword(szName, pdw);
    m_props[szName] = pP;
    if (m_pCurSec)
		m_pCurSec->m_props[szName] = pP;
    return pP;
}

MProperty* MPropertyContainer::AddProperty(LPCSTR szName, DWORD * pdw, DWORD dwInit)
{
	if (FindProperty(szName))
		return NULL;
    MProperty* pP = new MPropDword(szName, pdw, dwInit);
    m_props[szName] = pP;
    if (m_pCurSec)
		m_pCurSec->m_props[szName] = pP;
    return pP;
}

MProperty* MPropertyContainer::AddProperty(LPCSTR szName, double * pd)
{
	if (FindProperty(szName))
		return NULL;
    MProperty* pP = new MPropDbl(szName, pd);
    m_props[szName] = pP;
    if (m_pCurSec)
		m_pCurSec->m_props[szName] = pP;
    return pP;
}

MProperty* MPropertyContainer::AddProperty(LPCSTR szName, double * pd, double dInit)
{
	if (FindProperty(szName))
		return NULL;
    MProperty* pP = new MPropDbl(szName, pd, dInit);
    m_props[szName] = pP;
    if (m_pCurSec)
		m_pCurSec->m_props[szName] = pP;
    return pP;
}

MProperty* MPropertyContainer::AddProperty(LPCSTR szName, IP * pip)
{
	if (FindProperty(szName))
		return NULL;
    MProperty* pP = new MPropIP(szName, pip);
    m_props[szName] = pP;
    if (m_pCurSec)
		m_pCurSec->m_props[szName] = pP;
    return pP;
}

MProperty* MPropertyContainer::AddProperty(LPCSTR szName, IP * pip, const IP& ipInit)
{
	if (FindProperty(szName))
		return NULL;
    MProperty* pP = new MPropIP(szName, pip, ipInit);
    m_props[szName] = pP;
    if (m_pCurSec)
		m_pCurSec->m_props[szName] = pP;
    return pP;
}

MProperty* MPropertyContainer::AddProperty(LPCSTR szName, LPSTR pstr, int nStrSize)
{
	if (FindProperty(szName))
		return NULL;
    MProperty* pP = new MPropString(szName, pstr, nStrSize);
    m_props[szName] = pP;
    if (m_pCurSec)
		m_pCurSec->m_props[szName] = pP;
    return pP;
}

MProperty* MPropertyContainer::AddProperty(LPCSTR szName, LPSTR pstr, int nStrSize, LPCSTR szInit)
{
	if (FindProperty(szName))
		return NULL;
    MProperty* pP = new MPropString(szName, pstr, nStrSize, szInit);
    m_props[szName] = pP;
    if (m_pCurSec)
		m_pCurSec->m_props[szName] = pP;
    return pP;
}

MProperty* MPropertyContainer::FindProperty(LPCSTR szName)
{
	prop_iterator it = m_props.find(szName);
	if (it != m_props.end())
		return it->second;
	return NULL;
}

bool MPropertyContainer::AddSection(LPCSTR szName)
{
	if (!szName || !strlen(szName))
		return false;
	//
	sec_iterator its = m_secs.find(szName);
	if (its==m_secs.end())
	{
		MPropertySection* pSec = new MPropertySection;
		pSec->m_sName = szName;
		m_secs[szName] = pSec;
		m_pCurSec = pSec;
	}
	else
		m_pCurSec = its->second;
	return true;
}

bool MPropertyContainer::SetCurrentSection(LPCSTR szName)
{
	if (!szName || !strlen(szName))
	{
		m_pCurSec = NULL;
		return true;
	}
	//
	sec_iterator its = m_secs.find(szName);
	if (its==m_secs.end())
		return false;
	m_pCurSec = its->second;
	return true;
}

MPropertySection* MPropertyContainer::FindSection(LPCSTR szName)
{
	sec_iterator it = m_secs.find(szName);
	if (it != m_secs.end())
		return it->second;
	return NULL;
}

