/***************************************************************************
                          preferences.h  -  description
                             -------------------
    begin                : Thu May 31 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

// the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

#if !defined(__PREFERENCES_H_INCLUDED__)
#define __PREFERENCES_H_INCLUDED__

class MController;
class MPropertyContainer;

#define MAX_PATH 1024
#define MAX_URL 256

class MGnuPreferences  
{
friend class MController;
public:
	MGnuPreferences(MController*);
	virtual ~MGnuPreferences();

	CString GetDefaultDir();

	// Local
	IP    m_ipLocalHost;		  // IP of node
	IP    m_ipForcedHost;		  // IP of node assigned by user
	DWORD m_dwLocalPort;		  // Port of node	
	DWORD m_dwForcedPort;		  // Port of node assigned by user
	DWORD m_dwSpeedStat;		  // Node speed determined by the user
	DWORD m_dwSpeedDyn;		      // Node speed determined by gnucleus

	// Local Firewall
	bool  m_bBehindFirewall;
	bool  m_bReachableForPush;
	
	// Connect
	bool    m_bQuietMode;
	int     m_nMinConnects;
	int     m_nMaxConnects;
	int     m_nMaxConnPerSubnetA;	// Max connections per class-A subnet
	int     m_nMaxConnPerSubnetB;	// Max connections per class-B subnet
	int     m_nMaxConnPerSubnetC;	// Max connections per class-C subnet
	int     m_nFriendsMin;			// Connected node must have x num of friends before timeout

	// Connect Servers
	char m_szAutoConnectSrv1[MAX_URL];
	char m_szAutoConnectSrv2[MAX_URL];
	char m_szAutoConnectSrv3[MAX_URL];
	char m_szAutoConnectSrv4[MAX_URL];

	// Connect Screen
	std::vector<ExIP> m_ScreenedNodes;
	
	// Timeouts
	DWORD m_dwConnectTimeout;
	DWORD m_dwPushTimeout;
	DWORD m_dwSpeedTimeout;
	DWORD m_dwTransferTimeout;

	// Search
	char    m_szDownloadPath[MAX_PATH];
	//bool    m_bDoubleCheck;
	bool    m_bSearchScreenNodes;
	bool	m_bGroupbySize;
	bool	m_bGroupbyName;
	bool    m_bGroupbyFuzzyRules;
	bool	m_bScreenBusy;
	bool    m_bStrictSearch;
	int     m_nMinFileKSize;
	int     m_nMaxFileKSize;
	int     m_nResubmitSearches;
	int     m_nMaxSearches;
	int     m_nMaxPerSearchResults;
	bool    m_bSaveSearches;
	//int     m_nMaxResultsDisplayed;

	// Search Screen
	std::vector<CString> m_ScreenedWords;

	// Share
	char m_szSharePath[MAX_PATH];
	bool m_bReplyFilePath;
	int  m_nMaxReplies;
	bool m_bSendOnlyAvail;

	// Transfer
	int   m_nMaxDownloads;
	int   m_nMaxUploads;
	int	  m_nRetryWait;
	int   m_nMaxPerHostDownloads;
	int   m_nMaxPerHostUploads;

	// Bandwidth
	double m_dBandwidthTotal;
	double m_dBandwidthTransfer;
	double m_dBandwidthConnects;
	double m_dMinDownSpeed;
	double m_dMinUpSpeed;

protected:
	MGnuPreferences();                          // no implementation
	MGnuPreferences(const MGnuPreferences& rSrc);  // no implementation
		
protected:
	MController* m_pController;
	MPropertyContainer* m_pContainer;
};

#endif // __PREFERENCES_H_INCLUDED__
