/***************************************************************************
                          mui.cpp  -  description
                             -------------------
    begin                : Thu May 31 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>	/* waitpid () */
#include <sys/wait.h>	/* waitpid () */
#include <unistd.h>	/* fnctl () */
#include <fcntl.h>	/* fnctl () */
#include "mutella.h"
#include "gnusearch.h"
#include "controller.h"
#include "gnunode.h"
#include "gnuupload.h"
#include "gnudownload.h"
#include "preferences.h"
#include "mui.h"
#include "property.h"
#include "readline4fix.h"
#include "mprintf.h"
#include "ansicolor.h"
#include "event.h"

#define _isblank isspace

class MUIPriv;
typedef bool (MUIPriv::*tComHandler)(char * arg);
typedef std::set<int> intSet;
typedef std::set<DWORD> dwordSet;
typedef std::set<void*> ptrSet;
typedef std::vector<int> intVec;
typedef std::vector<DWORD> dwordVec;

struct SUIColors {
	// list/results
	char header[32];
	char id[32];
	char size[32];
	char speed[32];
	char percent[32];
	char time[32];
	char name[32];
	char extra[32];
	char flag1[32];
	char flag2[32];
	char num[32];
	char ip[32];
	char status[32];
	// general purpose
	char deflt[32];
	char message[32];
	char error[32];
	// set
	char variable[32];
	char value[32];
};

class MPrintfColor : public MPrintfMore
{
public:
	MPrintfColor(int nCPL = -1, int nLPP = -1) : MPrintfMore(nCPL, nLPP), m_bEnableColor(true) {}
protected:
	virtual void PrePrint(CString& s){
		// search for '??' combinations which are suposed to define 'style'
		// listed in m_propClr;
		int nStart = 0;
		int nPos;
		int nPos1;
		int n,i;
		bool bStyled = false;
		LPCSTR szPropName;
		int nNameLen;
		while ( -1 != (nPos = s.find("??",nStart)) )
		{
			CString sStyle = s.substr(nPos+2,16); // style names are normally short
			bool bFound = false;
			nPos1 = -1;
			// unfortunately sStyle.find('>'); wont work
			n = sStyle.length();
			for(i = 0; i<n; ++i)
				if (sStyle[i] == '>')
				{
					nPos1 = i;
					break;
				}
				else if (sStyle[i]<'0' || sStyle[i]>'z' || (sStyle[i]>'9' && sStyle[i]<'A'))
				{
					// non-alphanum
					break;
				}
			if (nPos1>=0)
			{
				//found '>' -- we have to cut out &&...> and replace it with the ANSI combination
				sStyle = sStyle.substr(0,nPos1);
				CString sTmp = s.substr(nPos+2+nPos1+1); // '+1' is for spacer after
				s.cut(nPos); // cut without memory realloc
				s += ANSI_NORMAL;
				bStyled = false;
				//
				if (m_bEnableColor && sStyle.size())
				{
					MProperty* pP = m_propClr.FindProperty(sStyle.c_str());
					if (pP)
					{
						if (strlen(pP->GetStringValue()))
						{
							s += ESC_CHAR;
							s += pP->GetStringValue();
							bStyled = true;
						}
					}
				}
				nStart = s.length();
				s += sTmp;
			}
			else
			{
				// '??' case -- just replace it with 'ANSI_NORMAL'
				CString sTmp = s.substr(nPos+2);
				s.cut(nPos); // cut without memory realloc
				s += ANSI_NORMAL;
				nStart = s.length();
				s += sTmp;
				bStyled = false;
			}
		}
		if (bStyled)
			s+= ANSI_NORMAL;
	}
public:
	MPropertyContainer m_propClr;
	bool m_bEnableColor;
};

class MEventPrinter : public MSyncEventReceiver {
public:
protected:
	virtual bool IsOfInterest(MEvent* p){
		ASSERT(p);
		return p->GetSeverity()>=ES_IMPORTANT;
	}
	virtual void OnEvent(MEvent* p){
		ASSERT(p);
		printf("RECEIVED EVENT:\n"
#ifdef _DEBUG
		       "  type: %d\n  severity: %d\n  id: %d\n"
#endif
		       "  %s\n",
#ifdef _DEBUG
		       p->GetType(), p->GetSeverity(), p->GetID(),
#endif
		       p->Format().c_str());
	}
};

class MEventCache : public MAsyncEventReceiver {
public:
	MEventCache() : MAsyncEventReceiver(INT_MAX, 0x4000 /*16k*/) {}
protected:
	virtual bool IsOfInterest(MEvent* p){
		ASSERT(p);
		return p->GetSeverity()>=ES_GOODTOKNOW;
	}
};

class MUIPriv {
public:
	MUIPriv(MController*);
	~MUIPriv();
	// basic functionality
	bool attach();
	bool init();
	void detach();
	void ui_loop();
	void stop(){m_bContinue = 0;}
	//
	bool set_helper(MPropertyContainer* pPC, char * arg);
	bool stop_help(LPCSTR szCom,bool bDelPart, char * arg);
	//
	int m_nCounter;
	dwordVec m_vecConnIDs;
	dwordVec m_vecTransIDs;
	dwordVec m_vecSearchIDs;
	dwordVec m_vecResIDs;
	MController* m_pController;
	int  m_nDummy1;
	bool m_bContinue;
	int  m_nDummy2;
	queue<CString> m_command_queue;
	// paged terminal output
	MPrintfColor m_more;
	// couple of properties
	int m_nMaxResultsDispl;
	char m_szStartUpScript[1024];
	bool m_bUseColor;
	char m_szColorScheme[1024];
	SUIColors m_colors;
	MEventPrinter m_evPrinter;
	MEventCache m_evCache;

	// command support
	typedef struct {
		char*			name;     // User printable name of the function.
		tComHandler 	handler;  // Function to call to do the job.
		char*			doc_short; // Documentation for this function.
		char*			doc_long;
	} ComEntry;
	typedef struct {
		char*			name;     // User printable name of the function.
		char*			doc_short; // Documentation for this function.
		char*			doc_long;
	} VarEntry;
	static ComEntry commands[];
	static VarEntry variables[];
	ComEntry* find_command(char*);
	bool execute_line ( char* line );
	// commands
	bool com_help(char * arg);
	bool com_exit(char * arg);
	// search
	bool com_find(char * arg);
	bool com_list(char * arg);
	bool com_ls(char * arg);
	bool com_delete(char * arg);
	bool com_clear(char * arg);
	bool com_results(char * arg);
	// retrive
	bool com_get(char * arg);
	// stop transfers
	bool com_stop(char * arg);
	bool com_kill(char * arg);
	// info
	bool com_info(char * arg);
	bool com_hosts(char * arg);
	// connections
	bool com_open(char * arg);
	bool com_close(char * arg);
	// misc
	bool com_load(char * arg);   // script
	//bool com_system(char * arg); // execute a shell command
	bool com_set(char * arg);    // envinroment management
	bool com_color(char * arg); // termUI colors
	// shared files
	bool com_scan(char * arg);
	bool com_library(char * arg);
	//
	bool com_system(char * arg);
	bool com_version(char * arg);
};

MUIPriv::MUIPriv(MController* pC) : m_more(80,24)
{
	m_pController = pC;
	m_bContinue = true;
	
}

MUIPriv::~MUIPriv()
{
}

bool MUIPriv::attach()
{
	//
	EQ().AddReceiver(&m_evPrinter);
	EQ().AddReceiver(&m_evCache);
	//
	MProperty* pP;
	MPropertyContainer* pPC = m_pController->GetPropertyContainer();
	pPC->AddSection("TerminalUI");
	pPC->AddProperty("MaxResultsDisplayed", &m_nMaxResultsDispl,    1000);
	pPC->AddProperty("StartupScript",       m_szStartUpScript,      1024, "~/.mutella/termrc");
	pPC->AddProperty("UseANSIColor",        &m_more.m_bEnableColor, true);
	pPC->AddProperty("ColorScheme",         m_szColorScheme,        1024, "~/.mutella/termclr");
	pP = pPC->AddProperty("TerminalCols",   &m_more.m_nCPL,         MPrintfMore::GuessTermCols());
	if (pP) pP->SetPersistance(false);
	pP = pPC->AddProperty("TerminalLines",  &m_more.m_nLPP,         MPrintfMore::GuessTermLines());
	if (pP) pP->SetPersistance(false);
	pPC->AddProperty("Paginate",            &m_more.m_bBreak,       true);
	pPC->SetCurrentSection(NULL);
	return true;
}

bool MUIPriv::init()
{
	// prepare property container for the color scheme
	m_more.m_propClr.AddProperty("header",   m_colors.header,  32, "[1m"); //bold
	m_more.m_propClr.AddProperty("id",       m_colors.id,      32, "[1m"); //bold
	m_more.m_propClr.AddProperty("size",     m_colors.size,    32, "[34m"); //blue
	m_more.m_propClr.AddProperty("speed",    m_colors.speed,   32, "[32m"); //green
	m_more.m_propClr.AddProperty("percent",  m_colors.percent, 32, "[33m"); //yellow
	m_more.m_propClr.AddProperty("time",     m_colors.time,    32, "[35m"); //magenta
	m_more.m_propClr.AddProperty("name",     m_colors.name,    32, "[31m"); //red
	m_more.m_propClr.AddProperty("extra",    m_colors.extra,   32, "[32m");
	m_more.m_propClr.AddProperty("flag1",    m_colors.flag1,   32, "[34m"); //bold
	m_more.m_propClr.AddProperty("flag2",    m_colors.flag2,   32, "[33m"); //bold
	m_more.m_propClr.AddProperty("num",      m_colors.num,     32, "[36m");
	m_more.m_propClr.AddProperty("ip",       m_colors.ip,      32, "[35m");
	m_more.m_propClr.AddProperty("status",   m_colors.status,  32, "[34m");
	// general purpose
	//m_more.m_propClr.AddProperty("default",  m_colors.deflt,   32, "");
	m_more.m_propClr.AddProperty("message",  m_colors.message, 32, "[34m");//blue
	m_more.m_propClr.AddProperty("error",    m_colors.error,   32, "[31m");//red
	// set
	m_more.m_propClr.AddProperty("variable", m_colors.variable,32, "[35m");
	m_more.m_propClr.AddProperty("value",    m_colors.value,   32, "[34m");
	// load the color scheme
	if (strlen(m_szColorScheme))
		m_more.m_propClr.Read(m_szColorScheme);
}

void MUIPriv::detach()
{
	if (strlen(m_szColorScheme) && m_more.m_bEnableColor)
	{
		TRACE("Saving color scheme...");
		m_more.m_propClr.Write(m_szColorScheme);
	}
	// remove properties from m_pController
	// TODO that
	//
	EQ().RemoveReceiver(&m_evPrinter);
	EQ().RemoveReceiver(&m_evCache);
	// store the color scheme

}

MUIPriv::ComEntry MUIPriv::commands[] = {
  { "help",   &MUIPriv::com_help,   "Displays a help message. Type `help <command>' for more specific info", NULL},
  { "?",      &MUIPriv::com_help,   "Synonym for `help'", NULL},
  { "exit",   &MUIPriv::com_exit,   "Exits Mutella", NULL },
  { "info"   ,&MUIPriv::com_info,   "Displays various information regarding current network activities",
  									"info [network] [connections] [transfers] [uploads] [downloads]\n"
  									"    Displays different bits of information regarding current status of the\n"
  									"    client and its activities. Use parameters to select specific types of\n"
  									"    info, e.g. 'info downloads' will only display status of current downloads.\n"
  									"    Parameters can be abbreviated and multiple parameters can be given. Without\n"
  									"    parameters displays all status information.\n"
  									"    NOTE: rates displayed for individual Gnutella-net connecvtions do not\n"
  									"    reflect the bandwidth consumed and are given only for the reference.\n"
  									"    Total connection speed however is quite reliable parameter."},
  { "hosts"  ,&MUIPriv::com_hosts,  "Displays current content of the hosts cache", NULL },
  { "find",   &MUIPriv::com_find,   "Adds a query to the search list",
  									"find <list of keywords> [options]\n"
  									"    Adds new query to the current list of searches. All the keywords are\n"
  									"    matched as a boolean AND ignoring upper/lower case.\n"
  									"    NEW: exclusive search is supported: `find hook .avi -hookers' will only\n"
  									"    look for a movie, filtering out porno-crap.\n"
  									"    Additional search options allow one to specify exact file size with\n"
  									"    `size:XXXX' or minimum file size with `min:XXXX'\n"
  									"    With no parameters equivalent to `list'" },
  { "list",   &MUIPriv::com_list,   "Lists current searches",
  									"list [pattern] [options]\n"
  									"    Displays current list of searches. Optionally takes pattern as a\n"
  									"    parameter. When pattern is given only searches that match it are\n"
  									"    listed. This is useful when search list grows above 5-10 entries.\n"
  									"    Additionally it is possible to filter out searches with no hits by\n"
  									"    '-empty' option and automatically generated searches with '-auto'" },
  { "ls",     &MUIPriv::com_ls,     "Synonym for 'list -empty'", NULL},
  { "delete", &MUIPriv::com_delete, "Deletes the query or queries from the list of searches",
  									"delete <search_ID(s)>\n"
  									"    Deletes a query or queries from the current list of searches. Numeric\n"
  									"    ID(s) should be taken from last output of the `list' command. IDs can\n"
  									"    be given in fairly relaxed way. For example `delete 2,5,8-10,1' will\n"
  									"    delete searches listed under numbers 1,2,5,8,9,10; `delete 1-' deletes\n"
  									"    all the searches listed by the last `list' command\n" },
  { "clear",  &MUIPriv::com_clear,  "Clears results list for the query or query list",
  									"clear <search_ID(s)>\n"
  									"    Clears results of each the queries referenced by numeric IDs. Numeric\n"
  									"    ID(s) are to be taken from last output of the `list' command. IDs can\n"
  									"    be given in fairly relaxed way. For example `clear 2,5,8-10,1' will\n"
  									"    clear up searches listed under numbers 1,2,5,8,9,10; `clear 1-' clears\n"
  									"    all the searches listed by the last `list' command\n"},
  { "results",&MUIPriv::com_results,"Displays search results",
  									"results [pattern | search_ID(s)]\n"
  									"    Displays results of the search. Searches can be selected by either\n"
  									"    pattern in the same way as for `list' command, or numerical search ID(s)" },
  { "get"    ,&MUIPriv::com_get,    "Get files from the net",
  									"get <result_ID(s)>\n"
  									"    Initiates download of the file(s) for given result ID(s). Result ID(s)\n"
  									"    should reference search result list as it was produced by the last\n"
  									"    `results' command. IDs can be given in fairly relaxed way. For example\n"
  									"    `get 10, 15, 22-25' will start download of the search results listed\n"
  									"    under numbers 10, 15, 21, 22, 23, 24, 25.\n"
  									"    The progress of download procedure can be examined with `info' command.\n"
  									"    Once download is started Mutella tries to get requested file forever,\n"
  									"    until the transfer is successful or stopped with the `stop' command.\n"
  									"    When download fails to start immediately Mutella initiates the search for\n"
  									"    alternative locations for the file. If host is not responding for last\n"
  									"    25 trials 'auto-get' search is added and download failure is reported.\n"
  									"    When the file appears on the Gnutella horizon Mutella automatically\n"
  									"    initiates the transfer. Auto-get searches are also created for all\n"
  									"    partial files found in the download directory on the client start" },
  { "stop"   ,&MUIPriv::com_stop,   "Stops the transfer",
  									"stop <transfer_ID(s)>\n"
  									"    Stops transfers corresponding to the given numeric ID(s). Transfer IDs\n"
  									"    are to be taken from the last `info' command output\n"
  									"    NOTE that 'stop' doesn't remove partial file from the download directory\n"
  									"    use `kill' instead" },
  { "kill"   ,&MUIPriv::com_kill,   "Same as stop, but erases partial file in case of download",
  									"stop <transfer_ID(s)>\n"
  									"    Stops transfers corresponding to the given numeric ID(s) and deletes\n"
  									"    appropriate patrial files in case of download. Transfer IDs are to be taken\n"
  									"    from the last `info' command output"},
  { "open"   ,&MUIPriv::com_open,   "Opens new Gnutella-net connection",
  									"open <host> [port]\n"
  									"    Opens Gnutella-net connection to the specified host. When 'port'\n"
  									"    parameter is omitted 6346 is assumed" },
  { "close"  ,&MUIPriv::com_close,  "Closes specified Gnutella connection(s)",
  									"close <connection_ID(s)>\n"
  									"    Closes connection(s) which correspond to the given numeric ID(s).\n"
  									"    Connection IDs are to be taken from the last `info' command output" },
  { "scan"   ,&MUIPriv::com_scan,   "(Re)Scans shared directory", NULL },
  { "library",&MUIPriv::com_library,"Lists currently shared files", NULL },
  { "load"   ,&MUIPriv::com_load,   "Loads and executes Mutella terminal-mode script", NULL },
  { "set"    ,&MUIPriv::com_set,    "Accesses Mutella options",
  									"set [Variable [new_value]]\n"
  									"    Used to access Mutella options. Without parameters displays the entire\n"
  									"    list of options. When called up with one parameter displays the value\n"
  									"    of the appropriate variable. When called with two parameters treats\n"
  									"    the first parameter as variable name and the second one as a new value\n"
  									"    To empty th string variable type `set <variable> \"\"'\n"
  									"    All mutella options are stored in `~/.mutella/mutellarc' file" },
  { "color"  ,&MUIPriv::com_color,  "Sets terminal colors",
  									"color [field [new_ASCI_code]]\n"
  									"    Used to set colors for terminal UI. Syntax is similar to `set'. The\n"
  									"    color scheme is stored in the location ponted by ColorScheme variable\n"
  									"    (default is `~/.mutella/termclr')" },
  { "system" ,&MUIPriv::com_system, "Executes a shell command given by argument", NULL },
  { "!"      ,&MUIPriv::com_system, "synonym for 'system'", NULL },
  { "version",&MUIPriv::com_version,"Displays program version", NULL },

  { NULL, NULL, NULL, NULL }
};

MUIPriv::VarEntry MUIPriv::variables[] = {
  { "AutoConnectSrv1",		"Auto-connect server #1 (host cache) address",
  							"  AutoConnectSrvX is used to initiate the connection to the Gnutella-net\n"
  							"  Alternatively it will be used when Mutella looses the connection to the\n"
  							"  net for whatever reason and host cache is empty. Both `url:port' and\n"
  							"  `url port' forms are accepted. When port is ommited 6346 is assumed\n"},
  { "AutoConnectSrv2",		"Auto-connect server #2. See help on `AutoConnectSrv1' for detail", NULL},
  { "AutoConnectSrv3",		"Auto-connect server #2. See help on `AutoConnectSrv1' for detail", NULL},
  { "AutoConnectSrv4",		"Auto-connect server #2. See help on `AutoConnectSrv1' for detail", NULL},
  { "BandwidthConnects",	"Bandwidth allocated for Guntella-net connections",
  							"  Amount of network bandwidth (in Kbytes per second) allowed to spend for\n"
  							"  Gnutella-net related traffic. Because of the nature of this traffic Mutella\n"
  							"  is unable to follow this limitation exactly. The value given here will only\n"
  							"  approximately limit the connection bandwidth"},
  { "BandwidthTotal",		"Bandwidth allocated for all non-ours traffic",
  							"  Limits amount of the bandwidth (in Kbytes per second) given for both uploads\n"
  							"  and Gnutella-net. Works well in combination with BandwidthConnects, when the\n"
  							"  later is less or equal to 50% of the BandwidthTotal. Actual upload traffic is\n"
  							"  limited by the (BandwidthTotal - actual_connection_traffic)"},
  { "BandwidthTransfer",	"Bandwidth allocated for uploads",
  							"  Limits amount of the bandwidth (in Kbytes per second) allowed for uploads.\n"
  							"  When BandwidthTotal is set actual upload traffic is limited by the minimum\n"
  							"  between BandwidthTransfer and (BandwidthTotal - actual_connection_traffic)"},
  { "BandwidthTransfer",	"Bandwidth allocated for uploads"},
  { "ConnectTimeout",		"Connection Timeout", NULL},
  { "DownloadPath",			"Path to the download directory", NULL},
  { "Firewall",				"Set to true if it is impossible to connect to your host", NULL },
  { "ForceIP",				"Your IP address reported to the Gnutella-net",
  							"  Set to your firewall IP if there is a static mapping for your Mutella"},
  { "ForcePort",			"Listening port reported to the Gnutella-net",
  							"  Normally combines with ForceIP. Should be set to the listening port on the\n"
  							"  firewall if there is static mapping for your Mutella"},
  { "GroupByName",			"Group search results by name",
  							"  Search results should be grouped also by name (in addition to grouping by"
  							"  size)"},
  { "GroupBySize",			"Group search results with similar size", NULL},
  { "GroupFuzzy",			"Group by size, but allow slight deviations in names", NULL},
  { "LocalIP",				"IP address of the local host",
  							"  The value is automatically defined on the client start and modified later\n"
  							"  once a connection to the Gnutella network is established (this is required\n"
  							"  for determination of the correct IP for box with multiple interfaces"},
  { "LocalPort",			"Listening port",
  							"  Modifying the value during client operation have no effect. Edit\n"
  							"  ~/.mutella/mutellarc file when client is stopped, or set LocalPort in Mutella\n"
  							"  and exit it. Upon the next client start Mutella will listen on the new port"},
  { "MaxConnPerSubnetA",	"Maximum number of the simultaneous connections per A-class subnet", NULL},
  { "MaxConnPerSubnetB",	"Maximum number of the simultaneous connections per B-class subnet", NULL},
  { "MaxConnPerSubnetC",	"Maximum number of the simultaneous connections per C-class subnet", NULL},
  { "MaxConnections",		"Maximum number of the Gnutella-net connections", NULL},
  { "MaxDownloads",			"Maximum number of the simulteneous downloads", NULL},
  { "MaxFileSize",			"Maximum file size (in K) of the search result",
  							"  Required for spam-protection. Default is very reasonable"},
  { "MaxPerHostDownloads",	"Maximum number of the simultaneous downloads from the same host", NULL},
  { "MaxPerHostUploads",	"Maximum number of the simultaneous uploads to the same host", NULL},
  { "MaxReplies",			"Maximum number of the replies for the incoming search request", NULL},
  { "MaxResults",			"Maximum number of results per search", NULL},
  { "MaxResultsDisplayed",	"Maximum number of results displayed by `results'", NULL},
  { "MaxSearches",			"Maximum number of the simultaneous searches", NULL},
  { "MaxUploads",			"Maximum number of the simultaneous uploads", NULL},
  { "MinConnections",		"Minimum number of connections",
  							"  When number of connections drops below this value Mutella starts to make\n"
  							"  outgoing connections. This is not true when QuietMode is set"},
  { "MinDownloadSpeed",		"Minimum download speed in bytes per second", NULL},
  { "MinFileSize",			"Minimum file size (in K) of the search result",
  							"  Required for protection against millions of partial files people share"},
  { "MinFriends",			"Minimum number of the hosts known to the Gnutella-node", NULL},
  { "MinUploadSpeed",		"Minimum upload speed in bytes per second", NULL},
  { "Paginate",				"Stop between pages",
  							"  When set to `true' terminal output will stop each `TerminalLines' lines"},
  //{ "PartInDir",	"",
  //							""},
  //{ "PushTimeout",	"",
  //							""},
  { "QuietMode",			"Do not allow Mutella making outgoing connections",
  							"  This mode is useful when it is advisable to reduce amount of the outgoing\n"
  							"  connections, for example when running Mutella from the office computer. Has\n"
  							"  effect on connections and push-uploads"},
  { "ReplyFilePath",		"Add file path to the search reply",
  							"  Defines whether to add a file path to the search replies. Added path is\n"
  							"  relative to the shared directory"},
  { "ReplyIfAlail",			"Send search-replies only if upload slots available", NULL},
  { "ResubmitTime",			"Interval of re-submission for local searches", NULL},
  { "RetryDelay",			"Download retry delay", NULL},
  { "ScreenBusy",			"not functional", NULL},
  { "SearchScreenNodes",	"not functional", NULL},
  { "SharePath",			"Path to the shared directory",
  							"  Path to the shared directory. Changing it during Mutella session has no\n"
  							"  immediate effect. To actualise new shared path you need to issue `scan'\n"
  							"  command. To share files located on different file systems use symbolic links"},
  //{ "SpeedDynamic",			"",
  //							""},
  { "SpeedStatic",			"The speed of your connection in Kbps", NULL},
  //{ "SpeedTimeout",			"",
  //							""},
  { "StartupScript",		"The path to the start-up script", NULL},
  //{ "StrictSearch",			"",
  //							""},
  { "TerminalCols",			"Number of columns in the terminal",
  							"  Defined automatically at the client start. Non-persistent. If automatic\n"
  							"  detection fails you can set typical number of columns in the start-up\n"
  							"  script (~/.mutella/termrc)"},
  { "TerminalLines",		"Number of lines in the terminal",
  							"  Defined automatically at the client start. Non-persistent. If automatic\n"
  							"  detection fails you can set typical number of lines in the start-up\n"
  							"  script (~/.mutella/termrc)"},
  //{ "TransferTimeout",		"",
  //							""},
  //{ "",	"",
  //							""},
  { "SaveSearches",			"Defines whether to save searches between sessions", NULL },

  { NULL, NULL, NULL }
};

/* Look up NAME as the name of a command, and return a pointer to that
   command.  Return a NULL pointer if NAME isn't a command name. */
MUIPriv::ComEntry * MUIPriv::find_command ( char *name )
{
	register int i;
	for (i = 0; commands[i].name; i++)
		if (strncmp (name, commands[i].name, strlen(name)) == 0)
			return (&commands[i]);
	return NULL;
}

bool MUIPriv::execute_line ( char* line )
{
	register int i;
	ComEntry *command;
	char *word;
	int 	pipes [2], 
		old_stdout,
		fpid = 0,
		flags;
	bool bOldPageBreak;
	char *args [4], *ptr;

	/* Isolate the command word. */
	i = 0;
	while (line[i] && _isblank(line[i]))
		i++;
	word = line + i;

	while (line[i] && !_isblank(line[i]))
		i++;

	if (line[i])
		line[i++] = '\0';

	command = find_command (word);

	if (!command)
	{
		printf ("%s: No such command.\n", word);
		return false;
	}

	/* Get argument to command, if any. */
	while (_isblank(line[i]))
		i++;

	word = line + i;

	/* Pipe output to a system command */
	if ((ptr = strchr (word, '|'))) {
		*ptr = 0;
		if (pipe (pipes) == -1) {
			printf ("Failed to create a pipe\n");
			return false;
		}

		if ((fpid = fork ()) == -1) {
			printf ("Failed to create child process\n");
			return false;
		}	

		if (! fpid) {
			/* child */
			close (pipes [1]);

			/* redirect stdin from the pipe */
			if (dup2 (pipes [0], STDIN_FILENO) == -1) {
				printf ("Failed to redirect stdin\n");
				exit (1);
				return false;
			}

			args [0] = "sh";
			args [1] = "-c";
			args [2] = ++ptr;
			args [3] = 0;

			/* Set close_on_exec to 0 */
			flags = fcntl (STDIN_FILENO, F_GETFD, 0);
			flags &= ~FD_CLOEXEC;
			fcntl (STDIN_FILENO, F_SETFD, flags);

			if (execve ("/bin/sh", args, NULL) == -1) {
				printf ("execve() failed\n");
				exit (1);
			}
		} else {
			/* parent */
			close (pipes [0]);
			
			/* Backup stdout */
			if ((old_stdout = dup (STDOUT_FILENO)) == -1) {
				printf ("Failed to backup stdout\n");
				return false;
			}	

			/* Redirect stdout to the pipe */
			if (dup2 (pipes [1], STDOUT_FILENO) == -1) {
				printf ("Failed to redirect stdout\n");
				return false;
		 	}
		 	
			/* set max lines to avoid paging */
			bOldPageBreak = m_more.m_bBreak;
			m_more.m_bBreak = false;

			close (pipes [1]);
		}
	}
	
	/* Call the function. */
	bool bRes = ((*this).*(command->handler))(word);//(this->(*(command->handler)) (word));

	m_more.Flush();

	/* Wait for piped process to exit and restore stdout / term lines */
	if (fpid>0) {
		close (STDOUT_FILENO);
		waitpid (fpid, NULL, 0);
		if (dup2(old_stdout, STDOUT_FILENO)==-1)
			printf("Failed to set stdout back\n");
		close (old_stdout);
		m_more.m_bBreak = bOldPageBreak;
	}

	return bRes;
}


void MUIPriv::ui_loop()
{
	char *line, *s;
	char tmp[1024];
	CString sLastCommand;
	// startup script
	if (strlen(m_szStartUpScript))
	{
		if (!FileExists(m_szStartUpScript))
		{
			printf("\nCreating default '%s' file\n", m_szStartUpScript);
			printf("Edit it to modify Mutella startup behaviour\n\n");
			FILE* f;
			if (f=fopen(ExpandPath(m_szStartUpScript).c_str(),"w"))
			{
				fprintf(f,"# mutella terminal-mode initialisation script\n");
				fprintf(f,"# edit it to make mutella smarter during startup\n");
				//fprintf(f,"\n# initiate a gnutella-net connection\n");
				//fprintf(f,"open public.bearshare.net\n");
				//fprintf(f,"open gnotella.fileflash.com\n");
				//fprintf(f,"open router.limewire.com\n");
				fprintf(f,"\n# for example set terminal size\n");
				fprintf(f,"# (if automatic detection fails), or just do nothing\n");
				fprintf(f,"\nversion\n\n");

				fclose(f);
			}
		}
		if (FileExists(m_szStartUpScript))
		{
			strncpy(tmp,m_szStartUpScript,1024);
			tmp[1023]='\0';
			com_load(tmp);
		}
	}
	/* Loop reading and executing lines until the user quits. */
	while ( m_bContinue )
	{
		if (m_command_queue.size())
		{
			strncpy(tmp,m_command_queue.front().c_str(),1024);
			tmp[1023]='\0';
			m_command_queue.pop();
			//
			execute_line(tmp);
		}
		else
		{
			if (m_evCache.HaveEvents())
			{
				if (m_evCache.MissedEvents())
				{
					m_more.print("??error>You have missed %d events\n", m_evCache.MissedEvents());
					m_evCache.ResetMissedEvents();
				}
				while (m_evCache.HaveEvents())
				{
					MEvent* p = m_evCache.Front();
					ASSERT(p);
					m_more.print("Event %x:\n"
#ifdef _DEBUG
					              "  type: %d\n  severity: %d\n  id: %d\n"
#endif
					              "  %s\n",
		                          p,
#ifdef _DEBUG
		                          p->GetType(), p->GetSeverity(), p->GetID(),
#endif
		                          p->Format().c_str());
					//
					m_evCache.Pop();
				}
				m_more.Flush();
			}
			//
			line = readline_fix("> ");
			if (!line)
				break;
			// Remove leading and trailing whitespace from the line.
			// Then, if there is anything left, add it to the history list
			// and execute it.
			s = StripWhite (line);
			if (*s)
			{
#ifndef _HAS_NO_HISTORY_H
				if (sLastCommand != s)
				{
					add_history_fix(s);
					sLastCommand = s;
				}
#endif
				execute_line (s);
			}
			free (line);
		}
	}
}

MUI::MUI(MController* pC)
{
	m_pPriv = new MUIPriv(pC);
}

MUI::~MUI()
{
	delete m_pPriv;
}

bool MUI::Attach()
{
	return m_pPriv->attach();
}

bool MUI::Init()
{
	return m_pPriv->init();
}

void MUI::Detach()
{
	m_pPriv->detach();
}

void MUI::Do()
{
	m_pPriv->ui_loop();
}

void MUI::Stop()
{
	m_pPriv->stop();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
// couple of useful parsers
//

bool ParseNumRanges(intSet& seq, char* str, int nMax /*for n- combination*/)
{
	bool bAfterDash = false;
	int n = -1;
	int m = -1;
	int len = strlen(str);
	char* p = NULL;
	for( int i = 0; i<=len; ++i )
	{
		if (str[i]>='0' && str[i]<='9')
		{
			// it is a digit -- set the pointer to it if it is the first one
			if (!p)
				p=str+i;
		}
		else if ( str[i]==',' || str[i]==';' || str[i]=='-' || str[i]==' ' || str[i]=='\t' || str[i]=='\0' )
		{
			// achieved space or separator or range symbol (dash);
			if (p)
				// if we have the pointer to the begining of the number
				if (bAfterDash)
				{
					// there was a dash before -- treat as a range
					if ( str[i]=='-' )
						// nn-nn-
						return false;
					str[i] = '\0';
					m = atoi(p);
					p = NULL;
					if (n<0 && m<n)
						return false;
					if (m>nMax)
						m = nMax;
					for(n++;n<=m;++n)
						seq.insert(n);
					bAfterDash = false;
				}
			 	else
				{
					// just a number -- count it, and if current char is not a separator --
					// leave n untouched for the case of a dash
					bool bComa = ( str[i]==',' || str[i]==';' );
					bAfterDash = ( str[i]=='-' );
					str[i] = '\0';
					n = atoi(p);
					p = NULL;
					seq.insert(n);
					if (bComa)
						n = -1;
				}
			else
			{
				if ( str[i]=='-' )
				{
					if ( n<0 || bAfterDash )
						//   -n or -- situation
						return false;
					bAfterDash = true;
				}
				else if ( str[i]==',' || str[i]==';' )
				{
					if (bAfterDash)
					// n-, situation
					{
						if (n<0)
							return false;
						for (n++;n<=nMax;++n)
							seq.insert(n);
						bAfterDash = false;
					}
					n = -1;
				}
			}
		}
		else
			// unexpected symbol
			return false;
	}
	if ( bAfterDash )
	{
		// n-  situation
		if (n<0)
			return false;
		for (n++;n<=nMax;++n)
			seq.insert(n);
	}
	// sort and compress would be needed by the list, set is already sorted and
	//seq.sort();
	//seq.unique();
	return true;		
}

CString FormatSize(u_long n)
{
	char tmp[16]; // overkill
	if ( n < 1e3 )
		sprintf(tmp,"%d", n);
	else if ( n < 1u<<10 )
		sprintf(tmp,"%.2gK", n/1024.0);
	else if ( n < 1e6 )
		sprintf(tmp,"%.3gK", n/1024.0);
	else if ( n < 1u<<20 )
		sprintf(tmp,"%.2gM", n/1048576.0);
	else if ( n < 1e9 )
		sprintf(tmp,"%.3gM", n/1048576.0);
	else if ( n < 1u<<30 )
		sprintf(tmp,"%.2gG", n/1073741824.0);
	else
		sprintf(tmp,"%.3gG", n/1073741824.0);
	return tmp;
}

CString FormatSizeLL(long long n)
{
	char tmp[16]; // overkill
	if ( n < 1e3 )
		sprintf(tmp,"%d", n);
	else if ( n < 1ll<<10 )
		sprintf(tmp,"%.2gK", n/1024.0);
	else if ( n < 1e6 )
		sprintf(tmp,"%.3gK", n/1024.0);
	else if ( n < 1ll<<20 )
		sprintf(tmp,"%.2gM", n/1048576.0);
	else if ( n < 1e9 )
		sprintf(tmp,"%.3gM", n/1048576.0);
	else if ( n < 1ll<<30 )
		sprintf(tmp,"%.2gG", n/1073741824.0);
	else if ( n < 1e12 )
		sprintf(tmp,"%.3gG", n/1073741824.0);
	else if ( n < 1ll<<40 )
		sprintf(tmp,"%.2gT", n/1.0995116278e+12);
	else
		sprintf(tmp,"%.3gT", n/1.0995116278e+12);
	return tmp;
}

CString FormatKSize(u_long n)
{
	char tmp[16]; // overkill
	if ( n < 1000u )
		sprintf(tmp,"%.3gK", n*1.0);
	else if ( n < 1u<<10 )
		sprintf(tmp,"%.2gM", n/1024.0);
	else if ( n < 1000000u )
		sprintf(tmp,"%.3gM", n/1024.0);
	else if ( n < 1u<<20 )
		sprintf(tmp,"%.2gG", n/1048576.0);
	else if ( n < 1000000000u )
		sprintf(tmp,"%.3gG", n/1048576.0);
	else
		sprintf(tmp,"%.3gT", n/1073741824.0);
	return tmp;
}

CString FormatKSizeLL(long long n)
{
	char tmp[16]; // overkill
	if ( n < 1e3 )
		sprintf(tmp,"%.3gK", n*1.0);
	else if ( n < 1ll<<10 )
		sprintf(tmp,"%.2gM", n/1024.0);
	else if ( n < 1e6 )
		sprintf(tmp,"%.3gM", n/1024.0);
	else if ( n < 1ll<<20 )
		sprintf(tmp,"%.2gG", n/1048576.0);
	else if ( n < 1e9 )
		sprintf(tmp,"%.3gG", n/1048576.0);
	else if ( n < 1ll<<30 )
		sprintf(tmp,"%.2gT", n/1073741824.0);
	else
		sprintf(tmp,"%.3gT", n/1073741824.0);
	return tmp;
}

CString FormatMSize(u_long n)
{
	char tmp[16]; // overkill
	if ( n < 1000u )
		sprintf(tmp,"%.3gM", n*1.0);
	else if ( n < 1u<<10 )
		sprintf(tmp,"%.2gG", n/1024.0);
	else if ( n < 1000000u )
		sprintf(tmp,"%.3gG", n/1024.0);
	else if ( n < 1u<<10 )
		sprintf(tmp,"%.2gT", n/1048576.0);
	else
		sprintf(tmp,"%.3gT", n/1048576.0);
	return tmp;
}

CString FormatNumber(double d)
{
	char tmp[16]; // overkill
	if ( d < 1e3 )
		sprintf(tmp,"%.3g", d);
	else if ( d < 1e6 )
		sprintf(tmp,"%.3gK", d*1e-3);
	else if ( d < 1e9 )
		sprintf(tmp,"%.3gM", d*1e-6);
	else
		sprintf(tmp,"%.3gG", d*1e-9);
	return tmp;
}

CString FormatPercent(double part, double whole)
{
	double d = 100.0*part/whole;
	
	char tmp[16]; // overkill
	if (d>=1.0)
		sprintf(tmp,"%.3g%%",d);
	else if (d>=0.1)
		sprintf(tmp,"%.2g%%",d);
	else if (d>=0.01)
		sprintf(tmp,"%.1g%%",d);
	else
		sprintf(tmp,"0.00%%");
	return tmp;
}

CString FormatTime(time_t nSec)
{
	int nMin = nSec/60;
	int nHour = nMin/60;
	int nDay = nHour/24;
	CString sTmp;
	if (nDay) sTmp.format("%dd%dh", nDay, nHour%24);
	else if (nHour) sTmp.format("%dh%dm", nHour, nMin%60);
	else if (nMin) sTmp.format("%dm%ds", nMin, nSec%60);
	else sTmp.format("%ds", nSec%60);
	return sTmp;
}

CString FormatTimeFull(time_t nSec)
{
	int nMin = nSec/60;
	int nHour = nMin/60;
	int nDay = nHour/24;
	CString sTmp;
	if (nDay) sTmp.format("%dd%dh%dm%ds", nDay, nHour%24, nMin%60, nSec%60);
	else if (nHour) sTmp.format("%dh%dm%ds", nHour, nMin%60, nSec%60);
	else if (nMin) sTmp.format("%dm%ds", nMin, nSec%60);
	else sTmp.format("%ds", nSec%60);
	return sTmp;
}

CString InsertElypsis(CString s, int nMaxLen)
{
	if (s.length()>nMaxLen && nMaxLen>4)
	{
		return s.substr(0,nMaxLen/2-2) + "..." + s.substr(s.length()-(nMaxLen - nMaxLen/2)+1);
	}
	return s;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////
// command implementation
//

bool MUIPriv::com_help ( char *arg )
{
	register int i;
	int printed = 0;
	if ( !arg || 0==strlen(arg) )
	{
		m_more.print("??header>Available comands:\n");
		m_more.print("??header>==================\n");
		for (i = 0; commands[i].name; i++)
		{
			m_more.print ("??name>%s\t??%s\n", commands[i].name, commands[i].doc_short);
		}
		m_more.print("??message>\nAll commands accept abbrevations, e.g. `results' can be replaced\n"
		             "with `res' or even `r'\n");
		m_more.print("??flag1>NEW: ??message>All commands support Unix pipes, that is output of the mutella\n"
		             "command can be redirected to the system command using standard Unix\n"
		             "pipleline syntax, e.g. `res 1-3 | grep something'\n");
		m_more.print("??message>Type `help <command>' to get more detailed help on specific command\n");
		m_more.print("??flag1>NEW: ??message>type `help <variable_name>' to get description of the specific\n"
		             "variable. List of mutella variables (options) can be acquired with\n"
		             "`set' command with no parameters\n");
		return true;
	}
	if (m_pController->GetProperty(arg))
	{
		for (i = 0; variables[i].name; i++)
		{
			if ( strcmp(arg, variables[i].name) == 0 )
			{
				if (variables[i].doc_long)
					m_more.print ("\n%s:	%s\n\n%s\n", arg, variables[i].doc_short, variables[i].doc_long);
				else
					m_more.print ("\n%s:	%s\n", arg, variables[i].doc_short);
				printed++;
			}
		}
		if (!printed)
		{
			m_more.print ("\n??message>Sorry, variable `%s' is not documented yet\n", arg);
			printed++;
		}
	}
	else
	{
		for (i = 0; commands[i].name; i++)
		{
			if ( strncmp (arg, commands[i].name, strlen(commands[i].name) ) == 0 )
			{
				if (commands[i].doc_long)
					m_more.print ("\n%s\n", commands[i].doc_long);
				else
					m_more.print ("\n%s\n\t%s.\n", commands[i].name, commands[i].doc_short);
				printed++;
			}
		}
	}
	if (!printed)
	{
		if ( arg && strlen(arg) )
			m_more.print("??message>No commands match `%s'.  Possibilties are:\n", arg);
		for (i = 0; commands[i].name; i++)
		{
			m_more.print ("%s\t", commands[i].name);
			// Print in six columns.
			if ( i%6 == 5)
				m_more.print ("\n");
		}
		if ( i%6 != 0)
			m_more.print("\n");
		m_more.print("\n??message>List of mutella variables can be acquired with `set' command\n");
	}
	return true;
}

bool MUIPriv::com_exit ( char *arg )
{
	// TODO: ask for safe exit
	m_more.print("??message>bye\n");
	m_bContinue = false;
	return true;
}

bool MUIPriv::com_system(char * arg)
{
	return -1 != system(arg);
}

bool MUIPriv::com_load(char * arg)
{
	CString s = ExpandPath(arg);
	FILE* f = fopen(s.c_str(), "r");
	if (f == NULL)
	{
		m_more.print("??message>failed to open `??name>%s??message>'\n", s.c_str());
		return false;
	}
	char tmp[1024];
	char * t;
	while (!feof(f) && !ferror(f))
	{
		if (NULL!=fgets(tmp,1024,f))
		{
			tmp[1023] = '\0';
			t = StripWhite(tmp);
			if (strlen(t) && *t != '#')
				m_command_queue.push(t);
		}
	}
	fclose(f);
	return true;
}

bool parse_num_param(CString& s, int& num, int nStatrAt = 0)
{
	// find the firs 'token' -- something isolated by the spaces
	int nBegin = nStatrAt;
	while (_isblank(s[nBegin]) && nBegin<s.length())
		++nBegin;
	if (nBegin == s.length())
		return false;
	int nEnd = nBegin+1;
	while (!_isblank(s[nEnd]) && nEnd<s.length())
		nEnd++;
	char* tmp = (char*) alloca(nEnd-nBegin+2);
	strncpy(tmp, s.substr(nBegin,nEnd-nBegin).c_str(), nEnd-nBegin+1);
	if (asc2num( tmp, &num))
	{
		s = s.substr(0, nStatrAt) + s.substr(nEnd);
		return true;
	}
	return false;	
}

bool MUIPriv::com_find(char * arg)
{
	if ( arg==NULL || strlen(arg)==0 )
		return com_list("");
	CString search = StripWhite(arg);
	// check for options
	int nMinSize = -1;
	int nSize = -1;
	int nPos = search.find("min:");	
	if (nPos>=0)
	{
		if (!parse_num_param(search, nMinSize, nPos+4))
		{
			m_more.print("??error>find: syntax error after 'min:'\n");
			return false;
		}
		search = search.substr(0,nPos)+search.substr(nPos+4);
		//m_more.print("minsize = %d, searching for '%s'\n", nMinSize, search.c_str());
	}
	nPos = search.find("size:");	
	if (nPos>=0)
	{
		if (!parse_num_param(search, nSize, nPos+5))
		{
			m_more.print("??error>find: syntax error after 'size:'\n");
			return false;
		}
		search = search.substr(0,nPos)+search.substr(nPos+5);
		//m_more.print("size = %d, searching for '%s'\n", nSize, search.c_str());
	}
	// add a query to the search list
	if (nSize!=-1)
	{
		if (m_pController->AddSearchUsr(search.c_str(), nSize, LIMIT_EXACTLY))
			return true;
	}
	else if (nMinSize!=-1)
	{
		if (m_pController->AddSearchUsr(search.c_str(), nMinSize, LIMIT_MORE))
			return true;
	}
	else
	{
		if (m_pController->AddSearchUsr(search.c_str(), 0, LIMIT_NONE))
			return true;
	}
	m_more.print("??error>adding search `??name>%s??error>' failed.\nprobably there are similar searches already \nor maximum number of searches has been reached.\n", search.c_str());
	return false;
}

struct resParams{
	MUIPriv* pThis;
	CString  sFilter;
	int      nMaxResultsDisplayed;
	dwordSet seq;
	dwordSet retSet;
};

int compRes(const void* p1, const void* p2)
{
	Result* pr1 = *(Result**)p1;
	Result* pr2 = *(Result**)p2;
	// sord decending by size, than desending by speed, than accending by name
	if (pr1->Size>pr2->Size)
		return -1;
	if (pr1->Size<pr2->Size)
		return 1;
	if (pr1->Speed>pr2->Speed)
		return -1;
	if (pr1->Speed<pr2->Speed)
		return 1;
	if (pr1->Name>pr2->Name)
		return 1;
	if (pr1->Name<pr2->Name)
		return -1;
	return 0;
}

void resCallback(void* pData, SGnuSearch* pSearch)
{
	resParams* pRP = (resParams*) pData;
	if ( (pSearch->m_nHits != 0 && pRP->sFilter.length()!=0 && QueryMatch(pSearch->m_Search, pRP->sFilter)) ||
		 (pSearch->m_nHits != 0 && pRP->sFilter.length()==0 && pRP->seq.size()==0) ||
		 (pRP->seq.end() != pRP->seq.find(pSearch->m_dwID)) )
	{
		pRP->retSet.insert(pSearch->m_dwID);
	}
}

int compGroups(const void* p1, const void* p2)
{
	ResultGroup* pg1 = *(ResultGroup**)p1;
	ResultGroup* pg2 = *(ResultGroup**)p2;
	// sort decending by size, than desending by speed, than acending by name
	if (pg1->Size>pg2->Size)
		return -1;
	if (pg1->Size<pg2->Size)
		return 1;
	if (pg1->AvgSpeed>pg2->AvgSpeed)
		return -1;
	if (pg1->AvgSpeed<pg2->AvgSpeed)
		return 1;
	if (pg1->Name>pg2->Name)
		return 1;
	if (pg1->Name<pg2->Name)
		return -1;
	return 0;
}

bool MUIPriv::com_results(char * arg)
{
	resParams rp;
	rp.pThis = this;
	if (strlen(arg)==0 ||
	    strpbrk(arg, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvqxyz") )
	{
		// use string filter approach
		rp.sFilter = arg;
	}
	else
	{
		// try numbersint
		intSet is;
		if (!ParseNumRanges(is, arg, m_vecSearchIDs.size()))
		{
			m_more.print("??error>results: failed to parse parameters\n");
			return false;
		}
		// transform numbers into IDs
		for (intSet::iterator it=is.begin();it!=is.end();++it)
		{
			if (*it<=m_vecSearchIDs.size())
				rp.seq.insert(m_vecSearchIDs[(*it)-1]);
			else
			{
				m_more.print("??error>results: no searches with ID = %d\n", *it);
			}
		}
	}
	rp.nMaxResultsDisplayed = 1000;
	MProperty* pMaxRes = m_pController->GetProperty("MaxResultsDisplayed");
	if (pMaxRes)
		rp.nMaxResultsDisplayed = pMaxRes->GetIntValue();
	m_pController->ForEachSearch((void*)&rp, resCallback);
	//
	m_nCounter = 1;
	m_vecResIDs.clear();
	m_more.print("Current search results, matching your criteria\n");
	for (dwordSet::iterator it = rp.retSet.begin(); it!=rp.retSet.end(); ++it)
	{
		if (rp.nMaxResultsDisplayed < m_nCounter)
			break;
		//
		SGnuSearch gs;
		std::vector<Result> rv;
		std::vector<ResultGroup> gv;
		if (!m_pController->GetSearchByID(*it,gs,rv,gv))
			continue;
		//
		m_more.print("  ??header>QUERY:??\"??name>%s??header>\" \t HITS:??num>%d\n", gs.m_Search.c_str(), gs.m_nHits);
		if (m_pController->GroupResults())
		{
			// now copy result groups to our array so that we could sort it
			int nCount = gv.size();
			ResultGroup** arrpRGps = new ResultGroup*[nCount];
			for (int i = 0; i<nCount; ++i)
			{
				arrpRGps[i]= &gv[i];
			}
			// we dont need a quick sort for a list of 10-20 results
			// but we have it so we use it
			qsort(arrpRGps, nCount, sizeof(Result*),compGroups); // TODO: different ways of sorting
			for (int i=0; i<nCount; i++)
			{
				ResultGroup* pgrp=arrpRGps[i];
				m_vecResIDs.push_back(pgrp->dwID);
				if ( pgrp->ResultList.size() > 1 )
				{
					m_more.print("??id>%3d)?? `??name>%s??' ??size>%s??\n    LOCATIONS:??num>%-3d??  avg.speed:??speed>%s\n",
						m_vecResIDs.size(), pgrp->Name.c_str(), FormatSize(pgrp->Size).c_str(),
						pgrp->ResultList.size(), GetSpeedString(pgrp->AvgSpeed).c_str());
				}
				else
				{
					Result* pres= &rv[pgrp->ResultList[0]];
					m_more.print("??id>%3d)?? `??name>%s??' ??size>%s?? REF:??num>%d\n",
						m_vecResIDs.size(), pgrp->Name.c_str(), FormatSize(pres->Size).c_str(), pres->FileIndex );
				}
				if (pgrp->ResultList.size()<4)
				{
					for (int j = 0; j< pgrp->ResultList.size(); j++)
					{
						Result* pres= &rv[pgrp->ResultList[j]];
						if (pres->Extra.size())
							m_more.print("    extra: ??extra>%s\n", pres->Extra.c_str());
						m_more.print("    ??ip>%16s:%-4d?? speed:??speed>%-12s ??flag1>%-12s?? time:??time>%s\n",
							IPtoStr(pres->Host).c_str(), pres->Port, GetSpeedString(pres->Speed).c_str(), pres->Vendor.c_str(),
							FormatTime(time(NULL) - pres->ChangeTime).c_str() );
					}
				}
			}
			delete [] arrpRGps;
		}
		else
		{
			// now copy references to results to our array so that we could sort it
			int nCount = rv.size();
			Result** arrpRes = new Result*[nCount];
			for (int i=0; i<nCount; i++)
			{
				arrpRes[i]=&rv[i];
			}
			// we dont need a quick sort for a list of 10-20 results
			// but we have it so we use it
			qsort(arrpRes, nCount, sizeof(Result*),compRes); // TODO: different ways of sorting
			for (int i=0; i<nCount; i++)
			{
				Result* pres=arrpRes[i];
				m_vecResIDs.push_back(pres->dwID);
				m_more.print(" ??id>%d)?? `??name>%s??' ??size>%s?? REF:??num>%d??\n    IP:??ip>%s:%d?? \tSPEED:??speed>%s \t??flag1>%s\n",
					m_vecResIDs.size(), pres->Name.c_str(), FormatSize(pres->Size).c_str(), pres->FileIndex,
					IPtoStr(pres->Host).c_str(), pres->Port, GetSpeedString(pres->Speed).c_str(), pres->Vendor.c_str());
			}
			delete [] arrpRes;
		}
	}
	m_more.print("count: ??num>%d\n", m_nCounter-1);
	return true;
}

struct clrParams{
	MUIPriv* pThis;
	CString  sFilter;
	int      nMaxResultsDisplayed;
	dwordSet seq;
	dwordSet retSet;
};


void clearCallback(void* pData, SGnuSearch* pSearch)
{
	clrParams* pRP = (clrParams*) pData;
	if (pRP->nMaxResultsDisplayed < pRP->pThis->m_nCounter)
		return;
	if ( (pRP->sFilter.length()!=0 && QueryMatch(pSearch->m_Search, pRP->sFilter)) ||
		 (pRP->sFilter.length()==0 && pRP->seq.size()==0) ||
		 (pRP->seq.end() != pRP->seq.find(pSearch->m_dwID)) )
	{
		pRP->pThis->m_more.print("\"??name>%s??\"\n", pSearch->m_Search.c_str());
		pRP->retSet.insert(pSearch->m_dwID);
	}
}

bool MUIPriv::com_clear(char * arg)
{
	if (strlen(arg)==0)
	{
		m_more.print("??error>clear: argument is required\n");
		return false;
	}
	clrParams cp;
	cp.pThis = this;
	if (strpbrk(arg, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvqxyz"))
	{
		// use string filter approach
		cp.sFilter = arg;
	}
	else
	{
		intSet seq;
		// try numbersint
		if (!ParseNumRanges(seq, arg, m_vecSearchIDs.size()))
		{
			m_more.print("??error>clear: failed to parse parameters\n");
			return false;
		}
		// convert to IDs
		for(intSet::iterator it = seq.begin(); it != seq.end(); it++)
		{
			if (*it <= m_vecSearchIDs.size())
				cp.seq.insert(m_vecSearchIDs[(*it)-1]);
		}
	}
	cp.nMaxResultsDisplayed = 1000;
	MProperty* pMaxRes = m_pController->GetProperty("MaxResultsDisplayed");
	if (pMaxRes)
		cp.nMaxResultsDisplayed = pMaxRes->GetIntValue();
	cp.retSet.clear();
	m_nCounter = 1;
	m_more.print("??message>Clearing search results of following searches\n");
	m_pController->ForEachSearch((void*)&cp, clearCallback);
	if (!cp.retSet.empty())
	{
		//pSearch->Clear();
		for (dwordSet::iterator it = cp.retSet.begin();it != cp.retSet.end(); ++it)
			m_pController->ClearSearchByID(*it);
	}
	return true;
}

struct listParams{
	MUIPriv* pThis;
	CString sFilter;
	bool bNoEmpty;
	bool bNoAutoSearches;
};

void listCallback(void* pData, SGnuSearch* pSearch)
{
	listParams* pLP = (listParams*) pData;
	if ( (pLP->sFilter.length()==0 || QueryMatch(pSearch->m_Search, pLP->sFilter)) &&
		 (!pLP->bNoEmpty || pSearch->m_nHits) &&
		 (!pLP->bNoAutoSearches || !pSearch->IsAutomatic()) )
	{
		pLP->pThis->m_vecSearchIDs.push_back(pSearch->m_dwID);
		ASSERT(pLP->pThis->m_vecSearchIDs.size()==pLP->pThis->m_nCounter);
		//
		pLP->pThis->m_more.print("??id>%2d) ??name>`%s'\n    ", pLP->pThis->m_nCounter, pSearch->m_Search.c_str());
		if (pSearch->m_SizeFilterMode == LIMIT_NONE)
			pLP->pThis->m_more.print("??flag1>no size filter ");
		else if (pSearch->m_SizeFilterMode == LIMIT_MORE)
			pLP->pThis->m_more.print("MIN:??size>%-11s",FormatSize(pSearch->m_SizeFilterValue).c_str());
		else if (pSearch->m_SizeFilterMode == LIMIT_EXACTLY)
			pLP->pThis->m_more.print("SIZE:??size>%-10d",pSearch->m_SizeFilterValue);
		else if (pSearch->m_SizeFilterMode == LIMIT_LESS)
			pLP->pThis->m_more.print("MAX:??size>%-11s",FormatSize(pSearch->m_SizeFilterValue).c_str());
		if (pSearch->m_bAutoget)
			pLP->pThis->m_more.print("??flag2>  AUTOGET");
		else
			pLP->pThis->m_more.print("         ");
		if (pSearch->m_nHits)
			pLP->pThis->m_more.print("  HITS:??num>%d\n", pSearch->m_nHits);
		else
			pLP->pThis->m_more.print("??flag1>  NO HITS\n");
		pLP->pThis->m_nCounter++;
	}
}

bool MUIPriv::com_list(char * arg)
{
	m_nCounter = 1;
	listParams lp;
	lp.pThis = this;
	lp.sFilter = arg;
	lp.bNoEmpty = false;
	lp.bNoAutoSearches = false;
	// switches
	MakeLower(lp.sFilter);
	lp.sFilter = " " + lp.sFilter + " ";
	int n;
	n = lp.sFilter.find(" -empty ");
	if (0<=n)
	{
		lp.sFilter = lp.sFilter.substr(0, n)+ lp.sFilter.substr(n+7);
		lp.bNoEmpty = true;
	}
	n = lp.sFilter.find(" -auto ");
	if (0<=n)
	{
		lp.sFilter = lp.sFilter.substr(0, n)+ lp.sFilter.substr(n+6);
		lp.bNoAutoSearches = true;
	}
	lp.sFilter = StripWhite(lp.sFilter);
	//
	m_vecSearchIDs.clear();
	//
	m_more.print("??message>Searches in progress, matching your criteria\n");
	m_pController->ForEachSearch((void*)&lp, listCallback);
	m_more.print("??message>count: ??num>%d\n", m_nCounter-1);
	return true;
}

bool MUIPriv::com_ls(char * arg)
{
	if (NULL!=strstr(arg, "-empty"))
		return com_list(arg);
	char* tmp = (char*) alloca(strlen(arg)+16); // to lazy to count letters
	sprintf(tmp, "%s -empty", arg);
	return com_list(tmp);
}

bool MUIPriv::com_delete(char * arg)
{
	intSet seq;
	if (!ParseNumRanges(seq, arg, m_vecSearchIDs.size()))
	{
		m_more.print("??error>delete: failed to parse parameters\n");
		return false;
	}
	for(intSet::iterator it = seq.begin(); it != seq.end(); it++)
	{
		if (*it<=m_vecSearchIDs.size())
			m_pController->RemoveSearchByID(m_vecSearchIDs[(*it)-1]);
	}
	return true;
}

void infoConnCallback(void* pData, SGnuNode* pNode)
{
	MUIPriv* pThis = (MUIPriv*) pData;
	pThis->m_vecConnIDs.push_back(pNode->m_dwID);
	ASSERT(pThis->m_vecConnIDs.size()==pThis->m_nCounter);
	pThis->m_more.print("??id>%2d)?? ??ip>%16s:%-4d?? [??speed>%5s??|??speed>%-5s??]/s  drp:%-4d ??num>%5s??/??num>%-6s??  time:??time>%s\n", pThis->m_nCounter, pNode->m_sHost.c_str(), pNode->m_nPort,
			FormatSize((int)pNode->m_dRate[0]).c_str(),FormatSize((int)pNode->m_dRate[1]).c_str(),
			/*pNode->m_nSendQueueSize,*/ pNode->m_nDroppedPackets,
			FormatNumber(pNode->m_dwFriendsTotal).c_str(),
			FormatKSizeLL(pNode->m_llLibraryTotal).c_str(),
			FormatTime(xtime()-pNode->m_dwUptime).c_str());
	//m_more.print("      version 0.%d\n",pNode->m_dwVersion);
	pThis->m_nCounter++;
}

void infoUploadCallback(void* pData, SGnuUpload* pUpload)
{
	MUIPriv* pThis = (MUIPriv*) pData;
	pThis->m_vecTransIDs.push_back(pUpload->m_dwID);
	ASSERT(pThis->m_vecTransIDs.size()==pThis->m_nCounter);
	pThis->m_more.print("??id>%2d)??name> %s\n    ??ip>%16s:%-4d??  ??percent>%5s  ??speed>%5s/s  ",
		pThis->m_nCounter,
		InsertElypsis(pUpload->m_sFileName, 75).c_str(),
		IPtoStr(pUpload->m_ipHost).c_str(), pUpload->m_nPort,
		FormatPercent(pUpload->m_nBytesCompleted,pUpload->m_nFileLength).c_str(),
		FormatSize((int)pUpload->m_dRate).c_str());
	if (pUpload->m_dRate > 0)
		pThis->m_more.print("ETA:??time>%s  ",
			FormatTime((int) ((pUpload->m_nFileLength-pUpload->m_nBytesCompleted)/pUpload->m_dRate)).c_str());
	pThis->m_more.print("??status>%s\n",
		SGnuUpload::GetErrorString(pUpload->m_nError));
	pThis->m_nCounter++;
}

void infoDownloadCallback(void* pData, SGnuDownload* pDownload)
{
	MUIPriv* pThis = (MUIPriv*) pData;
	pThis->m_vecTransIDs.push_back(pDownload->m_dwID);
	ASSERT(pThis->m_vecTransIDs.size()==pThis->m_nCounter);
	pThis->m_more.print("??id>%2d)??name> %s\n", pThis->m_nCounter, InsertElypsis(pDownload->m_sName,75).c_str());
	if (pDownload->m_bActive)
	{
		pThis->m_more.print("    ??status>%-6s ", MGnuDownload::GetStatusString(pDownload->m_nStatus));	
		pThis->m_more.print("??ip>%16s:%-4d??  A:??num>%-2d ",
				IPtoStr(pDownload->m_Queue[pDownload->m_nQueuePos].Host).c_str(),
				pDownload->m_Queue[pDownload->m_nQueuePos].Port,
				pDownload->m_Queue.size());
		pThis->m_more.print("??size>%5s/%-5s  ??percent>%5s  ",
				FormatSize(pDownload->m_dwBytesCompleted).c_str(),
				FormatSize(pDownload->m_dwFileLength).c_str(),
				FormatPercent(pDownload->m_dwBytesCompleted,pDownload->m_dwFileLength).c_str());
		if (pDownload->m_dRate > 0)
			pThis->m_more.print("??speed>%5s/s?? ETA:??time>%s\n",
					FormatSize((int)pDownload->m_dRate).c_str(),
					FormatTime((int) ((pDownload->m_dwFileLength-pDownload->m_dwBytesCompleted)/pDownload->m_dRate)).c_str());
		else
			pThis->m_more.print("??status>%s\n",
					SGnuDownload::GetErrorString(pDownload->m_nDisconnectReason));
	}
	else
		pThis->m_more.print("    INACTIVE for %d sec, reason: ??status>%s\n", pDownload->m_nSecInactive, SGnuDownload::GetErrorString(pDownload->m_nDisconnectReason));
	
	pThis->m_nCounter++;
}

bool MUIPriv::com_info(char * arg)
{
	bool bNet=true, bConn=true, bUpl=true, bDownl=true;
	// parse arg here
	if (arg && strlen(arg))
	{
		bNet=bConn=bUpl=bDownl=false; // start from reseting everything
		CString sArg = StripWhite(arg);
		CString sPar;
		int nPos;
		sArg += " ";// to make parsing simplier
		while (sArg.length()>1) /* this is because of the space at the tail */
		{
			nPos = sArg.find(" ");
			sPar = sArg.substr(0,nPos);
			sArg = StripWhite(sArg.substr(nPos+1));
			sArg += " ";// ah, yeah im to lazy
			//
			if (0==strncmp("network", sPar.c_str(), sPar.length()))
				bNet = true;
			if (0==strncmp("connections", sPar.c_str(), sPar.length()))
				bConn = true;
			if (0==strncmp("uploads", sPar.c_str(), sPar.length()))
				bUpl = true;
			if (0==strncmp("downloads", sPar.c_str(), sPar.length()))
				bDownl = true;
			if (0==strncmp("transfers", sPar.c_str(), sPar.length()))
			{
				bUpl = true;
				bDownl = true;
			}
		}
	}
	//
	if (bNet)
	{
		m_more.print("??header>network horizon:\n");
		m_more.print("??header>----------------\n");
		int nHosts, nSharingHosts, nFiles, nSize;
		m_pController->GetNetStats(nHosts, nSharingHosts, nFiles, nSize);
		//m_more.print("%d %d %d\n",nHosts, nFiles, nSize);
		m_more.print("ReachebleHosts: ??num>%s??  SharingHists: ??num>%s??  Files: ??num>%s??  Capacity:??num> %s\n\n",
				FormatSize(nHosts).c_str(),
				FormatSize(nSharingHosts).c_str(),
				FormatSize(nFiles).c_str(),
				FormatMSize(nSize).c_str());
		m_more.print("??header>sockets:\n");
		m_more.print("??header>--------\n");
		int nConn, nUpl, nDownl;
		m_pController->GetConnStats(nConn, nUpl, nDownl);
		m_more.print("Network: ??num>%d??  Uploads: ??num>%d??  Downloads: ??num>%d\n\n",nConn, nUpl, nDownl);
		m_more.print("??header>bandwidth:\n");
		m_more.print("??header>----------\n");
		m_pController->GetBandwidthStats(nConn, nUpl, nDownl);	
		m_more.print("Network:??speed>%s/s??  Uploads:??speed>%s/s??  Downloads:??speed>%s/s??  Total:??speed>%s/s??\n\n",
				FormatSize(nConn).c_str(),
				FormatSize(nUpl).c_str(),
				FormatSize(nDownl).c_str(),
				FormatSize(nConn+nUpl+nDownl).c_str());
	}
	//
	if (bConn)
	{
		m_more.print("??header>gnutella network connections:\n");
		m_more.print("??header>-----------------------------\n");
		m_nCounter = 1;
		m_vecConnIDs.clear();
		m_pController->ForEachConnection((void*)this, infoConnCallback);
		m_more.print("total connections: ??num>%d??  rate: [??speed>%5s??|??speed>%-5s??]/sec\n\n",
			   m_nCounter-1,
			   FormatSize(m_pController->GetConnRateRecv()).c_str(),
			   FormatSize(m_pController->GetConnRateSend()).c_str());
	}
	//
	m_nCounter = 1;
	if (bUpl)
	{
		m_more.print("??header>uploads:\n");
		m_more.print("??header>--------\n");
		m_vecTransIDs.clear();
		m_pController->ForEachUpload((void*)this, infoUploadCallback);
	}
	//
	if (bDownl)
	{
		m_more.print("??header>downloads:\n");
		m_more.print("??header>----------\n");
		if (!bUpl)
			m_vecTransIDs.clear();
		m_pController->ForEachDownload((void*)this, infoDownloadCallback);
	}
	if (bUpl && bDownl)
		m_more.print("total transfers: ??num>%d\n", m_nCounter-1);
	else if (bUpl)
		m_more.print("total uploads: ??num>%d\n", m_nCounter-1);
	else if (bDownl)
		m_more.print("total downloads: ??num>%d\n", m_nCounter-1);
	return true;
}

// HOST STATS:  Hosts: 47     Files: 9.67K   Size: 54.277G
// NET STATS:   Msg Received: 1.21K    Msg Sent: 320
//              Bytes Rcvd: 93.05K        Bytes Sent: 14.42K
// QUERY STATS: Queries: 839      Responses Sent: 3
// SHARE STATS: Num Shared: 37    Size Shared: 21.577G
// CONNECTION STATS:
// -----------------
// 1)134.94.132.6:37180    Packs:    189:843        1:3    Bytes:   8.40K:70.57K
//    TID: 3076    Type: IN   State:    UP  Rate:    286:2.35K  /sec
// 2)160.85.131.131:1270   Packs:     94:397       11:2    Bytes:   4.03K:22.48K
//    TID: 4101    Type: IN   State:    UP  Rate:    275:1.50K  /sec
// 3)212.151.25.42:1093    Packs:      0:0          0:0    Bytes:       0:0
//    TID: 7175    Type: IN   State:    UP  Rate:      0:0      /sec
// TOTALS: Rate:   561:3.85K /s  Sent: 283
//
// TRANSFER STATS:
// -in------------
// 1)212.120.75.80:6346  R:0  0.0%         0/697.604M        0/sec ETA: 0s
//   State: UP   Name: The Cell.avi
// -out------------
// TOTALS: Rate:     0:0     /sec

bool MUIPriv::com_hosts(char * arg)
{
	std::list<Node> hosts;
	m_pController->GetNodeCache(hosts);
	if (hosts.size())
	{
		m_more.print("??header>discovered hosts\n");
		m_more.print("??header>----------------\n");
		for (std::list<Node>::iterator it = hosts.begin(); it != hosts.end(); ++it)
		{
			m_more.print("??ip>%16s:%-4d ??num>%6d  ??size>%5s  ??speed>%s\n",
				IPtoStr(it->Host).c_str(), it->Port,
				it->ShareCount,
				FormatKSize(it->ShareSize).c_str(),
				GetSpeedString(it->Speed).c_str());
		}
		m_more.print("total: ??num>%d\n", hosts.size());
	}
	else
	{
		m_more.print("??message>hosts cache is empty\n");
	}
}

bool MUIPriv::com_close(char * arg)
{
	intSet seq;
	int nConn, nUpl, nDownl;
	m_pController->GetConnStats(nConn, nUpl, nDownl);
	if (!ParseNumRanges(seq, arg, nConn))
	{
		m_more.print("??error>close: failed to parse parameters\n");
		return false;
	}
	for(intSet::iterator it = seq.begin(); it != seq.end(); it++)
	{
		if (m_vecConnIDs.size()<*it)
			break;
		m_pController->CloseConnectionByID(m_vecConnIDs[(*it)-1]);
	}
	return true;
}

bool MUIPriv::stop_help(LPCSTR szCom,bool bDelPart, char * arg)
{
	intSet seq;
	int nConn, nUpl, nDownl;
	m_pController->GetConnStats(nConn, nUpl, nDownl);
	if (!ParseNumRanges(seq, arg, nUpl+nDownl))
	{
		m_more.print("??error>%s: failed to parse parameters\n", szCom);
		return false;
	}
	for(intSet::iterator it = seq.begin(); it != seq.end(); it++)
	{
		if (m_vecTransIDs.size()<*it)
			break;
		m_pController->RemoveTransferByID(m_vecTransIDs[(*it)-1], bDelPart);
	}
	return true;
}

bool MUIPriv::com_stop(char * arg)
{
	return stop_help("stop", false, arg);
}

bool MUIPriv::com_kill(char * arg)
{
	return stop_help("kill", true, arg);
}

bool MUIPriv::com_open(char * arg)
{
	int nPort = 6346;
	arg = StripWhite ( arg );
	char* pPort = strchr(arg,':');
	if (pPort == NULL)
		pPort = strchr(arg,' ');
	if ( pPort )
	{
		*pPort='\0';
		nPort = atoi(pPort+1);
		if (nPort<1024)
			nPort = 6346;
	}
	if (strlen(arg))
	{
		m_more.print("??message>opening connection to '??ip>%s??message>' port ??num>%d\n", arg, nPort);
		m_pController->OpenConnection(arg, nPort);
		return true;
	}
	return false;
}

void snprintProp(char* buf, int n, MProperty* pP)
{
	const char* t;
	IP ip;
	switch (pP->GetPropType()){
		case PT_BOOL: snprintf(buf, n, pP->GetBoolValue() ? "true" : "false");
			break;
		case PT_INT: snprintf(buf, n, "%d", pP->GetIntValue());
			break;
		case PT_DWORD: snprintf(buf, n, "%u", pP->GetDwordValue());
			break;
		case PT_DOUBLE: snprintf(buf, n, "%.3g", pP->GetDoubleValue());
			break;
		case PT_STRING:
		    t = pP->GetStringValue();
		    snprintf(buf, n, "`%s'", t);
			break;
		case PT_IP:
			ip = pP->GetIpValue();
			snprintf(buf, n, "%d.%d.%d.%d", ip._ip.a, ip._ip.b, ip._ip.c, ip._ip.d);
			break;
		default:
			snprintf(buf, n, "??error>unsupported type??");
	}
	buf[n-1]='\0';
}

bool MUIPriv::com_set(char * arg)
{
	return set_helper(m_pController->GetPropertyContainer(), arg);
}

bool MUIPriv::com_color(char * arg)
{
	return set_helper(&m_more.m_propClr, arg);
}

bool MUIPriv::set_helper(MPropertyContainer* pPC, char * arg)
{
	//
	char tmp[1024];
	CString sArg = StripWhite(arg);
	sArg += ' ';
	int nSpacePos = sArg.find(" ");
	CString sPropName = sArg.substr(0,nSpacePos);
	CString sPropVal = StripWhite(sArg.substr(nSpacePos+1));
	if (sPropName.length())
	{
		MProperty* pP = pPC->FindProperty(sPropName.c_str());
		if (pP)
		{
			if (sPropVal.length())
			{
				strncpy(tmp,sPropVal.c_str(),1024);
				if(!pP->SetFromStr(tmp))
				{
					m_more.print("??error>failed to parse `%s'\n", sPropVal.c_str());
					return false;
				}
			}
			else
			{
				snprintProp(tmp,1024,pP);
		        m_more.print("??variable>%s?? = ??value>%s\n", pP->GetPropertyName(), tmp);
			}
			return true;
		}
		m_more.print("??error>there is no `%s' variable\n", sPropName.c_str());
		return false;
	}
	//
	std::set<CString> propset;
	MPropertyContainer::iterator it;
	for (it = pPC->begin(); it!= pPC->end(); it++)
	{
		propset.insert(pPC->GetPropertyName(it));;
		//cout << propset.size() << ") " << pPC->GetPropertyName(it) << endl;
	}
	int s = propset.size();
	MPropertyContainer::sec_iterator its;
	for (its=pPC->sec_begin(); its!= pPC->sec_end(); its++)
	{
		MPropertySection* pS = pPC->GetSection(its);
		m_more.print("[ %s ]\n",pPC->GetSectionName(its));
		for (it = pS->begin();it!=pS->end();it++)
		{
			MProperty* pP = pPC->GetProperty(it);
			snprintProp(tmp,1024,pP);
			m_more.print("??variable>%32s?? = ??value>%s\n", pPC->GetPropertyName(it), tmp);
			propset.erase(pPC->GetPropertyName(it));
			//cout << propset.size() << ") " << pPC->GetPropertyName(it) << endl;
		}
	}
	if (propset.size())
	{
		if (pPC->HasSections())
			m_more.print("*** no section assigned ***\n");
		for (std::set<CString>::iterator itn = propset.begin(); itn!=propset.end();itn++)
		{
			MProperty* pP = pPC->FindProperty(itn->c_str());
			ASSERT(pP);
			if (pP)
			{
				snprintProp(tmp,1024,pP);
				m_more.print("??variable>%32s?? = ??value>%s\n", itn->c_str(), tmp);
			}
		}
	}
	return true;
}


struct getParams{
	MUIPriv* pThis;
	intSet   seq;
};


bool MUIPriv::com_get(char * arg)
{
	getParams gp;
	gp.pThis = this;
	
	if (!ParseNumRanges(gp.seq, arg, m_vecResIDs.size()))
	{
		m_more.print("??error>get: failed to parse parameters\n");
		return false;
	}
	if (gp.seq.empty())
	{
		m_more.print("??error>get requires numeric parameters\n");
		return false;
	}
	//
	ResultVec resVec;
	std::queue<int> toErase;
	for (intSet::iterator it=gp.seq.begin();it!=gp.seq.end(); ++it)
	{
		if (*it <= m_vecResIDs.size() && m_pController->GetResultsByID(m_vecResIDs[(*it)-1],resVec))
		{
			ASSERT(resVec.size());
			m_more.print("??message>starting download of ??name>%s\n", resVec[0].Name.c_str());
			m_pController->AddDownload(resVec);
			//
			resVec.clear();
			toErase.push(*it);
		}
	}
	while (toErase.size())
	{
		gp.seq.erase(toErase.front());
		toErase.pop();
	}	
	if (gp.seq.empty())
		return true;
	m_more.print("??error>no results with number(s)");
	for (intSet::iterator it=gp.seq.begin(); it!=gp.seq.end(); it++)
	{
		m_more.print(" ??error>%d", (*it));
	}
	m_more.print("\n");
	return false;
}

bool MUIPriv::com_scan(char * arg)
{
	m_pController->Rescan();
	return true;
}

bool MUIPriv::com_library(char * arg)
{
	std::vector<SharedFile> SharedFiles;
	m_pController->GetSharedFiles(SharedFiles);
	if (SharedFiles.size()==0)
	{
		m_more.print("??message>no files shared\n");
		return true;
	}
	m_more.print("??header>shared files\n");
	m_more.print("??header>============\n");
	int nCounter = 1;
	for (std::vector<SharedFile>::iterator itFile = SharedFiles.begin(); itFile != SharedFiles.end(); itFile++, nCounter++)
	{
		m_more.print("??id>%4d)?? ??name>%-42s ??size>%5s??  hits:??num>%-5d?? uploads:??num>%-4d\n",nCounter,
			   InsertElypsis(itFile->Name, 42).c_str(),
			   FormatSize(itFile->Size).c_str(),
			   itFile->Matches,itFile->Uploads);
	}
	return true;
}

bool MUIPriv::com_version(char * arg)
{
	m_more.print("??message>You are currently using Mutella v%s\n  ??flag1>Enjoy!\n", VERSION);
}

