/***************************************************************************
                          conversions.cpp  -  description
                             -------------------
    begin                : Tue May 29 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

// the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "mutella.h"
#include "packet.h"
#include "conversions.h"
#include "mthread.h"

#ifdef _DEBUG
#include <time.h>
#endif

CString DWrdtoStr(DWORD in)
{
	//char buff[16];
	//::sprintf (buff, "%u", in);
	//return buff;
	CString sTmp;
	return sTmp.format("%u", in);
}

CString IPtoStr(IP in)
{
    char buffer[20];
    ::sprintf(buffer,"%d.%d.%d.%d",in._ip.a,in._ip.b,in._ip.c,in._ip.d);
	return buffer;
}

IP StrtoIP(CString in)
{
#ifdef _DEBUG
	time_t t;
#endif
	IP out;
	MLock lock(g_LibcMutex);
	out.S_addr = 0;
	// TODO: this doesnt seem to be thread safe
#ifdef _DEBUG
	t=time(NULL);
#endif
	hostent * phe = ::gethostbyname(in.c_str());
	if (NULL != phe)
	{
		// unpack the address -- quick and ...
		// TODO: check if it is correct
		memcpy(&out, phe->h_addr_list[0], 4);
	}
#ifdef _DEBUG
	if (time(NULL)-t>1)
	{
		TRACE("StrtoIP: blocking in gethostbyname");
	}
#endif
	return out;
}

CString ExIPtoStr(ExIP in)
{
	char buffer[20];
	::sprintf(buffer, "%d.%d.%d.%d:%s", in.a, in.b, in.c, in.d,
	                  (in.mode == DENY) ? "Deny" : "Allow" );

	CString out = buffer;

	//TODO: out.Replace("-1", "*");

	return out;
}

ExIP StrtoExIP(CString in)
{
	char rawMode[16] = "";

	//TODO: in.Replace("*", "-1");
	ReplaceSubStr(in,"*", "-1");

	int  a = 0, b = 0, c = 0, d = 0;

	::sscanf (in.c_str(), "%d.%d.%d.%d:%s", &a, &b, &c, &d, rawMode);

	ExIP out;
	out.a = a;	out.b = b;	out.c = c;	out.d = d;
	
	if(0==strcasecmp(rawMode,"ALLOW"))
		out.mode = ALLOW;
	else
		out.mode = DENY;

	return out;
}

CString CommaIze(CString in)
{
    assert(0);
	/*if (in.length() > 3)
	{
		return CommaIze(in.left(in.length() - 3)) + "," + in.right(3);
	}
	else*/
		return in;
}

CString InsertDecimal(double dNumber)
{
	if(dNumber <= 0.00)
		return "0.00";

	int    decimal, sign;
	//char*  buffer;
    assert(0);
	CString strNumber;/*( _fcvt( dNumber, 2, &decimal, &sign));
	
	if(decimal == 0)
		strNumber.Insert(0, "0.");
	else if(decimal == -1)
		strNumber.Insert(0, "0.0");
	else if(decimal < -1)
		return "0.00";
	else
		strNumber.Insert(decimal, '.');*/

	return strNumber;
}

CString GetPercentage(DWORD dWhole, DWORD dPart)
{
	CString result = "0.00";
    assert(0);
    /*
	if(dPart > dWhole)
		dPart = dWhole;

	if(dWhole)
	{
		result = DWrdtoStr(dPart * 10000 / dWhole);

		if(result.GetLength() > 2)
			result.Insert( result.GetLength() - 2, ".");
		else
		{
			switch(result.GetLength())
			{
			case 2:
				result.Insert(0, "0.");
				break;
			case 1:
				result.Insert(0, "0.0");
				break;
			default:
				result = "0.00";
				break;
			}
		}
	}
    */
	return result + " %";
}

DWORD GetSpeedinBytes(CString Speed)
// The protocol is messed, bytes are bits 
{
	if(Speed == "Cell Modem")
		return 0;
	if(Speed == "14.4 Modem")
		return 14;
	if(Speed == "28.8 Modem")
		return 28;
	if(Speed == "56K Modem")
		return 53;
	if(Speed == "ISDN")
		return 128;
	if(Speed == "Cable")
		return 384;
	if(Speed == "DSL")
		return 768;
	if(Speed == "T1")
		return 1500;
	if(Speed == "T3 or Better")
		return 45000;
	
	return atol(Speed.c_str());
}

CString GetSpeedString(DWORD dwSpeed)
// The protocol is messed, bytes are bits 
{
	if(dwSpeed >= 45000)
		return "T3 or Better";
	if(dwSpeed >= 1500)
		return "T1";
	if(dwSpeed >= 768)
		return "DSL";
	if(dwSpeed >= 384)
		return "Cable";
	if(dwSpeed >= 128)
		return "ISDN";
	if(dwSpeed >= 53)
		return "56K Modem";
	if(dwSpeed >= 28)
		return "28.8 Modem";
	if(dwSpeed >= 14)
		return "14.4 Modem";
	else
		return "Cell Modem";
}

bool ValidVendor(CString VendorID)
{
	if(GetVendor(VendorID) == "Unknown")
		return false;
	
	return true;
}

CString GetVendor(CString VendorID)
{
	MakeUpper(VendorID);

	if(VendorID == "BEAR") return "BearShare";
	
	if(VendorID == "GNOT") return "Gnotella";
	
	if(VendorID == "GNUC") return "Gnucleus";

	if(VendorID == "HSLG") return "Hagelslag";
	
	if(VendorID == "LIME") return "LimeWire";
	
	if(VendorID == "MACT") return "Mactella";
	
	if(VendorID == "TOAD") return "ToadNode";

	if(VendorID == "GNUT") return "Gnut";

	if(VendorID == "GTKG") return "Gtk-Gnutella";

	if(VendorID == "NAPS") return "NapShare";

	if(VendorID == "OCFG") return "OCFolders";
	
	if(VendorID == "MUTE") return "Mutella";


	return "Unknown";
}
